// Copyright (c) 2013 Dominik Kocuj <dominik@kocuj.pl>
// License: http://www.gnu.org/licenses/gpl-2.0.html

// thanks prototype constructor
function kocujAdmin1ClassThanks() {
	// get settings
	if (typeof kocujAdmin1ThanksSettings != 'undefined') {
		if (typeof kocujAdmin1ThanksSettings.apiUrl != 'undefined') {
			this._settingsApiUrl = kocujAdmin1ThanksSettings.apiUrl;
		}
		if (typeof kocujAdmin1ThanksSettings.apiLogin != 'undefined') {
			this._settingsApiLogin = kocujAdmin1ThanksSettings.apiLogin;
		}
		if (typeof kocujAdmin1ThanksSettings.apiPassword != 'undefined') {
			this._settingsApiPassword = kocujAdmin1ThanksSettings.apiPassword;
		}
		if (typeof kocujAdmin1ThanksSettings.websiteURL != 'undefined') {
			this._settingsWebsiteURL = kocujAdmin1ThanksSettings.websiteURL;
		}
		if (typeof kocujAdmin1ThanksSettings.websiteTitle != 'undefined') {
			this._settingsWebsiteTitle = kocujAdmin1ThanksSettings.websiteTitle;
		}
		if (typeof kocujAdmin1ThanksSettings.websiteDescription != 'undefined') {
			this._settingsWebsiteDescription = kocujAdmin1ThanksSettings.websiteDescription;
		}
		if (typeof kocujAdmin1ThanksSettings.adminUrl != 'undefined') {
			this._settingsAdminUrl = kocujAdmin1ThanksSettings.adminUrl;
		}
		if (typeof kocujAdmin1ThanksSettings.loadingImageURL != 'undefined') {
			this._settingsLoadingImageURL = kocujAdmin1ThanksSettings.loadingImageURL;
		}
		if (typeof kocujAdmin1ThanksSettings.textSending != 'undefined') {
			this._settingsTextSending = kocujAdmin1ThanksSettings.textSending;
		}
		if (typeof kocujAdmin1ThanksSettings.textInformationAlreadySent != 'undefined') {
			this._settingsTextInformationAlreadySent = kocujAdmin1ThanksSettings.textInformationAlreadySent;
		}
		if (typeof kocujAdmin1ThanksSettings.textCorrect != 'undefined') {
			this._settingsTextCorrect = kocujAdmin1ThanksSettings.textCorrect;
		}
		if (typeof kocujAdmin1ThanksSettings.textErrorTryAgain != 'undefined') {
			this._settingsTextErrorTryAgain = kocujAdmin1ThanksSettings.textErrorTryAgain;
		}
		if (typeof kocujAdmin1ThanksSettings.textError != 'undefined') {
			this._settingsTextError = kocujAdmin1ThanksSettings.textError;
		}
		if (typeof kocujAdmin1ThanksSettings.textMoreTitle != 'undefined') {
			this._settingsTextMoreTitle = kocujAdmin1ThanksSettings.textMoreTitle;
		}
		if (typeof kocujAdmin1ThanksSettings.textLoading != 'undefined') {
			this._settingsTextLoading = kocujAdmin1ThanksSettings.textLoading;
		}
		if (typeof kocujAdmin1ThanksSettings.textLoadingError != 'undefined') {
			this._settingsTextLoadingError = kocujAdmin1ThanksSettings.textLoadingError;
		}
	}
}

// thanks prototype
kocujAdmin1ClassThanks.prototype = {
	// internal name
	_internalName : new Array(),
	// timer
	_timer : null,
	// retries
	_retries : 0,
	// settings
	_settingsApiUrl : '',
	_settingsApiLogin : '',
	_settingsApiPassword : '',
	_settingsWebsiteURL : '',
	_settingsWebsiteTitle : '',
	_settingsWebsiteDescription : '',
	_settingsAdminUrl : '',
	_settingsLoadingImageURL : '',
	_settingsTextSending : '',
	_settingsTextInformationAlreadySent : '',
	_settingsTextCorrect : '',
	_settingsTextErrorTryAgain : '',
	_settingsTextError : '',
	_settingsTextMoreTitle : '',
	_settingsTextLoading : '',
	_settingsTextLoadingError : '',

	// set internal name
	setInternalName : function(internalName, id) {
		// set internal name
		this._internalName['pos' + parseInt(id)] = internalName;
	},

	// set sending thanks information form elements
	setForm : function(id) {
		(function($) {
			// check data
			id = parseInt(id);
			// add confirmation event
			if ($('#kocujadmin1thanks #kocujadmin1thanksconfirm').length > 0) {
				$('#kocujadmin1thanks #kocujadmin1thanksconfirm').attr('href', 'javascript:void(0);');
				$('#kocujadmin1thanks #kocujadmin1thanksconfirm').bind('click.kocujThanks1', function() {
					kocujAdmin1Thanks._confirmEvent(id);
				});
				$('#kocujadmin1thanks #kocujadmin1thankscancel').attr('href', 'javascript:void(0);');
				$('#kocujadmin1thanks #kocujadmin1thankscancel').bind('click.kocujThanks1', function() {
					kocujAdmin1Thanks._cancelEvent(id);
				});
			}
			if ($('#kocujadmin1aboutthanksdiv #kocujadmin1aboutthanksconfirm').length > 0) {
				$('#kocujadmin1aboutthanksdiv #kocujadmin1aboutthanksconfirm').attr('href', 'javascript:void(0);');
				$('#kocujadmin1aboutthanksdiv #kocujadmin1aboutthanksconfirm').bind('click.kocujThanks1', function() {
					kocujAdmin1Thanks._confirmEvent(id);
				});
			}
			if ($('#kocujadmin1thanks  #kocujadmin1thanksmore').length > 0) {
				$('#kocujadmin1thanks  #kocujadmin1thanksmore').attr('href', 'javascript:void(0);');
				$('#kocujadmin1thanks  #kocujadmin1thanksmore').bind('click.kocujThanks1', function() {
					kocujAdmin1Thanks._moreEvent(id);
				});
			}
			if ($('#kocujadmin1aboutthanksdiv #kocujadmin1aboutthanksmore').length > 0) {
				$('#kocujadmin1aboutthanksdiv #kocujadmin1aboutthanksmore').attr('href', 'javascript:void(0);');
				$('#kocujadmin1aboutthanksdiv #kocujadmin1aboutthanksmore').bind('click.kocujThanks1', function() {
					kocujAdmin1Thanks._moreEvent(id);
				});
			}
		}(jQuery));
	},

	// AJAX loading success
	_ajaxSuccess : function(id, type, callback, data, status, obj) {
		(function($) {
			// parse data
			id = parseInt(id);
			// deactivate AJAX timeout
			kocujAdmin1Thanks._deactivateAJAXTimeout();
			// parse response
			if (callback != '') {
				eval(callback + '(id, type, data);');
			}
		}(jQuery));
	},

	// AJAX loading error
	_ajaxError : function(id, type, callback, obj, status, err) {
		(function($) {
			// parse data
			id = parseInt(id);
			// parse error
			if (callback != '') {
				eval(callback + '(id, type);');
			}
		}(jQuery));
	},

	// activate AJAX timeout
	_activateAJAXTimeout : function(id, type, callback) {
		// set timer
		kocujAdmin1Thanks._timer = window.setTimeout('kocujAdmin1Thanks._ajaxError("' + id + '", "' + type.toString().replace('"', '\\"') + '", "' + callback.toString().replace('"', '\\"') + '");', 30000);
	},

	// deactivate AJAX timeout
	_deactivateAJAXTimeout : function() {
		// clear timer
		window.clearTimeout(kocujAdmin1Thanks._timer);
	},

	// confirm event
	_confirmEvent : function(id) {
		(function($) {
			// check data
			id = parseInt(id);
			// show loading circle
			if ($('#kocujadmin1thanks').length > 0) {
				$('#kocujadmin1thanks #kocujadmin1thankstextdiv').hide();
				$('#kocujadmin1thanks #kocujadmin1thanksemptydiv').hide();
				$('#kocujadmin1thanks #kocujadmin1thanksmorediv').hide();
				$('#kocujadmin1thanks #kocujadmin1thanksoptionsdiv').html('<p><img src="' + kocujAdmin1Thanks._settingsLoadingImageURL + '" alt="" style="position: absolute;" /><span style="margin-left: 25px;"><strong>' + kocujAdmin1Thanks._settingsTextSending + '</strong></span></p>');
			}
			if ($('#kocujadmin1aboutthanksdiv #kocujadmin1aboutthankstextdiv').length > 0) {
				if ($('#kocujadmin1aboutthanksdiv #kocujadmin1aboutthanksconfirm').length > 0) {
					$('#kocujadmin1aboutthanksdiv #kocujadmin1aboutthanksconfirm').remove();
				}
				$('#kocujadmin1aboutthanksdiv #kocujadmin1aboutthanksinfodiv').hide();
				$('#kocujadmin1aboutthanksdiv #kocujadmin1aboutthankstextdiv').html('<img src="' + kocujAdmin1Thanks._settingsLoadingImageURL + '" alt="" style="position: absolute;" /><span style="margin-left: 25px;"><strong>' + kocujAdmin1Thanks._settingsTextSending + '</strong></span>');
				$('#kocujadmin1aboutthanksdiv #kocujadmin1aboutthankstextdiv').show();
			}
			// call AJAX
			kocujAdmin1Thanks._activateAJAXTimeout(id, 'confirm', 'kocujAdmin1Thanks._confirmationErrorCallback');
			if ($().jquery < '1.6') {
				var data = {
					'requestType': 'parameters',
					'responseType': 'JSON',
					'requestMethod': 'GET',
					'data[PARAMETER_version]': 1,
					'data[header][login]': kocujAdmin1Thanks._settingsApiLogin,
					'data[header][password]': kocujAdmin1Thanks._settingsApiPassword,
					'data[request][PARAMETER_command]': 'ADD_THANKS',
					'data[request][url]': kocujAdmin1Thanks._settingsWebsiteURL,
					'data[request][title]': kocujAdmin1Thanks._settingsWebsiteTitle,
					'data[request][description]': kocujAdmin1Thanks._settingsWebsiteDescription
				};
			} else {
				var data = {
					'requestType': 'parameters',
					'responseType': 'JSON',
					'requestMethod': 'GET',
					'data' : {
						'PARAMETER_version': 1,
						'header' : {
							'login': kocujAdmin1Thanks._settingsApiLogin,
							'password': kocujAdmin1Thanks._settingsApiPassword
						},
						'request': {
							'PARAMETER_command': 'ADD_THANKS',
							'url': kocujAdmin1Thanks._settingsWebsiteURL,
							'title': kocujAdmin1Thanks._settingsWebsiteTitle,
							'description': kocujAdmin1Thanks._settingsWebsiteDescription
						}
					}
				};
			}
			$.ajax({
				url: kocujAdmin1Thanks._settingsApiUrl + '',
				async: true,
				cache: false,
				data: data,
				dataType: 'jsonp',
				success: function(data, status, obj) { kocujAdmin1Thanks._ajaxSuccess(id, 'confirm', 'kocujAdmin1Thanks._confirmationCallback', data, status, obj); },
				jsonpCallback: 'kocujadmin1confirmcallback',
				type: 'GET'
			});
		}(jQuery));
	},

	// cancel event
	_cancelEvent : function(id) {
		(function($) {
			// hide elements to send thanks
			if ($('#kocujadmin1thanks').length > 0) {
				$('#kocujadmin1thanks').hide();
			}
			// send cancel
			$.ajax({
				url: kocujAdmin1Thanks._settingsAdminUrl,
				async: true,
				cache: false,
				data: 'kocujadmin1thankscancel=' + kocujAdmin1Thanks._internalName['pos' + id],
				dataType: 'html',
				error: function(obj, status, err) { kocujAdmin1Thanks._ajaxError(id, 'cancelsave', '', obj, status, err); },
				success: function(data, status, obj) { kocujAdmin1Thanks._ajaxSuccess(id, 'cancelsave', '', data, status, obj); },
				type: 'GET'
			});
		}(jQuery));
	},

	// show more information event
	_moreEvent : function(id) {
		(function($) {
			// check data
			id = parseInt(id);
			// prepare modal window
			var totalHeight = parseInt($(window).height())-200;
			if (totalHeight < 140) {
				totalHeight = 140;
			}
			kocujAdmin1Modal.prepareModal('<div id="kocujadmin1_thanksheader_' + id + '">' + kocujAdmin1Thanks._settingsTextMoreTitle + '</div><div id="kocujadmin1_thanks_' + id + '"><em>' + kocujAdmin1Thanks._settingsTextLoading + '</em></div>', 600, totalHeight, id);
			// set style
			$('#kocujadmin1_thanksheader_' + id).css({
				'font-size': '13px',
				'text-align': 'center',
				'font-weight': 'normal',
				'line-height': '28px',
				'width': '600px',
				'height': '28px',
				'color': '#cccccc',
				'background-color': '#464646'
			});
			$('#kocujadmin1_thanks_' + id).css({
				'font-size': '12px',
				'text-align': 'left',
				'font-weight': 'normal',
				'width': '580px',
				'height': parseInt(totalHeight-28-20) + 'px',
				'padding': '10px 10px 10px 10px',
				'color': '#464646',
				'background-color': '#ffffff',
				'border-bottom-color': '#000000',
				'border-bottom-style': 'solid',
				'border-bottom-width': '0px',
				'overflow': 'auto'
			});
			// call AJAX
			$.ajax({
				url: kocujAdmin1Thanks._settingsAdminUrl,
				async: true,
				cache: false,
				data: 'kocujadmin1thanks=' + kocujAdmin1Thanks._internalName['pos' + id],
				dataType: 'html',
				error: function(obj, status, err) { kocujAdmin1Thanks._ajaxError(id, 'more', 'kocujAdmin1Thanks._moreErrorCallback', obj, status, err); },
				success: function(data, status, obj) { kocujAdmin1Thanks._ajaxSuccess(id, 'more', 'kocujAdmin1Thanks._moreCallback', data, status, obj); },
				type: 'GET'
			});
			// show window
			kocujAdmin1Modal.showPreparedModal(id, 1.0);
		}(jQuery));
	},

	// save confirmation
	_confirmationCallback : function(id, type, data) {
		(function($) {
			// check response status
			if (data.status.id != 'OK') {
				if (data.status.id == 'CT_ADD_THANKS_URLALREADYEXISTS') {
					if ($('#kocujadmin1thanks').length > 0) {
						$('#kocujadmin1thanks #kocujadmin1thankstextdiv').hide();
						$('#kocujadmin1thanks #kocujadmin1thanksmorediv').hide();
						$('#kocujadmin1thanks #kocujadmin1thanksoptionsdiv').show();
						$('#kocujadmin1thanks #kocujadmin1thanksemptydiv').hide();
						$('#kocujadmin1thanks #kocujadmin1thanksoptionsdiv').html('<p><strong>' + kocujAdmin1Thanks._settingsTextInformationAlreadySent + '</strong></p>');
					}
					if ($('#kocujadmin1aboutthanksdiv #kocujadmin1aboutthankstextdiv').length > 0) {
						$('#kocujadmin1aboutthanksdiv #kocujadmin1aboutthankstextdiv').html('<strong>' + kocujAdmin1Thanks._settingsTextInformationAlreadySent + '</strong>');
						$('#kocujadmin1aboutthanksdiv #kocujadmin1aboutthankstextdiv').show();
					}
				} else {
					kocujAdmin1Thanks._confirmationErrorCallback(id, type);
					return;
				}
			} else {
				if ($('#kocujadmin1thanks').length > 0) {
					$('#kocujadmin1thanks #kocujadmin1thankstextdiv').show();
					$('#kocujadmin1thanks #kocujadmin1thanksmorediv').hide();
					$('#kocujadmin1thanks #kocujadmin1thanksoptionsdiv').hide();
					$('#kocujadmin1thanks #kocujadmin1thanksemptydiv').hide();
					$('#kocujadmin1thanks #kocujadmin1thankstextdiv').html('<p><strong>' + kocujAdmin1Thanks._settingsTextCorrect + '</strong></p>');
				}
				if ($('#kocujadmin1aboutthanksdiv #kocujadmin1aboutthankstextdiv').length > 0) {
					$('#kocujadmin1aboutthanksdiv #kocujadmin1aboutthankstextdiv').html('<strong>' + kocujAdmin1Thanks._settingsTextCorrect + '</strong>');
					$('#kocujadmin1aboutthanksdiv #kocujadmin1aboutthankstextdiv').show();
				}
			}
			// save confirmation
			$.ajax({
				url: kocujAdmin1Thanks._settingsAdminUrl,
				async: true,
				cache: false,
				data: 'kocujadmin1thanksconfirm=' + kocujAdmin1Thanks._internalName['pos' + id],
				dataType: 'html',
				error: function(obj, status, err) { kocujAdmin1Thanks._ajaxError(id, 'confirmsave', '', obj, status, err); },
				success: function(data, status, obj) { kocujAdmin1Thanks._ajaxSuccess(id, 'confirmsave', '', data, status, obj); },
				type: 'GET'
			});
		}(jQuery));
	},

	// save confirmation - error
	_confirmationErrorCallback : function(id, type) {
		(function($) {
			// set retries
			kocujAdmin1Thanks._retries++;
			// show error
			if (kocujAdmin1Thanks._retries < 3) {
				if ($('#kocujadmin1thanks').length > 0) {
					$('#kocujadmin1thanks #kocujadmin1thanksoptionsdiv').html('<p><strong>' + kocujAdmin1Thanks._settingsTextErrorTryAgain + '</strong></p>');
				}
				if ($('#kocujadmin1aboutthanksdiv #kocujadmin1aboutthankstextdiv').length > 0) {
					$('#kocujadmin1aboutthanksdiv #kocujadmin1aboutthankstextdiv').html('<strong>' + kocujAdmin1Thanks._settingsTextErrorTryAgain + '</strong>');
					$('#kocujadmin1aboutthanksdiv #kocujadmin1aboutthankstextdiv').show();
				}
			} else {
				if ($('#kocujadmin1thanks').length > 0) {
					$('#kocujadmin1thanks #kocujadmin1thanksoptionsdiv').html('<p><strong>' + kocujAdmin1Thanks._settingsTextError + '</strong></p>');
				}
				if ($('#kocujadmin1aboutthanksdiv #kocujadmin1aboutthankstextdiv').length > 0) {
					$('#kocujadmin1aboutthanksdiv #kocujadmin1aboutthankstextdiv').html('<strong>' + kocujAdmin1Thanks._settingsTextError + '</strong>');
					$('#kocujadmin1aboutthanksdiv #kocujadmin1aboutthankstextdiv').show();
				}
			}
			// check retries
			if (kocujAdmin1Thanks._retries < 3) {
				window.setTimeout('kocujAdmin1Thanks._confirmEvent("' + id + '");', 5000);
			}
		}(jQuery));
	},

	// more information
	_moreCallback : function(id, type, data) {
		(function($) {
			// parse data
			id = parseInt(id);
			// set HTML data
			$('#kocujadmin1_thanks_' + id).html(data);
			// set styles
			$('#kocujadmin1_thanks_' + id + ' ul').css({
				'margin-top': '12px',
				'margin-bottom': '12px'
			});
			$('#kocujadmin1_thanks_' + id + ' ul li').css({
				'margin-bottom': '0px'
			});
		}(jQuery));
	},

	// more information - error
	_moreErrorCallback : function(id, type) {
		(function($) {
			// parse data
			id = parseInt(id);
			// set HTML data
			$('#kocujadmin1_thanks_' + id).html('<strong>' + kocujAdmin1Thanks._settingsTextLoadingError + '</strong>');
		}(jQuery));
	}
};

// initialize
var kocujAdmin1Thanks = new kocujAdmin1ClassThanks();
