// Copyright (c) 2013 Dominik Kocuj <dominik@kocuj.pl>
// License: http://www.gnu.org/licenses/gpl-2.0.html

// license prototype constructor
function kocujAdmin1ClassLicense() {
	// get settings
	if (typeof kocujAdmin1LicenseSettings != 'undefined') {
		if (typeof kocujAdmin1LicenseSettings.adminUrl != 'undefined') {
			this._settingsAdminUrl = kocujAdmin1LicenseSettings.adminUrl;
		}
		if (typeof kocujAdmin1LicenseSettings.textLoading != 'undefined') {
			this._settingsTextLoading = kocujAdmin1LicenseSettings.textLoading;
		}
		if (typeof kocujAdmin1LicenseSettings.textLoadingError != 'undefined') {
			this._settingsTextLoadingError = kocujAdmin1LicenseSettings.textLoadingError;
		}
		if (typeof kocujAdmin1LicenseSettings.textLicense != 'undefined') {
			this._settingsTextLicense = kocujAdmin1LicenseSettings.textLicense;
		}
		if (typeof kocujAdmin1LicenseSettings.textLicenseFor != 'undefined') {
			this._settingsTextLicenseFor = kocujAdmin1LicenseSettings.textLicenseFor;
		}
		if (typeof kocujAdmin1LicenseSettings.textAccept != 'undefined') {
			this._settingsTextAccept = kocujAdmin1LicenseSettings.textAccept;
		}
		if (typeof kocujAdmin1LicenseSettings.textCancel != 'undefined') {
			this._settingsTextCancel = kocujAdmin1LicenseSettings.textCancel;
		}
	}
}

// license prototype
kocujAdmin1ClassLicense.prototype = {
	// license URL
	_url : new Array(),
	// license name
	_name : new Array(),
	// internal name
	_internalName : new Array(),
	// settings
	_settingsAdminUrl : '',
	_settingsTextLoading : '',
	_settingsTextLoadingError : '',
	_settingsTextLicense : '',
	_settingsTextLicenseFor : '',
	_settingsTextAccept : '',
	_settingsTextCancel : '',

	// set license URL
	setURL : function(url, id) {
		// set license URL
		this._url['pos' + parseInt(id)] = url;
	},

	// set license name
	setName : function(name, id) {
		// set license name
		this._name['pos' + parseInt(id)] = name;
	},

	// set internal name
	setInternalName : function(internalName, id) {
		// set internal name
		this._internalName['pos' + parseInt(id)] = internalName;
	},

	// AJAX loading success
	_ajaxSuccess : function(id, data, status, obj) {
		(function($) {
			// parse data
			id = parseInt(id);
			// set HTML data
			$('#kocujadmin1_license_' + id).html(data);
			// set external links
			$('#kocujadmin1_license_' + id + ' a[rel=external]').attr('target', '_blank');
			// show license confirmation
			if ($('#kocujadmin1_licenseconfirm_' + id).length > 0) {
				if ($().jquery < '1.6') {
					$('#kocujadmin1_licenseconfirm_' + id).css('opacity', 0.0);
					$('#kocujadmin1_licenseconfirm_' + id).show();
				}
				$('#kocujadmin1_licenseconfirm_' + id).fadeTo('slow', 1.0);
			}
			if ($('#kocujadmin1_licensecancel_' + id).length > 0) {
				if ($().jquery < '1.6') {
					$('#kocujadmin1_licensecancel_' + id).css('opacity', 0.0);
					$('#kocujadmin1_licensecancel_' + id).show();
				}
				$('#kocujadmin1_licensecancel_' + id).fadeTo('slow', 1.0);
			}
		}(jQuery));
	},

	// AJAX loading error
	_ajaxError : function(id, obj, status, err) {
		(function($) {
			// parse data
			id = parseInt(id);
			// set HTML data
			$('#kocujadmin1_license_' + id).html('<strong>' + kocujAdmin1License._settingsTextLoadingError + '</strong>');
		}(jQuery));
	},

	// show license window
	showLicense : function(acceptButton, id) {
		(function($) {
			// check data
			id = parseInt(id);
			if ((typeof kocujAdmin1License._url['pos' + id] == 'undefined') || (kocujAdmin1License._url['pos' + id] == '')) {
				return;
			}
			if (typeof kocujAdmin1License._name['pos' + id] == 'undefined') {
				return;
			}
			// prepare modal window
			var totalHeight = parseInt($(window).height())-200;
			if (totalHeight < 140) {
				totalHeight = 140;
			}
			var st = kocujAdmin1License._settingsTextLicense;
			if (kocujAdmin1License._name['pos' + id] != '') {
				st = kocujAdmin1License._settingsTextLicenseFor + ' ' + kocujAdmin1License._name['pos' + id];
			}
			kocujAdmin1Modal.prepareModal('<div id="kocujadmin1_licenseheader_' + id + '">' + st + '</div><div id="kocujadmin1_license_' + id + '"><em>' + kocujAdmin1License._settingsTextLoading + '</em></div><div id="kocujadmin1_licensebutton_' + id + '"></div>', 600, totalHeight, id);
			// optionally remove mask event
			if (acceptButton == 1) {
				kocujAdmin1Modal.removeCloseEventFromMask(id);
			}
			// set style
			var divHeight = totalHeight-28-20;
			var borderWidth = 0;
			var divButtonHeight = 0;
			if (acceptButton == 1) {
				divButtonHeight = 40;
				divHeight = totalHeight-28-divButtonHeight-20;
				borderWidth = 1;
			}
			$('#kocujadmin1_licenseheader_' + id).css({
				'font-size': '13px',
				'text-align': 'center',
				'font-weight': 'normal',
				'line-height': '28px',
				'width': '600px',
				'height': '28px',
				'color': '#cccccc',
				'background-color': '#464646'
			});
			$('#kocujadmin1_license_' + id).css({
				'font-family': '"Courier New", Courier, monospace',
				'font-size': '12px',
				'text-align': 'center',
				'font-weight': 'normal',
				'width': '580px',
				'height': divHeight + 'px',
				'padding': '10px 10px 10px 10px',
				'color': '#464646',
				'background-color': '#ffffff',
				'border-bottom-color': '#000000',
				'border-bottom-style': 'solid',
				'border-bottom-width': borderWidth + 'px',
				'overflow': 'auto'
			});
			$('#kocujadmin1_licensebutton_' + id).css({
				'font-size': '12px',
				'text-align': 'center',
				'vertical-align': 'middle',
				'font-weight': 'normal',
				'width': '600px',
				'height': divButtonHeight + 'px',
				'color': '#21759b',
				'background-color': '#ececec'
			});
			// optionally show button
			if (acceptButton == 1) {
				$('#kocujadmin1_licensebutton_' + id).html('<strong><a href="#" id="kocujadmin1_licenseconfirm_' + id + '">' + kocujAdmin1License._settingsTextAccept + '</a></strong><br /><div id="kocujadmin1_licensecancel_' + id+ '">' + kocujAdmin1License._settingsTextCancel + '</div>');
				$('#kocujadmin1_licenseconfirm_' + id).hide();
				$('#kocujadmin1_licensecancel_' + id).hide();
				kocujAdmin1Modal.addCloseEvent('#kocujadmin1_licenseconfirm_' + id, id);
				$('#kocujadmin1_licenseconfirm_' + id).attr('href', 'javascript:void(0);');
				$('#kocujadmin1_licenseconfirm_' + id).bind('click.kocujLicense1', function() {
					$.ajax({
						url: kocujAdmin1License._settingsAdminUrl,
						async: true,
						cache: false,
						data: 'kocujadmin1licenseconfirm=' + kocujAdmin1License._internalName['pos' + id],
						dataType: 'html',
						type: 'GET'
					});
					kocujAdmin1Modal.removeCloseEvent('#kocujadmin1_licenseconfirm_' + id);
					$('#kocujadmin1_licenseconfirm_' + id).unbind('click.kocujLicense1');
				});
			}
			// call AJAX
			$.ajax({
				url: kocujAdmin1License._url['pos' + id],
				async: true,
				cache: false,
				data: '',
				dataType: 'html',
				error: function(obj, status, err) { kocujAdmin1License._ajaxError(id, obj, status, err); },
				success: function(data, status, obj) { kocujAdmin1License._ajaxSuccess(id, data, status, obj); },
				type: 'GET'
			});
			// show window
			kocujAdmin1Modal.showPreparedModal(id, 1.0);
		}(jQuery));
	}
};

// initialize
var kocujAdmin1License = new kocujAdmin1ClassLicense();
