// Copyright (c) 2013 Dominik Kocuj <dominik@kocuj.pl>
// License: http://www.gnu.org/licenses/gpl-2.0.html

// thanks prototype constructor
function kocujAdmin2ClassThanks() {
	// get settings
	if (typeof kocujAdmin2ThanksSettings != 'undefined') {
		if (typeof kocujAdmin2ThanksSettings.apiUrl != 'undefined') {
			this._settingsApiUrl = kocujAdmin2ThanksSettings.apiUrl;
		}
		if (typeof kocujAdmin2ThanksSettings.apiLogin != 'undefined') {
			this._settingsApiLogin = kocujAdmin2ThanksSettings.apiLogin;
		}
		if (typeof kocujAdmin2ThanksSettings.apiPassword != 'undefined') {
			this._settingsApiPassword = kocujAdmin2ThanksSettings.apiPassword;
		}
		if (typeof kocujAdmin2ThanksSettings.websiteURL != 'undefined') {
			this._settingsWebsiteURL = kocujAdmin2ThanksSettings.websiteURL;
		}
		if (typeof kocujAdmin2ThanksSettings.websiteTitle != 'undefined') {
			this._settingsWebsiteTitle = kocujAdmin2ThanksSettings.websiteTitle;
		}
		if (typeof kocujAdmin2ThanksSettings.websiteDescription != 'undefined') {
			this._settingsWebsiteDescription = kocujAdmin2ThanksSettings.websiteDescription;
		}
		if (typeof kocujAdmin2ThanksSettings.adminUrl != 'undefined') {
			this._settingsAdminUrl = kocujAdmin2ThanksSettings.adminUrl;
		}
		if (typeof kocujAdmin2ThanksSettings.loadingImageURL != 'undefined') {
			this._settingsLoadingImageURL = kocujAdmin2ThanksSettings.loadingImageURL;
		}
		if (typeof kocujAdmin2ThanksSettings.textSending != 'undefined') {
			this._settingsTextSending = kocujAdmin2ThanksSettings.textSending;
		}
		if (typeof kocujAdmin2ThanksSettings.textInformationAlreadySent != 'undefined') {
			this._settingsTextInformationAlreadySent = kocujAdmin2ThanksSettings.textInformationAlreadySent;
		}
		if (typeof kocujAdmin2ThanksSettings.textCorrect != 'undefined') {
			this._settingsTextCorrect = kocujAdmin2ThanksSettings.textCorrect;
		}
		if (typeof kocujAdmin2ThanksSettings.textErrorTryAgain != 'undefined') {
			this._settingsTextErrorTryAgain = kocujAdmin2ThanksSettings.textErrorTryAgain;
		}
		if (typeof kocujAdmin2ThanksSettings.textError != 'undefined') {
			this._settingsTextError = kocujAdmin2ThanksSettings.textError;
		}
		if (typeof kocujAdmin2ThanksSettings.textMoreTitle != 'undefined') {
			this._settingsTextMoreTitle = kocujAdmin2ThanksSettings.textMoreTitle;
		}
		if (typeof kocujAdmin2ThanksSettings.textLoading != 'undefined') {
			this._settingsTextLoading = kocujAdmin2ThanksSettings.textLoading;
		}
		if (typeof kocujAdmin2ThanksSettings.textLoadingError != 'undefined') {
			this._settingsTextLoadingError = kocujAdmin2ThanksSettings.textLoadingError;
		}
	}
}

// thanks prototype
kocujAdmin2ClassThanks.prototype = {
	// internal name
	_internalName : new Array(),
	// timer
	_timer : null,
	// retries
	_retries : 0,
	// settings
	_settingsApiUrl : '',
	_settingsApiLogin : '',
	_settingsApiPassword : '',
	_settingsWebsiteURL : '',
	_settingsWebsiteTitle : '',
	_settingsWebsiteDescription : '',
	_settingsAdminUrl : '',
	_settingsLoadingImageURL : '',
	_settingsTextSending : '',
	_settingsTextInformationAlreadySent : '',
	_settingsTextCorrect : '',
	_settingsTextErrorTryAgain : '',
	_settingsTextError : '',
	_settingsTextMoreTitle : '',
	_settingsTextLoading : '',
	_settingsTextLoadingError : '',

	// set internal name
	setInternalName : function(internalName, id) {
		// set internal name
		this._internalName['pos' + parseInt(id)] = internalName;
	},

	// set sending thanks information form elements
	setForm : function(id) {
		(function($) {
			// check data
			id = parseInt(id);
			// add confirmation event
			if ($('#kocujadmin2thanks #kocujadmin2thanksconfirm').length > 0) {
				$('#kocujadmin2thanks #kocujadmin2thanksconfirm').attr('href', 'javascript:void(0);');
				$('#kocujadmin2thanks #kocujadmin2thanksconfirm').bind('click.kocujThanks1', function() {
					kocujAdmin2Thanks._confirmEvent(id);
				});
				$('#kocujadmin2thanks #kocujadmin2thankscancel').attr('href', 'javascript:void(0);');
				$('#kocujadmin2thanks #kocujadmin2thankscancel').bind('click.kocujThanks1', function() {
					kocujAdmin2Thanks._cancelEvent(id);
				});
			}
			if ($('#kocujadmin2aboutthanksdiv #kocujadmin2aboutthanksconfirm').length > 0) {
				$('#kocujadmin2aboutthanksdiv #kocujadmin2aboutthanksconfirm').attr('href', 'javascript:void(0);');
				$('#kocujadmin2aboutthanksdiv #kocujadmin2aboutthanksconfirm').bind('click.kocujThanks1', function() {
					kocujAdmin2Thanks._confirmEvent(id);
				});
			}
			if ($('#kocujadmin2thanks  #kocujadmin2thanksmore').length > 0) {
				$('#kocujadmin2thanks  #kocujadmin2thanksmore').attr('href', 'javascript:void(0);');
				$('#kocujadmin2thanks  #kocujadmin2thanksmore').bind('click.kocujThanks1', function() {
					kocujAdmin2Thanks._moreEvent(id);
				});
			}
			if ($('#kocujadmin2aboutthanksdiv #kocujadmin2aboutthanksmore').length > 0) {
				$('#kocujadmin2aboutthanksdiv #kocujadmin2aboutthanksmore').attr('href', 'javascript:void(0);');
				$('#kocujadmin2aboutthanksdiv #kocujadmin2aboutthanksmore').bind('click.kocujThanks1', function() {
					kocujAdmin2Thanks._moreEvent(id);
				});
			}
		}(jQuery));
	},

	// AJAX loading success
	_ajaxSuccess : function(id, type, callback, data, status, obj) {
		(function($) {
			// parse data
			id = parseInt(id);
			// deactivate AJAX timeout
			kocujAdmin2Thanks._deactivateAJAXTimeout();
			// parse response
			if (callback != '') {
				eval(callback + '(id, type, data);');
			}
		}(jQuery));
	},

	// AJAX loading error
	_ajaxError : function(id, type, callback, obj, status, err) {
		(function($) {
			// parse data
			id = parseInt(id);
			// parse error
			if (callback != '') {
				eval(callback + '(id, type);');
			}
		}(jQuery));
	},

	// activate AJAX timeout
	_activateAJAXTimeout : function(id, type, callback) {
		// set timer
		kocujAdmin2Thanks._timer = window.setTimeout('kocujAdmin2Thanks._ajaxError("' + id + '", "' + type.toString().replace('"', '\\"') + '", "' + callback.toString().replace('"', '\\"') + '");', 30000);
	},

	// deactivate AJAX timeout
	_deactivateAJAXTimeout : function() {
		// clear timer
		window.clearTimeout(kocujAdmin2Thanks._timer);
	},

	// confirm event
	_confirmEvent : function(id) {
		(function($) {
			// check data
			id = parseInt(id);
			// show loading circle
			if ($('#kocujadmin2thanks').length > 0) {
				$('#kocujadmin2thanks #kocujadmin2thankstextdiv').hide();
				$('#kocujadmin2thanks #kocujadmin2thanksemptydiv').hide();
				$('#kocujadmin2thanks #kocujadmin2thanksmorediv').hide();
				$('#kocujadmin2thanks #kocujadmin2thanksoptionsdiv').html('<p><img src="' + kocujAdmin2Thanks._settingsLoadingImageURL + '" alt="" style="position: absolute;" /><span style="margin-left: 25px;"><strong>' + kocujAdmin2Thanks._settingsTextSending + '</strong></span></p>');
			}
			if ($('#kocujadmin2aboutthanksdiv #kocujadmin2aboutthankstextdiv').length > 0) {
				if ($('#kocujadmin2aboutthanksdiv #kocujadmin2aboutthanksconfirm').length > 0) {
					$('#kocujadmin2aboutthanksdiv #kocujadmin2aboutthanksconfirm').remove();
				}
				$('#kocujadmin2aboutthanksdiv #kocujadmin2aboutthanksinfodiv').hide();
				$('#kocujadmin2aboutthanksdiv #kocujadmin2aboutthankstextdiv').html('<img src="' + kocujAdmin2Thanks._settingsLoadingImageURL + '" alt="" style="position: absolute;" /><span style="margin-left: 25px;"><strong>' + kocujAdmin2Thanks._settingsTextSending + '</strong></span>');
				$('#kocujadmin2aboutthanksdiv #kocujadmin2aboutthankstextdiv').show();
			}
			// call AJAX
			kocujAdmin2Thanks._activateAJAXTimeout(id, 'confirm', 'kocujAdmin2Thanks._confirmationErrorCallback');
			if ($().jquery < '1.6') {
				var data = {
					'requestType': 'parameters',
					'responseType': 'JSON',
					'requestMethod': 'GET',
					'data[PARAMETER_version]': 1,
					'data[header][login]': kocujAdmin2Thanks._settingsApiLogin,
					'data[header][password]': kocujAdmin2Thanks._settingsApiPassword,
					'data[request][PARAMETER_command]': 'ADD_THANKS',
					'data[request][url]': kocujAdmin2Thanks._settingsWebsiteURL,
					'data[request][title]': kocujAdmin2Thanks._settingsWebsiteTitle,
					'data[request][description]': kocujAdmin2Thanks._settingsWebsiteDescription
				};
			} else {
				var data = {
					'requestType': 'parameters',
					'responseType': 'JSON',
					'requestMethod': 'GET',
					'data' : {
						'PARAMETER_version': 1,
						'header' : {
							'login': kocujAdmin2Thanks._settingsApiLogin,
							'password': kocujAdmin2Thanks._settingsApiPassword
						},
						'request': {
							'PARAMETER_command': 'ADD_THANKS',
							'url': kocujAdmin2Thanks._settingsWebsiteURL,
							'title': kocujAdmin2Thanks._settingsWebsiteTitle,
							'description': kocujAdmin2Thanks._settingsWebsiteDescription
						}
					}
				};
			}
			$.ajax({
				url: kocujAdmin2Thanks._settingsApiUrl + '',
				async: true,
				cache: false,
				data: data,
				dataType: 'jsonp',
				success: function(data, status, obj) { kocujAdmin2Thanks._ajaxSuccess(id, 'confirm', 'kocujAdmin2Thanks._confirmationCallback', data, status, obj); },
				jsonpCallback: 'kocujadmin2confirmcallback',
				type: 'GET'
			});
		}(jQuery));
	},

	// cancel event
	_cancelEvent : function(id) {
		(function($) {
			// hide elements to send thanks
			if ($('#kocujadmin2thanks').length > 0) {
				$('#kocujadmin2thanks').hide();
			}
			// send cancel
			$.ajax({
				url: kocujAdmin2Thanks._settingsAdminUrl,
				async: true,
				cache: false,
				data: 'kocujadmin2thankscancel=' + kocujAdmin2Thanks._internalName['pos' + id],
				dataType: 'html',
				error: function(obj, status, err) { kocujAdmin2Thanks._ajaxError(id, 'cancelsave', '', obj, status, err); },
				success: function(data, status, obj) { kocujAdmin2Thanks._ajaxSuccess(id, 'cancelsave', '', data, status, obj); },
				type: 'GET'
			});
		}(jQuery));
	},

	// show more information event
	_moreEvent : function(id) {
		(function($) {
			// check data
			id = parseInt(id);
			// prepare modal window
			var totalHeight = parseInt($(window).height())-200;
			if (totalHeight < 140) {
				totalHeight = 140;
			}
			kocujAdmin2Modal.prepareModal('<div id="kocujadmin2_thanksheader_' + id + '">' + kocujAdmin2Thanks._settingsTextMoreTitle + '</div><div id="kocujadmin2_thanks_' + id + '"><em>' + kocujAdmin2Thanks._settingsTextLoading + '</em></div>', 600, totalHeight, id);
			// set style
			$('#kocujadmin2_thanksheader_' + id).css({
				'font-size': '13px',
				'text-align': 'center',
				'font-weight': 'normal',
				'line-height': '28px',
				'width': '600px',
				'height': '28px',
				'color': '#cccccc',
				'background-color': '#464646'
			});
			$('#kocujadmin2_thanks_' + id).css({
				'font-size': '12px',
				'text-align': 'left',
				'font-weight': 'normal',
				'width': '580px',
				'height': parseInt(totalHeight-28-20) + 'px',
				'padding': '10px 10px 10px 10px',
				'color': '#464646',
				'background-color': '#ffffff',
				'border-bottom-color': '#000000',
				'border-bottom-style': 'solid',
				'border-bottom-width': '0px',
				'overflow': 'auto'
			});
			// call AJAX
			$.ajax({
				url: kocujAdmin2Thanks._settingsAdminUrl,
				async: true,
				cache: false,
				data: 'kocujadmin2thanks=' + kocujAdmin2Thanks._internalName['pos' + id],
				dataType: 'html',
				error: function(obj, status, err) { kocujAdmin2Thanks._ajaxError(id, 'more', 'kocujAdmin2Thanks._moreErrorCallback', obj, status, err); },
				success: function(data, status, obj) { kocujAdmin2Thanks._ajaxSuccess(id, 'more', 'kocujAdmin2Thanks._moreCallback', data, status, obj); },
				type: 'GET'
			});
			// show window
			kocujAdmin2Modal.showPreparedModal(id, 1.0);
		}(jQuery));
	},

	// save confirmation
	_confirmationCallback : function(id, type, data) {
		(function($) {
			// check response status
			if (data.status.id != 'OK') {
				if (data.status.id == 'CT_ADD_THANKS_URLALREADYEXISTS') {
					if ($('#kocujadmin2thanks').length > 0) {
						$('#kocujadmin2thanks #kocujadmin2thankstextdiv').hide();
						$('#kocujadmin2thanks #kocujadmin2thanksmorediv').hide();
						$('#kocujadmin2thanks #kocujadmin2thanksoptionsdiv').show();
						$('#kocujadmin2thanks #kocujadmin2thanksemptydiv').hide();
						$('#kocujadmin2thanks #kocujadmin2thanksoptionsdiv').html('<p><strong>' + kocujAdmin2Thanks._settingsTextInformationAlreadySent + '</strong></p>');
					}
					if ($('#kocujadmin2aboutthanksdiv #kocujadmin2aboutthankstextdiv').length > 0) {
						$('#kocujadmin2aboutthanksdiv #kocujadmin2aboutthankstextdiv').html('<strong>' + kocujAdmin2Thanks._settingsTextInformationAlreadySent + '</strong>');
						$('#kocujadmin2aboutthanksdiv #kocujadmin2aboutthankstextdiv').show();
					}
				} else {
					kocujAdmin2Thanks._confirmationErrorCallback(id, type);
					return;
				}
			} else {
				if ($('#kocujadmin2thanks').length > 0) {
					$('#kocujadmin2thanks #kocujadmin2thankstextdiv').show();
					$('#kocujadmin2thanks #kocujadmin2thanksmorediv').hide();
					$('#kocujadmin2thanks #kocujadmin2thanksoptionsdiv').hide();
					$('#kocujadmin2thanks #kocujadmin2thanksemptydiv').hide();
					$('#kocujadmin2thanks #kocujadmin2thankstextdiv').html('<p><strong>' + kocujAdmin2Thanks._settingsTextCorrect + '</strong></p>');
				}
				if ($('#kocujadmin2aboutthanksdiv #kocujadmin2aboutthankstextdiv').length > 0) {
					$('#kocujadmin2aboutthanksdiv #kocujadmin2aboutthankstextdiv').html('<strong>' + kocujAdmin2Thanks._settingsTextCorrect + '</strong>');
					$('#kocujadmin2aboutthanksdiv #kocujadmin2aboutthankstextdiv').show();
				}
			}
			// save confirmation
			$.ajax({
				url: kocujAdmin2Thanks._settingsAdminUrl,
				async: true,
				cache: false,
				data: 'kocujadmin2thanksconfirm=' + kocujAdmin2Thanks._internalName['pos' + id],
				dataType: 'html',
				error: function(obj, status, err) { kocujAdmin2Thanks._ajaxError(id, 'confirmsave', '', obj, status, err); },
				success: function(data, status, obj) { kocujAdmin2Thanks._ajaxSuccess(id, 'confirmsave', '', data, status, obj); },
				type: 'GET'
			});
		}(jQuery));
	},

	// save confirmation - error
	_confirmationErrorCallback : function(id, type) {
		(function($) {
			// set retries
			kocujAdmin2Thanks._retries++;
			// show error
			if (kocujAdmin2Thanks._retries < 3) {
				if ($('#kocujadmin2thanks').length > 0) {
					$('#kocujadmin2thanks #kocujadmin2thanksoptionsdiv').html('<p><strong>' + kocujAdmin2Thanks._settingsTextErrorTryAgain + '</strong></p>');
				}
				if ($('#kocujadmin2aboutthanksdiv #kocujadmin2aboutthankstextdiv').length > 0) {
					$('#kocujadmin2aboutthanksdiv #kocujadmin2aboutthankstextdiv').html('<strong>' + kocujAdmin2Thanks._settingsTextErrorTryAgain + '</strong>');
					$('#kocujadmin2aboutthanksdiv #kocujadmin2aboutthankstextdiv').show();
				}
			} else {
				if ($('#kocujadmin2thanks').length > 0) {
					$('#kocujadmin2thanks #kocujadmin2thanksoptionsdiv').html('<p><strong>' + kocujAdmin2Thanks._settingsTextError + '</strong></p>');
				}
				if ($('#kocujadmin2aboutthanksdiv #kocujadmin2aboutthankstextdiv').length > 0) {
					$('#kocujadmin2aboutthanksdiv #kocujadmin2aboutthankstextdiv').html('<strong>' + kocujAdmin2Thanks._settingsTextError + '</strong>');
					$('#kocujadmin2aboutthanksdiv #kocujadmin2aboutthankstextdiv').show();
				}
			}
			// check retries
			if (kocujAdmin2Thanks._retries < 3) {
				window.setTimeout('kocujAdmin2Thanks._confirmEvent("' + id + '");', 5000);
			}
		}(jQuery));
	},

	// more information
	_moreCallback : function(id, type, data) {
		(function($) {
			// parse data
			id = parseInt(id);
			// set HTML data
			$('#kocujadmin2_thanks_' + id).html(data);
			// set styles
			$('#kocujadmin2_thanks_' + id + ' ul').css({
				'margin-top': '12px',
				'margin-bottom': '12px'
			});
			$('#kocujadmin2_thanks_' + id + ' ul li').css({
				'margin-bottom': '0px'
			});
		}(jQuery));
	},

	// more information - error
	_moreErrorCallback : function(id, type) {
		(function($) {
			// parse data
			id = parseInt(id);
			// set HTML data
			$('#kocujadmin2_thanks_' + id).html('<strong>' + kocujAdmin2Thanks._settingsTextLoadingError + '</strong>');
		}(jQuery));
	}
};

// initialize
var kocujAdmin2Thanks = new kocujAdmin2ClassThanks();
