<?php

/*
	Plugin Name: Kocuj Sitemap
	Plugin URI: http://kocujsitemap.wpplugin.kocuj.pl
	Description: Plugin for creating a sitemap and placing it in article (by adding a shortcode) or anywhere else (by calling PHP function). It provides also sitemap caching for better performance.
	Version: 1.1.1
	Author: Dominik Kocuj <dominik@kocuj.pl>
	Author URI: http://www.dominik.kocuj.pl
	License: GPL2 or newer
	Text Domain: kocuj-sitemap-meta

	Kocuj Sitemap plugin is released under the GNU General Public License (GPL)
	http://www.gnu.org/licenses/gpl-2.0.html

	This is a WordPress plugin (http://wordpress.org).
*/

/*  Copyright 2013  Dominik Kocuj  (email : dominik@kocuj.pl)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License, version 3, as 
    published by the Free Software Foundation.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

/**
 * kocuj-sitemap.php
 *
 * @author Dominik Kocuj <dominik@kocuj.pl>
 * @license http://www.gnu.org/licenses/gpl-2.0.html
 * @copyright Copyright (c) 2013 Dominik Kocuj
 * @package kocuj_sitemap
 */

// include classes
include_once dirname(__FILE__).'/classes/internalcacheinterface.class.php';
include_once dirname(__FILE__).'/classes/kocuj-admin-2/kocuj-admin.class.php';
include_once dirname(__FILE__).'/classes/config.class.php';
include_once dirname(__FILE__).'/classes/admin.class.php';
include_once dirname(__FILE__).'/classes/html5.class.php';
include_once dirname(__FILE__).'/classes/sitemap.class.php';
include_once dirname(__FILE__).'/classes/menu.class.php';
include_once dirname(__FILE__).'/classes/cache.class.php';

/**
 * Class KocujSitemapPluginAdmin
 *
 * @var object
 */
global $classKocujSitemapAdmin;
$classKocujSitemapAdmin = NULL;

/**
 * Plugin class
 *
 * @access public
 */
class KocujSitemapPlugin {
	/**
	 * Singleton instance
	 *
	 * @access private
	 * @var object
	 */
	private static $instance = NULL;

	/**
	 * Plugin version
	 *
	 * @access public
	 * @var int
	 */
	private $versionMajor = 1;

	/**
	 * Plugin directory
	 *
	 * @access private
	 * @var string
	 */
	private $pluginDir = '';

	/**
	 * Plugin URL
	 *
	 * @access private
	 * @var string
	 */
	private $pluginUrl = '';

	/**
	 * Cron id
	 *
	 * @access private
	 * @var string
	 */
	private $cronId = 'kocujsitemapcron';

	/**
	 * Constructor
	 *
	 * @access private
	 * @return void
	 */
	public function __construct() {
		// get plugin directory
		$this->pluginDir = dirname(__FILE__);
		$this->pluginUrl = plugins_url('kocuj-sitemap');
		// add initialize
		add_action('init', array($this, 'init'));
	}

	/**
	 * Clone
	 *
	 * @access private
	 * @return void
	 */
	private function __clone() {
	}

	/**
	 * Get singleton instance
	 *
	 * @access public
	 * @return object Singleton instance
	 */
	public static function getInstance() {
		// optionally create new instance
		if (!self::$instance) {
			self::$instance = new KocujSitemapPlugin();
		}
		// exit
		return self::$instance;
	}

	/**
	 * Initialize
	 *
	 * @access public
	 * @return void
	 */
	public function init() {
		// load translation
		load_plugin_textdomain('kocuj-sitemap', false, dirname(plugin_basename( __FILE__ )).'/languages');
		load_plugin_textdomain('kocuj-sitemap-meta', false, dirname(plugin_basename( __FILE__ )).'/languages');
		// initialize classes
		global $classKocujSitemapAdmin;
		$classKocujSitemapConfig = new KocujSitemapPluginConfig(dirname(__FILE__).'/languages');
		$classKocujSitemapAdmin = new KocujSitemapPluginAdmin($this, $classKocujSitemapConfig, dirname( __FILE__ ).'/languages');
		KocujSitemapPluginCache::getInstance();
		KocujSitemapPluginSitemap::getInstance();
		// activate plugin
		register_activation_hook(__FILE__, array($this, 'activate'));
		// deactivate plugin
		register_deactivation_hook(__FILE__, array($this, 'deactivate'));
		// add cron
		if (!wp_next_scheduled($this->cronId)) {
			wp_schedule_event(time(), 'hourly', $this->cronId);
		}
		add_action($this->cronId, array($this, 'cron'));
	}

	/**
	 * Get major version
	 *
	 * @access public
	 * @return int Major version
	 */
	public function getVersionMajor() {
		// get major version
		return $this->versionMajor;
	}

	/**
	 * Get plugin directory
	 *
	 * @access public
	 * @return int Plugin directory
	 */
	public function getPluginDir() {
		// get plugin directory
		return $this->pluginDir;
	}

	/**
	 * Get plugin URL
	 *
	 * @access public
	 * @return int Plugin URL
	 */
	public function getPluginUrl() {
		// get plugin URL
		return $this->pluginUrl;
	}

	/**
	 * Plugin activation
	 *
	 * @access public
	 * @return void
	 */
	public function activate() {
		// add option information
		add_option('kocujsitemap_plugin_data_version', $this->getVersionMajor());
		// create cache
		KocujSitemapPluginCache::getInstance()->createCache();
		// make cron
		$this->cron();
	}

	/**
	 * Plugin deactivation
	 *
	 * @access public
	 * @return void
	 */
	public function deactivate() {
		// delete cron
		remove_action($this->cronId, array($this, 'cronDelete'));
		// delete option information
		delete_option('kocujsitemap_plugin_data_version');
	}

	/**
	 * Cron
	 *
	 * @access public
	 * @return void
	 */
	public function cron() {
		// create cache
		KocujSitemapPluginCache::getInstance()->createCache();
	}

	/**
	 * Delete cron
	 *
	 * @access public
	 * @return void
	 */
	public function cronDelete() {
		// cron delete
		wp_clear_scheduled_hook($this->cronId);
	}
}

// initialize class
KocujSitemapPlugin::getInstance();

/**
 * Display sitemap
 *
 * @access public
 * @param string $title Sitemap title - default: empty
 * @param string $class Sitemap class - default: empty
 * @return void
 */
function kocujsitemap_show_sitemap($title = '', $class = '') {
	// show sitemap
	echo KocujSitemapPluginSitemap::getInstance()->getSitemap($title, $class);
}

?>