// Copyright (c) 2013 Dominik Kocuj <dominik@kocuj.pl>
// License: http://www.gnu.org/licenses/gpl-2.0.html

// thanks prototype constructor
function kocujAdmin3ClassThanks() {
	// get settings
	if (typeof kocujAdmin3ThanksSettings != 'undefined') {
		if (typeof kocujAdmin3ThanksSettings.apiUrl != 'undefined') {
			this._settingsApiUrl = kocujAdmin3ThanksSettings.apiUrl;
		}
		if (typeof kocujAdmin3ThanksSettings.apiLogin != 'undefined') {
			this._settingsApiLogin = kocujAdmin3ThanksSettings.apiLogin;
		}
		if (typeof kocujAdmin3ThanksSettings.apiPassword != 'undefined') {
			this._settingsApiPassword = kocujAdmin3ThanksSettings.apiPassword;
		}
		if (typeof kocujAdmin3ThanksSettings.websiteURL != 'undefined') {
			this._settingsWebsiteURL = kocujAdmin3ThanksSettings.websiteURL;
		}
		if (typeof kocujAdmin3ThanksSettings.websiteTitle != 'undefined') {
			this._settingsWebsiteTitle = kocujAdmin3ThanksSettings.websiteTitle;
		}
		if (typeof kocujAdmin3ThanksSettings.websiteDescription != 'undefined') {
			this._settingsWebsiteDescription = kocujAdmin3ThanksSettings.websiteDescription;
		}
		if (typeof kocujAdmin3ThanksSettings.adminUrl != 'undefined') {
			this._settingsAdminUrl = kocujAdmin3ThanksSettings.adminUrl;
		}
		if (typeof kocujAdmin3ThanksSettings.loadingImageURL != 'undefined') {
			this._settingsLoadingImageURL = kocujAdmin3ThanksSettings.loadingImageURL;
		}
		if (typeof kocujAdmin3ThanksSettings.textSending != 'undefined') {
			this._settingsTextSending = kocujAdmin3ThanksSettings.textSending;
		}
		if (typeof kocujAdmin3ThanksSettings.textInformationAlreadySent != 'undefined') {
			this._settingsTextInformationAlreadySent = kocujAdmin3ThanksSettings.textInformationAlreadySent;
		}
		if (typeof kocujAdmin3ThanksSettings.textCorrect != 'undefined') {
			this._settingsTextCorrect = kocujAdmin3ThanksSettings.textCorrect;
		}
		if (typeof kocujAdmin3ThanksSettings.textErrorTryAgain != 'undefined') {
			this._settingsTextErrorTryAgain = kocujAdmin3ThanksSettings.textErrorTryAgain;
		}
		if (typeof kocujAdmin3ThanksSettings.textError != 'undefined') {
			this._settingsTextError = kocujAdmin3ThanksSettings.textError;
		}
		if (typeof kocujAdmin3ThanksSettings.textMoreTitle != 'undefined') {
			this._settingsTextMoreTitle = kocujAdmin3ThanksSettings.textMoreTitle;
		}
		if (typeof kocujAdmin3ThanksSettings.textLoading != 'undefined') {
			this._settingsTextLoading = kocujAdmin3ThanksSettings.textLoading;
		}
		if (typeof kocujAdmin3ThanksSettings.textLoadingError != 'undefined') {
			this._settingsTextLoadingError = kocujAdmin3ThanksSettings.textLoadingError;
		}
	}
}

// thanks prototype
kocujAdmin3ClassThanks.prototype = {
	// old Internet Explorer
	_ieOld : 0,
	// internal name
	_internalName : new Array(),
	// timer
	_timer : null,
	// retries
	_retries : 0,
	// settings
	_settingsApiUrl : '',
	_settingsApiLogin : '',
	_settingsApiPassword : '',
	_settingsWebsiteURL : '',
	_settingsWebsiteTitle : '',
	_settingsWebsiteDescription : '',
	_settingsAdminUrl : '',
	_settingsLoadingImageURL : '',
	_settingsTextSending : '',
	_settingsTextInformationAlreadySent : '',
	_settingsTextCorrect : '',
	_settingsTextErrorTryAgain : '',
	_settingsTextError : '',
	_settingsTextMoreTitle : '',
	_settingsTextLoading : '',
	_settingsTextLoadingError : '',

	// set old IE
	setIEOld : function() {
		// set old IE
		this._ieOld = 1;
	},

	// set internal name
	setInternalName : function(internalName, id) {
		// set internal name
		this._internalName['pos' + parseInt(id)] = internalName;
	},

	// set sending thanks information form elements
	setForm : function(id) {
		(function($) {
			// check data
			id = parseInt(id);
			// add events
			if ($('#kocujadmin3thanksmini #kocujadmin3thanksminimore').length > 0) {
				$('#kocujadmin3thanksmini #kocujadmin3thanksminimore').attr('href', 'javascript:void(0);');
				$('#kocujadmin3thanksmini #kocujadmin3thanksminimore').bind('click.kocujThanksMini1', function() {
					kocujAdmin3Thanks._miniMoreEvent(id);
				});
			}
			if ($('#kocujadmin3thanksmini #kocujadmin3thanksminiclose').length > 0) {
				$('#kocujadmin3thanksmini #kocujadmin3thanksminiclose').attr('href', 'javascript:void(0);');
				$('#kocujadmin3thanksmini #kocujadmin3thanksminiclose').bind('click.kocujThanksMini1', function() {
					kocujAdmin3Thanks._miniCloseEvent(id);
				});
			}
			if ($('#kocujadmin3thanks #kocujadmin3thanksconfirm').length > 0) {
				$('#kocujadmin3thanks #kocujadmin3thanksconfirm').attr('href', 'javascript:void(0);');
				$('#kocujadmin3thanks #kocujadmin3thanksconfirm').bind('click.kocujThanks1', function() {
					kocujAdmin3Thanks._confirmEvent(id);
				});
				$('#kocujadmin3thanks #kocujadmin3thankscancel').attr('href', 'javascript:void(0);');
				$('#kocujadmin3thanks #kocujadmin3thankscancel').bind('click.kocujThanks1', function() {
					kocujAdmin3Thanks._cancelEvent(id);
				});
			}
			if ($('#kocujadmin3aboutthanksdiv #kocujadmin3aboutthanksconfirm').length > 0) {
				$('#kocujadmin3aboutthanksdiv #kocujadmin3aboutthanksconfirm').attr('href', 'javascript:void(0);');
				$('#kocujadmin3aboutthanksdiv #kocujadmin3aboutthanksconfirm').bind('click.kocujThanks1', function() {
					kocujAdmin3Thanks._confirmEvent(id);
				});
			}
			if ($('#kocujadmin3thanks  #kocujadmin3thanksmore').length > 0) {
				$('#kocujadmin3thanks  #kocujadmin3thanksmore').attr('href', 'javascript:void(0);');
				$('#kocujadmin3thanks  #kocujadmin3thanksmore').bind('click.kocujThanks1', function() {
					kocujAdmin3Thanks._moreEvent(id);
				});
			}
			if ($('#kocujadmin3aboutthanksdiv #kocujadmin3aboutthanksmore').length > 0) {
				$('#kocujadmin3aboutthanksdiv #kocujadmin3aboutthanksmore').attr('href', 'javascript:void(0);');
				$('#kocujadmin3aboutthanksdiv #kocujadmin3aboutthanksmore').bind('click.kocujThanks1', function() {
					kocujAdmin3Thanks._moreEvent(id);
				});
			}
		}(jQuery));
	},

	// AJAX loading success
	_ajaxSuccess : function(id, type, callback, data, status, obj) {
		(function($) {
			// parse data
			id = parseInt(id);
			// deactivate AJAX timeout
			kocujAdmin3Thanks._deactivateAJAXTimeout();
			// parse response
			if (callback != '') {
				eval(callback + '(id, type, data);');
			}
		}(jQuery));
	},

	// AJAX loading error
	_ajaxError : function(id, type, callback, obj, status, err) {
		(function($) {
			// parse data
			id = parseInt(id);
			// parse error
			if (callback != '') {
				eval(callback + '(id, type);');
			}
		}(jQuery));
	},

	// activate AJAX timeout
	_activateAJAXTimeout : function(id, type, callback) {
		// set timer
		kocujAdmin3Thanks._timer = window.setTimeout('kocujAdmin3Thanks._ajaxError("' + id + '", "' + type.toString().replace('"', '\\"') + '", "' + callback.toString().replace('"', '\\"') + '");', 30000);
	},

	// deactivate AJAX timeout
	_deactivateAJAXTimeout : function() {
		// clear timer
		window.clearTimeout(kocujAdmin3Thanks._timer);
	},

	// more in mini information event
	_miniMoreEvent : function(id) {
		(function($) {
			// show information
			if ($('#kocujadmin3thanksmini').length > 0) {
				$('#kocujadmin3thanksmini').hide();
			}
			if ($('#kocujadmin3thanks').length > 0) {
				$('#kocujadmin3thanks').show();
			}
		}(jQuery));
	},

	// close mini information event
	_miniCloseEvent : function(id) {
		(function($) {
			// hide information
			if ($('#kocujadmin3thanksmini').length > 0) {
				$('#kocujadmin3thanksmini').hide();
			}
			// cancel
			kocujAdmin3Thanks._cancelEvent(id);
		}(jQuery));
	},

	// confirm event
	_confirmEvent : function(id) {
		(function($) {
			// check data
			id = parseInt(id);
			// show loading circle
			if ($('#kocujadmin3thanks').length > 0) {
				$('#kocujadmin3thanks #kocujadmin3thankstextdiv').hide();
				$('#kocujadmin3thanks #kocujadmin3thanksemptydiv').hide();
				$('#kocujadmin3thanks #kocujadmin3thanksmorediv').hide();
				$('#kocujadmin3thanks #kocujadmin3thanksoptionsdiv').html('<p><img src="' + kocujAdmin3Thanks._settingsLoadingImageURL + '" alt="" style="position: absolute;" /><span style="margin-left: 25px;"><strong>' + kocujAdmin3Thanks._settingsTextSending + '</strong></span></p>');
			}
			if ($('#kocujadmin3aboutthanksdiv #kocujadmin3aboutthankstextdiv').length > 0) {
				if ($('#kocujadmin3aboutthanksdiv #kocujadmin3aboutthanksconfirm').length > 0) {
					$('#kocujadmin3aboutthanksdiv #kocujadmin3aboutthanksconfirm').remove();
				}
				$('#kocujadmin3aboutthanksdiv #kocujadmin3aboutthanksinfodiv').hide();
				$('#kocujadmin3aboutthanksdiv #kocujadmin3aboutthankstextdiv').html('<img src="' + kocujAdmin3Thanks._settingsLoadingImageURL + '" alt="" style="position: absolute;" /><span style="margin-left: 25px;"><strong>' + kocujAdmin3Thanks._settingsTextSending + '</strong></span>');
				$('#kocujadmin3aboutthanksdiv #kocujadmin3aboutthankstextdiv').show();
			}
			// call AJAX
			kocujAdmin3Thanks._activateAJAXTimeout(id, 'confirm', 'kocujAdmin3Thanks._confirmationErrorCallback');
			if ($().jquery < '1.6') {
				var data = {
					'requestType': 'parameters',
					'responseType': 'JSON',
					'requestMethod': 'GET',
					'data[PARAMETER_version]': 1,
					'data[header][login]': kocujAdmin3Thanks._settingsApiLogin,
					'data[header][password]': kocujAdmin3Thanks._settingsApiPassword,
					'data[request][PARAMETER_command]': 'ADD_THANKS',
					'data[request][url]': kocujAdmin3Thanks._settingsWebsiteURL,
					'data[request][title]': kocujAdmin3Thanks._settingsWebsiteTitle,
					'data[request][description]': kocujAdmin3Thanks._settingsWebsiteDescription
				};
			} else {
				var data = {
					'requestType': 'parameters',
					'responseType': 'JSON',
					'requestMethod': 'GET',
					'data' : {
						'PARAMETER_version': 1,
						'header' : {
							'login': kocujAdmin3Thanks._settingsApiLogin,
							'password': kocujAdmin3Thanks._settingsApiPassword
						},
						'request': {
							'PARAMETER_command': 'ADD_THANKS',
							'url': kocujAdmin3Thanks._settingsWebsiteURL,
							'title': kocujAdmin3Thanks._settingsWebsiteTitle,
							'description': kocujAdmin3Thanks._settingsWebsiteDescription
						}
					}
				};
			}
			$.ajax({
				url: kocujAdmin3Thanks._settingsApiUrl + '',
				async: true,
				cache: false,
				data: data,
				dataType: 'jsonp',
				success: function(data, status, obj) { kocujAdmin3Thanks._ajaxSuccess(id, 'confirm', 'kocujAdmin3Thanks._confirmationCallback', data, status, obj); },
				jsonpCallback: 'kocujadmin3confirmcallback',
				type: 'GET'
			});
		}(jQuery));
	},

	// cancel event
	_cancelEvent : function(id) {
		(function($) {
			// hide elements to send thanks
			if ($('#kocujadmin3thanks').length > 0) {
				$('#kocujadmin3thanks').hide();
			}
			// send cancel
			$.ajax({
				url: kocujAdmin3Thanks._settingsAdminUrl,
				async: true,
				cache: false,
				data: 'kocujadmin3thankscancel=' + kocujAdmin3Thanks._internalName['pos' + id],
				dataType: 'html',
				error: function(obj, status, err) { kocujAdmin3Thanks._ajaxError(id, 'cancelsave', '', obj, status, err); },
				success: function(data, status, obj) { kocujAdmin3Thanks._ajaxSuccess(id, 'cancelsave', '', data, status, obj); },
				type: 'GET'
			});
		}(jQuery));
	},

	// show more information event
	_moreEvent : function(id) {
		(function($) {
			// check data
			id = parseInt(id);
			// prepare modal window
			var totalHeight = parseInt($(window).height())-200;
			if (totalHeight < 140) {
				totalHeight = 140;
			}
			kocujAdmin3Modal.prepareModal('<div id="kocujadmin3_thanksheader_' + id + '">' + kocujAdmin3Thanks._settingsTextMoreTitle + '</div><div id="kocujadmin3_thanks_' + id + '"><em>' + kocujAdmin3Thanks._settingsTextLoading + '</em></div>', 600, totalHeight, id);
			// set style
			$('#kocujadmin3_thanksheader_' + id).css({
				'font-size': '13px',
				'text-align': 'center',
				'font-weight': 'normal',
				'line-height': '28px',
				'width': '600px',
				'height': '28px',
				'color': '#cccccc',
				'background-color': '#464646'
			});
			$('#kocujadmin3_thanks_' + id).css({
				'font-size': '12px',
				'text-align': 'left',
				'font-weight': 'normal',
				'width': '580px',
				'height': parseInt(totalHeight-28-20) + 'px',
				'padding': '10px 10px 10px 10px',
				'color': '#464646',
				'background-color': '#ffffff',
				'border-bottom-color': '#000000',
				'border-bottom-style': 'solid',
				'border-bottom-width': '0px',
				'overflow': 'auto'
			});
			// call AJAX
			$.ajax({
				url: kocujAdmin3Thanks._settingsAdminUrl,
				async: true,
				cache: false,
				data: 'kocujadmin3thanks=' + kocujAdmin3Thanks._internalName['pos' + id],
				dataType: 'html',
				error: function(obj, status, err) { kocujAdmin3Thanks._ajaxError(id, 'more', 'kocujAdmin3Thanks._moreErrorCallback', obj, status, err); },
				success: function(data, status, obj) { kocujAdmin3Thanks._ajaxSuccess(id, 'more', 'kocujAdmin3Thanks._moreCallback', data, status, obj); },
				type: 'GET'
			});
			// show window
			kocujAdmin3Modal.showPreparedModal(id, 1.0);
		}(jQuery));
	},

	// save confirmation
	_confirmationCallback : function(id, type, data) {
		(function($) {
			// check response status
			if (data.status.id != 'OK') {
				if (data.status.id == 'CT_ADD_THANKS_URLALREADYEXISTS') {
					if ($('#kocujadmin3thanks').length > 0) {
						$('#kocujadmin3thanks #kocujadmin3thankstextdiv').hide();
						$('#kocujadmin3thanks #kocujadmin3thanksmorediv').hide();
						$('#kocujadmin3thanks #kocujadmin3thanksoptionsdiv').show();
						$('#kocujadmin3thanks #kocujadmin3thanksemptydiv').hide();
						if (kocujAdmin3Thanks._ieOld == 1) {
							$('#kocujadmin3thanks #kocujadmin3thanksoptionsdiv').html('<p><strong>' + kocujAdmin3Thanks._settingsTextCorrect + '</strong></p>');
						} else {
							$('#kocujadmin3thanks #kocujadmin3thanksoptionsdiv').html('<p><strong>' + kocujAdmin3Thanks._settingsTextInformationAlreadySent + '</strong></p>');
						}
					}
					if ($('#kocujadmin3aboutthanksdiv #kocujadmin3aboutthankstextdiv').length > 0) {
						if (kocujAdmin3Thanks._ieOld == 1) {
							$('#kocujadmin3aboutthanksdiv #kocujadmin3aboutthankstextdiv').html('<strong>' + kocujAdmin3Thanks._settingsTextCorrect + '</strong>');
						} else {
							$('#kocujadmin3aboutthanksdiv #kocujadmin3aboutthankstextdiv').html('<strong>' + kocujAdmin3Thanks._settingsTextInformationAlreadySent + '</strong>');
						}
						$('#kocujadmin3aboutthanksdiv #kocujadmin3aboutthankstextdiv').show();
					}
				} else {
					kocujAdmin3Thanks._confirmationErrorCallback(id, type);
					return;
				}
			} else {
				if ($('#kocujadmin3thanks').length > 0) {
					$('#kocujadmin3thanks #kocujadmin3thankstextdiv').show();
					$('#kocujadmin3thanks #kocujadmin3thanksmorediv').hide();
					$('#kocujadmin3thanks #kocujadmin3thanksoptionsdiv').hide();
					$('#kocujadmin3thanks #kocujadmin3thanksemptydiv').hide();
					$('#kocujadmin3thanks #kocujadmin3thankstextdiv').html('<p><strong>' + kocujAdmin3Thanks._settingsTextCorrect + '</strong></p>');
				}
				if ($('#kocujadmin3aboutthanksdiv #kocujadmin3aboutthankstextdiv').length > 0) {
					$('#kocujadmin3aboutthanksdiv #kocujadmin3aboutthankstextdiv').html('<strong>' + kocujAdmin3Thanks._settingsTextCorrect + '</strong>');
					$('#kocujadmin3aboutthanksdiv #kocujadmin3aboutthankstextdiv').show();
				}
			}
			// save confirmation
			$.ajax({
				url: kocujAdmin3Thanks._settingsAdminUrl,
				async: true,
				cache: false,
				data: 'kocujadmin3thanksconfirm=' + kocujAdmin3Thanks._internalName['pos' + id],
				dataType: 'html',
				error: function(obj, status, err) { kocujAdmin3Thanks._ajaxError(id, 'confirmsave', '', obj, status, err); },
				success: function(data, status, obj) { kocujAdmin3Thanks._ajaxSuccess(id, 'confirmsave', '', data, status, obj); },
				type: 'GET'
			});
		}(jQuery));
	},

	// save confirmation - error
	_confirmationErrorCallback : function(id, type) {
		(function($) {
			// set retries
			kocujAdmin3Thanks._retries++;
			// show error
			if (kocujAdmin3Thanks._retries < 3) {
				if ($('#kocujadmin3thanks').length > 0) {
					$('#kocujadmin3thanks #kocujadmin3thanksoptionsdiv').html('<p><strong>' + kocujAdmin3Thanks._settingsTextErrorTryAgain + '</strong></p>');
				}
				if ($('#kocujadmin3aboutthanksdiv #kocujadmin3aboutthankstextdiv').length > 0) {
					$('#kocujadmin3aboutthanksdiv #kocujadmin3aboutthankstextdiv').html('<strong>' + kocujAdmin3Thanks._settingsTextErrorTryAgain + '</strong>');
					$('#kocujadmin3aboutthanksdiv #kocujadmin3aboutthankstextdiv').show();
				}
			} else {
				if ($('#kocujadmin3thanks').length > 0) {
					$('#kocujadmin3thanks #kocujadmin3thanksoptionsdiv').html('<p><strong>' + kocujAdmin3Thanks._settingsTextError + '</strong></p>');
				}
				if ($('#kocujadmin3aboutthanksdiv #kocujadmin3aboutthankstextdiv').length > 0) {
					$('#kocujadmin3aboutthanksdiv #kocujadmin3aboutthankstextdiv').html('<strong>' + kocujAdmin3Thanks._settingsTextError + '</strong>');
					$('#kocujadmin3aboutthanksdiv #kocujadmin3aboutthankstextdiv').show();
				}
			}
			// check retries
			if (kocujAdmin3Thanks._retries < 3) {
				window.setTimeout('kocujAdmin3Thanks._confirmEvent("' + id + '");', 5000);
			}
		}(jQuery));
	},

	// more information
	_moreCallback : function(id, type, data) {
		(function($) {
			// parse data
			id = parseInt(id);
			// set HTML data
			$('#kocujadmin3_thanks_' + id).html(data);
			// set styles
			$('#kocujadmin3_thanks_' + id + ' ul').css({
				'margin-top': '12px',
				'margin-bottom': '12px'
			});
			$('#kocujadmin3_thanks_' + id + ' ul li').css({
				'margin-bottom': '0px'
			});
		}(jQuery));
	},

	// more information - error
	_moreErrorCallback : function(id, type) {
		(function($) {
			// parse data
			id = parseInt(id);
			// set HTML data
			$('#kocujadmin3_thanks_' + id).html('<strong>' + kocujAdmin3Thanks._settingsTextLoadingError + '</strong>');
		}(jQuery));
	}
};

// initialize
var kocujAdmin3Thanks = new kocujAdmin3ClassThanks();
