<?php

/**
 * review-message-ajax.class.php
 *
 * @author Dominik Kocuj <dominik@kocuj.pl>
 * @license http://www.gnu.org/licenses/gpl-2.0.html
 * @copyright Copyright (c) 2016 Dominik Kocuj
 * @package kocuj_internal_lib
 */

// set namespace
namespace KocujInternalLib\V1a\Classes\Project\Backend;

// security
if ((!defined('ABSPATH')) || ((isset($_SERVER['SCRIPT_FILENAME'])) && (basename($_SERVER['SCRIPT_FILENAME']) === basename(__FILE__)))) {
	header('HTTP/1.1 404 Not Found');
	die();
}

/**
 * Set review message AJAX class
 *
 * @access public
 */
class ReviewMessageAjax extends \KocujInternalLib\V1a\Classes\ProjectObject {
	/**
	 * Constructor
	 *
	 * @access public
	 * @param object $projectObj \KocujInternalLib\V1a\Classes\Project object for current project
	 * @return void
	 */
	public function __construct($projectObj) {
		// execute parent constructor
		parent::__construct($projectObj);
		// check if it is backend and check permissions
		if (((!is_admin()) && (!is_network_admin())) || ((!current_user_can('manage_network')) && (!current_user_can('manage_options')))) {
			return;
		}
		// add actions
		add_action('wp_ajax_'.$this->getProjectObj()->getObj('project-helper')->getPrefix().'__review_message_close', array($this, 'actionAjaxClose'));
	}

	/**
	 * Action for closing review message window
	 *
	 * @access public
	 * @return void
	 */
	public function actionAjaxClose() {
		// check AJAX nonce
		check_ajax_referer(\KocujInternalLib\V1a\Classes\Helper::getInstance()->getPrefix().'__review_message', 'security');
		// save information about closing review message window
		\KocujInternalLib\V1a\Classes\Helper::getInstance()->addOrUpdateOptionForNetworkOrSite($this->getProjectObj()->getObj('backend_review-message')->getClosedWindowOptionName(), '1');
		// close connection
		wp_die();
	}
}
