<?php

/**
 * project-object.class.php
 *
 * @author Dominik Kocuj <dominik@kocuj.pl>
 * @license http://www.gnu.org/licenses/gpl-2.0.html
 * @copyright Copyright (c) 2016 Dominik Kocuj
 * @package kocuj_internal_lib
 */

// set namespace
namespace KocujInternalLib\V1a\Classes;

// security
if ((!defined('ABSPATH')) || ((isset($_SERVER['SCRIPT_FILENAME'])) && (basename($_SERVER['SCRIPT_FILENAME']) === basename(__FILE__)))) {
	header('HTTP/1.1 404 Not Found');
	die();
}

/**
 * Project object class
 *
 * @access public
 */
class ProjectObject {
	/**
	 * \KocujInternalLib\V1a\Classes\Project object for current project
	 *
	 * @access private
	 * @var object
	 */
	private $projectObj = NULL;

	/**
	 * Constructor
	 *
	 * @access public
	 * @param object $projectObj \KocujInternalLib\V1a\Classes\Project object for current project
	 * @return void
	 */
	public function __construct($projectObj) {
		// remember project object
		$this->projectObj = $projectObj;
	}

	/**
	 * Get object of type \KocujInternalLib\V1a\Classes\Project
	 *
	 * @access public
	 * @return object Object of type \KocujInternalLib\V1a\Classes\Project
	 */
	public function getProjectObj() {
		// get object of type \KocujInternalLib\V1a\Classes\Project
		return $this->projectObj;
	}
}
