<?php

/**
 * lib-dirs.class.php
 *
 * @author Dominik Kocuj <dominik@kocuj.pl>
 * @license http://www.gnu.org/licenses/gpl-2.0.html
 * @copyright Copyright (c) 2016 Dominik Kocuj
 * @package kocuj_internal_lib
 */

// set namespace
namespace KocujInternalLib\V1a\Classes;

// security
if ((!defined('ABSPATH')) || ((isset($_SERVER['SCRIPT_FILENAME'])) && (basename($_SERVER['SCRIPT_FILENAME']) === basename(__FILE__)))) {
	header('HTTP/1.1 404 Not Found');
	die();
}

/**
 * Library directories class
 *
 * @access public
 */
class LibDirs {
	/**
	 * Singleton instance
	 *
	 * @access private
	 * @var object
	 */
	private static $instance = NULL;

	/**
	 * Kocuj Internal Lib directory
	 *
	 * @access protected
	 * @var string
	 */
	protected $dir = '';

	/**
	 * Kocuj Internal Lib CSS directory
	 *
	 * @access private
	 * @var string
	 */
	private $CSSDir = '';

	/**
	 * Kocuj Internal Lib images directory
	 *
	 * @access private
	 * @var string
	 */
	private $imagesDir = '';

	/**
	 * Kocuj Internal Lib JavaScript directory
	 *
	 * @access private
	 * @var string
	 */
	private $javaScriptDir = '';

	/**
	 * Constructor
	 *
	 * @access protected
	 * @return void
	 */
	protected function __construct() {
		// set library directories
		if (!isset($this->dir[0]) /* strlen($this->dir) === 0 */ ) {
			$this->dir = realpath(dirname(__FILE__).'/../');
		}
		$this->CSSDir = $this->dir.'/css';
		$this->imagesDir = $this->dir.'/images';
		$this->javaScriptDir = $this->dir.'/js';
	}

	/**
	 * Disable cloning of object
	 *
	 * @access private
	 * @return void
	 */
	private function __clone() {
	}

	/**
	 * Get singleton instance
	 *
	 * @access public
	 * @return object Singleton instance
	 */
	public static function getInstance() {
		// optionally create new instance
		if (!self::$instance) {
			self::$instance = new \KocujInternalLib\V1a\Classes\LibDirs();
		}
		// exit
		return self::$instance;
	}

	/**
	 * Get Kocuj Internal Lib directory
	 *
	 * @access public
	 * @return string Kocuj Internal Lib directory
	 */
	public function getDir() {
		// get Kocuj Internal Lib directory
		return $this->dir;
	}

	/**
	 * Get Kocuj Internal Lib CSS directory
	 *
	 * @access public
	 * @return string Kocuj Internal Lib CSS directory
	 */
	public function getCSSDir() {
		// get Kocuj Internal Lib CSS directory
		return $this->CSSDir;
	}

	/**
	 * Get Kocuj Internal Lib images directory
	 *
	 * @access public
	 * @return string Kocuj Internal Lib images directory
	 */
	public function getImagesDir() {
		// get Kocuj Internal Lib images directory
		return $this->imagesDir;
	}

	/**
	 * Get Kocuj Internal Lib JavaScript directory
	 *
	 * @access public
	 * @return string Kocuj Internal Lib JavaScript directory
	 */
	public function getJavaScriptDir() {
		// get Kocuj Internal Lib JavaScript directory
		return $this->javaScriptDir;
	}
}
