<?php

/**
 * custom.class.php
 *
 * @author Dominik Kocuj <dominik@kocuj.pl>
 * @license http://www.gnu.org/licenses/gpl-2.0.html
 * @copyright Copyright (c) 2013-2016 Dominik Kocuj
 * @package kocuj_sitemap
 */

// set namespace
namespace KocujSitemapPlugin\Classes\ElementType\Backend;

// security
if ((!defined('ABSPATH')) || ((isset($_SERVER['SCRIPT_FILENAME'])) && (basename($_SERVER['SCRIPT_FILENAME']) === basename(__FILE__)))) {
	header('HTTP/1.1 404 Not Found');
	die();
}

/**
 * Custom post types administration panel class
 *
 * @access public
 */
class Custom implements \KocujSitemapPlugin\Interfaces\ElementTypeBackend {
	/**
	 * Add custom posts by reccurence
	 *
	 * @access private
	 * @param string $type Custom post type
	 * @param string $taxonomy Taxonomy name
	 * @param int $termId Taxonomy id
	 * @param string $locale Language locale - default: empty
	 * @return array Output array
	 */
	private function addReccurence($type, $taxonomy, $termId, $locale = '') {
		// initialize
		$array = array();
		// check if display taxonomies
		$showTaxonomies = \KocujSitemapPlugin\Classes\Base::getInstance()->getKocujInternalLibObj()->getObj('config')->getOption('DisplayCustomPostsTaxonomies');
		// get custom posts
		if (($termId !== 0) || (!$showTaxonomies)) {
			$value = \KocujSitemapPlugin\Classes\Base::getInstance()->getKocujInternalLibObj()->getObj('config')->getOption('DisplayCustomPostsSort');
			$sortColumn = 'date';
			if (isset($value[0]) /* strlen($value) > 0 */ ) {
				switch ($value) {
					case 'moddate';
						$sortColumn = 'modified';
					break;
					case 'title';
						$sortColumn = 'title';
					break;
					case 'id';
						$sortColumn = 'ID';
					break;
				}
			}
			$value = \KocujSitemapPlugin\Classes\Base::getInstance()->getKocujInternalLibObj()->getObj('config')->getOption('DisplayCustomPostsOrder');
			$sortOrder = 'DESC';
			if (isset($value[0]) /* strlen($value) > 0 */ ) {
				switch ($value) {
					case 'asc':
						$sortOrder = 'ASC';
					break;
				}
			}
			\KocujSitemapPlugin\Classes\MultipleLanguages::getInstance()->beforeGetCustomPosts($locale);
			$posts = get_posts(array(
				'post_parent' => 0,
				'orderby'     => $sortColumn,
				'order'       => $sortOrder,
				'post_type'   => $type,
				'post_status' => 'publish',
				'numberposts' => -1,
				'offset'      => 0,
				'tax_query'   => array(
					array(
						'taxonomy' => $taxonomy,
						'field'    => 'term_id',
						'terms'    => $termId,
						'operator' => 'IN',
					),
				),
			));
			\KocujSitemapPlugin\Classes\MultipleLanguages::getInstance()->afterGetCustomPosts($locale);
			if (!empty($posts)) {
				foreach ($posts as $post) {
					\KocujSitemapPlugin\Classes\MultipleLanguages::getInstance()->beforeGetCustomPostItem($post->ID, $locale);
					$linkText = apply_filters('kocujsitemap_linktitle', apply_filters('the_title', \KocujSitemapPlugin\Classes\MultipleLanguages::getInstance()->getTranslatedCustomPostTitle($post->post_title, $post->ID, $locale), $post->ID), $post->ID, 'custom', $locale); // for compatibility with 1.x.x
					\KocujSitemapPlugin\Classes\Base::getInstance()->filterOldInfo('kocujsitemap_linktitle', 'kocujsitemap_link_text'); // for compatibility with 1.x.x
					$linkText = apply_filters('kocujsitemap_link_text', $linkText, $post->ID, 'custom', $locale);
					if (!isset($linkText[0]) /* strlen($linkText) === 0 */ ) {
						$linkText = '-';
					}
					$link = apply_filters('kocujsitemap_element', \KocujInternalLib\V1a\Classes\Helper::getInstance()->getLinkAnchor(\KocujSitemapPlugin\Classes\Url::getInstance()->removeProtocolLocal(\KocujSitemapPlugin\Classes\MultipleLanguages::getInstance()->getTranslatedCustomPostURL(get_permalink($post->ID), $post->ID, $locale)), $linkText), $post->ID, 'custom', $locale);
					$customTypeObj = get_post_type_object($type);
					$arrayAdd = array(
						'id' => $post->ID,
						'tp' => 'post',
						'lk' => $link,
						'ad' => (isset($customTypeObj->labels->name)) ?
								array(
									$type,
									$customTypeObj->labels->name,
								) :
								array(
									$type,
									$type,
								),
					);
					if ($sortColumn === 'title') {
						$arrayAdd['sortname'] = $linkText;
					}
					$array[] = $arrayAdd;
					\KocujSitemapPlugin\Classes\MultipleLanguages::getInstance()->afterGetCustomPostItem($post->ID, $locale);
				}
				if ($sortColumn === 'title') {
					$array = \KocujSitemapPlugin\Classes\Sort::getInstance()->sortElements($array, $sortOrder);
				}
			}
		}
		// get taxonomies
		if ($showTaxonomies) {
			$showEmptyTaxonomies = \KocujSitemapPlugin\Classes\Base::getInstance()->getKocujInternalLibObj()->getObj('config')->getOption('DisplayEmptyCustomPostsTaxonomies');
			\KocujSitemapPlugin\Classes\MultipleLanguages::getInstance()->beforeGetTaxonomies($taxonomy, $locale);
			$terms = get_categories(array(
				'type'         => $type,
				'parent'       => $termId,
				'orderby'      => 'name',
				'order'        => 'ASC',
				'hide_empty'   => ($showEmptyTaxonomies === '1') ?
					0 :
					1,
				'hierarchical' => 1,
				'taxonomy'     => $taxonomy,
			));
			\KocujSitemapPlugin\Classes\MultipleLanguages::getInstance()->afterGetTaxonomies($taxonomy, $locale);
			if (!empty($terms)) {
				$array2 = array();
				foreach ($terms as $term) {
					\KocujSitemapPlugin\Classes\MultipleLanguages::getInstance()->beforeGetTaxonomyItem($term->term_id, $taxonomy, $locale);
					$linkText = apply_filters('kocujsitemap_linktitle', \KocujSitemapPlugin\Classes\MultipleLanguages::getInstance()->getTranslatedTaxonomyTitle($term->name, $term->term_id, $taxonomy, $locale), $term->term_id, 'taxonomy', $locale); // for compatibility with 1.x.x
					\KocujSitemapPlugin\Classes\Base::getInstance()->filterOldInfo('kocujsitemap_linktitle', 'kocujsitemap_link_text'); // for compatibility with 1.x.x
					$linkText = apply_filters('kocujsitemap_link_text', $linkText, $term->term_id, 'taxonomy', $locale);
					if (!isset($linkText[0]) /* strlen($linkText) === 0 */ ) {
						$linkText = '-';
					}
					$link = apply_filters('kocujsitemap_element', \KocujInternalLib\V1a\Classes\Helper::getInstance()->getLinkAnchor(\KocujSitemapPlugin\Classes\Url::getInstance()->removeProtocolLocal(\KocujSitemapPlugin\Classes\MultipleLanguages::getInstance()->getTranslatedTaxonomyURL(get_term_link($term), $term->term_id, $taxonomy, $locale)), $linkText), $term->term_id, 'taxonomy', $locale);
					$customTypeObj = get_post_type_object($type);
					$pos = count($array2)+count($array);
					$array2[$pos] = array(
						'id'       => $term->term_id,
						'tp'       => 'term',
						'lk'       => $link,
						'ad'       => (isset($customTypeObj->labels->name)) ?
								array(
									$type,
									$customTypeObj->labels->name,
								) :
								array(
									$type,
									$type,
								),
						'sortname' => $linkText,
					);
					\KocujSitemapPlugin\Classes\MultipleLanguages::getInstance()->afterGetTaxonomyItem($term->term_id, $taxonomy, $locale);
					$array2[$pos]['ch'] = $this->addReccurence($type, $taxonomy, $term->term_id, $locale);
					if (empty($array2[$pos]['ch'])) {
						unset($array2[$pos]['ch']);
					}
				}
				$array2 = \KocujSitemapPlugin\Classes\Sort::getInstance()->sortElements($array2, 'ASC');
				$array = array_merge($array, $array2);
			}
		}
		// exit
		return $array;
	}

	/**
	 * Add custom post types posts to sitemap
	 *
	 * @access public
	 * @param string $locale Language locale - default: empty
	 * @return array Output array
	 */
	public function getElementArray($locale = '') {
		// initialize
		$array = array();
		// add posts to sitemap
		$value = \KocujSitemapPlugin\Classes\Base::getInstance()->getKocujInternalLibObj()->getObj('config')->getOption('DisplayCustomPosts');
		if ($value) {
			// get custom posts list
			$types = \KocujSitemapPlugin\Classes\Base::getInstance()->getKocujInternalLibObj()->getObj('config')->getOption('CustomPosts');
			if (empty($types)) {
				$types = apply_filters('kocujsitemap_default_custom', array());
			}
			if (!empty($types)) {
				foreach ($types as $type) {
					$taxonomies = get_object_taxonomies($type);
					if (!empty($taxonomies)) {
						foreach ($taxonomies as $taxonomy) {
							$array2 = $this->addReccurence($type, $taxonomy, 0, $locale);
							if (!empty($array2)) {
								$array = array_merge($array, $array2);
							}
						}
					}
				}
			}
		}
		// exit
		return $array;
	}

	/**
	 * Get administration page settings
	 *
	 * @access public
	 * @return array Administration page settings
	 */
	public function getAdminPageSettings() {
		// get administration page settings
		return array(
			'title' => __('Custom post types posts list options', 'kocuj-sitemap'),
			'id'    => 'custom_options',
			'tabs'  => array(
				'custom_displaying' => __('Displaying custom post types posts', 'kocuj-sitemap'),
				'custom_list'       => __('Custom post types list', 'kocuj-sitemap'),
				'custom_options'    => __('Options', 'kocuj-sitemap'),
			),
			'help'  => array(
				'overview' => array(
					'title'   => __('Overview', 'kocuj-sitemap'),
					'content' =>
						__('This is the place where you can enable or disable displaying of custom post types posts in the sitemap. Here you can also change how they will be displayed.', 'kocuj-sitemap').'</p>'.
						'<p>'.__('Options are divided into three tabs: `displaying custom post types posts`, `custom post types list` and `options`. Each tab can be selected by clicking on it.', 'kocuj-sitemap').'</p>'.
						'<p>'.__('To save changed settings, click on the button `save custom post types posts list options`.', 'kocuj-sitemap'),
				),
				'displaying_custom_posts_type' => array(
					'title'   => __('`Displaying custom post types posts` tab', 'kocuj-sitemap'),
					'content' =>
						__('There are the following options in this tab:', 'kocuj-sitemap').'</p>'.
						'<p><ul>'.
						'<li><em>`'.__('Display custom post types posts', 'kocuj-sitemap').'`</em>: '.__('If this option is activated, there will be custom post types posts list displayed in the sitemap.', 'kocuj-sitemap').'</li>'.
						'</ul>',
				),
				'custom_posts_types_list' => array(
					'title'   => __('`Custom post types list` tab', 'kocuj-sitemap'),
					'content' =>
						__('You can select multiple custom post types to be displayed in sitemap. To do this, click on the dropdown field and select one custom post type from the list. If you have done this step in the dropdown list which was empty, there will be added another empty dropdown list where you can select another custom post type from the list.', 'kocuj-sitemap').'</p>'.
						'<p>'.__('If you want to change the order of the custom post types, you can click on one of the arrows next to the entry to move it up or down.', 'kocuj-sitemap').'</p>'.
						'<p>'.__('Clicking on the `X` button deletes the entry.', 'kocuj-sitemap'),
				),
				'options' => array(
					'title'   => __('`Options` tab', 'kocuj-sitemap'),
					'content' =>
						__('There are the following options in this tab:', 'kocuj-sitemap').'</p>'.
						'<p><ul>'.
						'<li><em>`'.__('Divide custom post types posts into taxonomies', 'kocuj-sitemap').'`</em>: '.__('If this option is activated, custom post type posts will be divided into taxonomies.', 'kocuj-sitemap').'</li>'.
						'<li><em>`'.__('Display empty taxonomies', 'kocuj-sitemap').'`</em>: '.__('If this option is activated, empty taxonomies will be displayed.', 'kocuj-sitemap').'</li>'.
						'<li><em>`'.__('Sort custom post types posts by', 'kocuj-sitemap').'`</em>: '.__('You can sort custom post types posts in the sitemap using the selected posts properties. There are the following custom post types posts properties to select:', 'kocuj-sitemap').
						'<ul>'.
						'<li><em>`'.__('created date', 'kocuj-sitemap').'`</em>: '.__('Posts will be sorted by created date.', 'kocuj-sitemap').'</li>'.
						'<li><em>`'.__('last modification date', 'kocuj-sitemap').'`</em>: '.__('Posts will be sorted by last modification date.', 'kocuj-sitemap').'</li>'.
						'<li><em>`'.__('title', 'kocuj-sitemap').'`</em>: '.__('Posts will be sorted by title.', 'kocuj-sitemap').'</li>'.
						'<li><em>`'.__('ID', 'kocuj-sitemap').'`</em>: '.__('Posts will be sorted by post identifier.', 'kocuj-sitemap').'</li>'.
						'</ul>'.
						'</li>'.
						'<li><em>`'.__('Sort custom post types posts order', 'kocuj-sitemap').'`</em>: '.__('You can sort custom post types posts by ascending or descending order.', 'kocuj-sitemap').'</li>'.
						'</ul>',
				),
			),
		);
	}

	/**
	 * Get administration page data
	 *
	 * @access public
	 * @return array Administration page data
	 */
	public function getAdminPageData() {
		// get administration page data
		$types = get_post_types(array(
			'public'   => true,
			'_builtin' => false,
		), 'object');
		$sortArray = array(
			'date'    => __('created date', 'kocuj-sitemap'),
			'moddate' => __('last modification date', 'kocuj-sitemap'),
			'title'   => __('title', 'kocuj-sitemap'),
			'id'      => __('ID', 'kocuj-sitemap'),
		);
		$sortByArray = array(
			'asc'  => __('ascending', 'kocuj-sitemap'),
			'desc' => __('descending', 'kocuj-sitemap'),
		);
		// exit
		return array(
			'pages'   => array(
				\KocujSitemapPlugin\Classes\Base::getInstance()->getKocujInternalLibObj()->getObj('admin')->getBlockHelper('DisplayCustomPosts', 'checkbox', __('If this option is activated, there will be custom post types posts list displayed in the sitemap.', 'kocuj-sitemap')),
				(!empty($types)) ?
					\KocujSitemapPlugin\Classes\Base::getInstance()->getKocujInternalLibObj()->getObj('admin')->getBlockHelper('CustomPosts', 'selectcustomposts', '') :
					\KocujSitemapPlugin\Classes\Base::getInstance()->getKocujInternalLibObj()->getObj('admin')->getBlockHelper('', 'statictext', __('No custom post types. Options here will be activated as soon as you create any custom post types.', 'kocuj-sitemap')),
				\KocujSitemapPlugin\Classes\Base::getInstance()->getKocujInternalLibObj()->getObj('admin')->getBlockHelper('DisplayCustomPostsTaxonomies', 'checkbox', __('If this option is activated, custom post type posts will be divided into taxonomies.', 'kocuj-sitemap')).
					\KocujSitemapPlugin\Classes\Base::getInstance()->getKocujInternalLibObj()->getObj('admin')->getBlockHelper('DisplayEmptyCustomPostsTaxonomies', 'checkbox', __('If this option is activated, empty taxonomies will be displayed.', 'kocuj-sitemap')).
					\KocujSitemapPlugin\Classes\Base::getInstance()->getKocujInternalLibObj()->getObj('admin')->getBlockHelper('DisplayCustomPostsSort', 'select', __('You can sort custom post types posts in the sitemap using the selected posts properties.', 'kocuj-sitemap'), $sortArray).
					\KocujSitemapPlugin\Classes\Base::getInstance()->getKocujInternalLibObj()->getObj('admin')->getBlockHelper('DisplayCustomPostsOrder', 'select', __('You can sort custom post types posts by ascending or descending order.', 'kocuj-sitemap'), $sortByArray),
			),
			'submit'  => array(
				'title' => __('Save custom post types posts list options', 'kocuj-sitemap'),
				'info'  => __('Save current custom post types posts list options', 'kocuj-sitemap'),
			),
			'buttons' => '',
		);
	}

	/**
	 * Get administration panel order name
	 *
	 * @access public
	 * @return string Administration panel order name
	 */
	public function getAdminOrderName() {
		// get administration panel order name
		return __('Custom post types', 'kocuj-sitemap');
	}

	/**
	 * Get administration cache actions
	 *
	 * @access public
	 * @return array Administration cache actions
	 */
	public function getAdminCacheActions() {
		// get administration cache actions
		return array(
			'wp_insert_post',
			'post_updated',
			'after_delete_post',
		);
	}

	/**
	 * Get administration cache filters
	 *
	 * @access public
	 * @return array Administration cache filters
	 */
	public function getAdminCacheFilters() {
		// get administration cache filters
		return array();
	}
}
