<?php

/**
 * kocuj-internal-lib.class.php
 *
 * @author Dominik Kocuj <dominik@kocuj.pl>
 * @license http://www.gnu.org/licenses/gpl-2.0.html
 * @copyright Copyright (c) 2016 Dominik Kocuj
 * @package kocuj_internal_lib
 */

// set namespace
namespace KocujInternalLib\V1a;

// security
if ((!defined('ABSPATH')) || ((isset($_SERVER['SCRIPT_FILENAME'])) && (basename($_SERVER['SCRIPT_FILENAME']) === basename(__FILE__)))) {
	header('HTTP/1.1 404 Not Found');
	die();
}

// load library if do not exists already
if (!class_exists('\\KocujInternalLib\\V1a\\Classes\\Project', false)) {
	// load required classes
	include dirname(__FILE__).'/classes/helper.class.php';
	include dirname(__FILE__).'/classes/lib-dirs.class.php';
	include dirname(__FILE__).'/classes/lib-urls.class.php';
	include dirname(__FILE__).'/classes/js-helper.class.php';
	include dirname(__FILE__).'/classes/project.class.php';
	// initialize required classes
	\KocujInternalLib\V1a\Classes\LibDirs::getInstance();
	\KocujInternalLib\V1a\Classes\LibUrls::getInstance();
	\KocujInternalLib\V1a\Classes\JsHelper::getInstance();

	/**
	 * Automatic loading of classes
	 *
	 * @access public
	 * @param string $class Class name
	 * @return void
	 */
	function autoload($class) {
		// load class
		if (substr($class, 0, 21) === 'KocujInternalLib\\V1a\\') {
			$div = explode('\\', $class);
			$count = count($div);
			$filename = $div[$count-1];
			unset($div[$count-1], $div[1], $div[0]);
			$dirArray = preg_replace('/([A-Z])/', '-$1', $div);
			if (!empty($dirArray)) {
				foreach ($dirArray as $key => $val) {
					$dirArray[$key] = substr($val, 1);
				}
			}
			set_include_path(\KocujInternalLib\V1a\Classes\LibDirs::getInstance()->getDir().'/'.strtolower(implode('/', $dirArray)));
			spl_autoload(strtolower(substr(preg_replace('/([A-Z])/', '-$1', $filename), 1)), '.class.php');
			restore_include_path();
		}
	}

	// set automatic loading of classes
	spl_autoload_register('\\KocujInternalLib\\V1a\\autoload');
}
