<?php

/**
 * message-type.class.php
 *
 * @author Dominik Kocuj <dominik@kocuj.pl>
 * @license http://www.gnu.org/licenses/gpl-2.0.html
 * @copyright Copyright (c) 2016 Dominik Kocuj
 * @package kocuj_internal_lib
 */

// set namespace
namespace KocujInternalLib\V1a\Enums;

// security
if ((!defined('ABSPATH')) || ((isset($_SERVER['SCRIPT_FILENAME'])) && (basename($_SERVER['SCRIPT_FILENAME']) === basename(__FILE__)))) {
	header('HTTP/1.1 404 Not Found');
	die();
}

/**
 * Enumeration of type of message
 *
 * @access public
 */
class MessageType {
	/**
	 * Empty constructor for blocking of creating an instance of this class
	 *
	 * @access private
	 * @var void
	 */
	private function __construct() {}

	/**
	 * It is standard message
	 *
	 */
	const STANDARD = 0;

	/**
	 * It is message about error
	 *
	 */
	const ERROR = 1;

	/**
	 * It is special message
	 *
	 */
	const SPECIAL = 2;
}
