// Copyright (c) 2016 Dominik Kocuj <dominik@kocuj.pl>
// License: http://www.gnu.org/licenses/gpl-2.0.html

/* jshint globalstrict: true */

/* global jQuery */
/* global window */

/* global ajaxurl */

/* global kocujInternalLibV1aHelper */

/* global kocujInternalLibV1aBackendReviewMessageSettings */

// review message prototype constructor
function kocujInternalLibV1aClassBackendReviewMessage() {
	'use strict';
	/* jshint validthis: true */
	// get this object
	var self = this;
	// get settings
	if (typeof kocujInternalLibV1aBackendReviewMessageSettings !== 'undefined') {
		if (kocujInternalLibV1aBackendReviewMessageSettings.prefix !== undefined) {
			self._settingsPrefix = kocujInternalLibV1aBackendReviewMessageSettings.prefix;
		}
		if (kocujInternalLibV1aBackendReviewMessageSettings.security !== undefined) {
			self._settingsSecurity = kocujInternalLibV1aBackendReviewMessageSettings.security;
		}
	}
}

// review message prototype
kocujInternalLibV1aClassBackendReviewMessage.prototype = {
	// projects
	_projects : [],
	// settings
	_settingsPrefix : '',
	_settingsSecurity : '',

	// add project
	addProject : function(projectId, voteUrl, facebookUrl, twitterUrl) {
		'use strict';
		// parse parameters
		projectId = kocujInternalLibV1aHelper.initializeString(projectId);
		if (projectId === '') {
			return;
		}
		voteUrl = kocujInternalLibV1aHelper.initializeString(voteUrl);
		if (voteUrl === '') {
			return;
		}
		facebookUrl = kocujInternalLibV1aHelper.initializeString(facebookUrl);
		twitterUrl = kocujInternalLibV1aHelper.initializeString(twitterUrl);
		// add project
		this._projects['prj_' + projectId] = {
			voteUrl : voteUrl,
			facebookUrl : facebookUrl,
			twitterUrl : twitterUrl
		};
	},

	// get HTML selector for message review
	getHTMLSelectorMessageReview : function(projectId) {
		'use strict';
		// exit
		return '#' + this._getHTMLNameMessageReview(projectId);
	},

	// get HTML selector for review message vote
	getHTMLSelectorReviewMessageVote : function(projectId) {
		'use strict';
		// exit
		return '#' + this._getHTMLNameReviewMessageVote(projectId);
	},

	// get HTML selector for review message Facebook
	getHTMLSelectorReviewMessageFacebook : function(projectId) {
		'use strict';
		// exit
		return '#' + this._getHTMLNameReviewMessageFacebook(projectId);
	},

	// get HTML selector for review message Twitter
	getHTMLSelectorReviewMessageTwitter : function(projectId) {
		'use strict';
		// exit
		return '#' + this._getHTMLNameReviewMessageTwitter(projectId);
	},

	// get HTML selector for review message close
	getHTMLSelectorReviewMessageClose : function(projectId) {
		'use strict';
		// exit
		return '#' + this._getHTMLNameReviewMessageClose(projectId);
	},

	// set review message events
	setEvents : function(projectId) {
		'use strict';
		// get this object
		var self = this;
		(function($) {
			// parse parameters
			projectId = kocujInternalLibV1aHelper.initializeString(projectId);
			if (projectId === '') {
				return;
			}
			// check if project exists
			if (self._projects['prj_' + projectId] === undefined) {
				return;
			}
			// add events
			if ($(self.getHTMLSelectorMessageReview(projectId) + ' ' + self.getHTMLSelectorReviewMessageVote(projectId)).length > 0) {
				$(self.getHTMLSelectorMessageReview(projectId) + ' ' + self.getHTMLSelectorReviewMessageVote(projectId)).bind('click.reviewmessage', { projectId : projectId }, function(event) {
					event.preventDefault();
					self._eventVote(event.data.projectId);
				});
			}
			if (self._projects['prj_' + projectId].facebookUrl) {
				if ($(self.getHTMLSelectorMessageReview(projectId) + ' ' + self.getHTMLSelectorReviewMessageFacebook(projectId)).length > 0) {
					$(self.getHTMLSelectorMessageReview(projectId) + ' ' + self.getHTMLSelectorReviewMessageFacebook(projectId)).bind('click.reviewmessage', { projectId : projectId }, function(event) {
						event.preventDefault();
						self._eventFacebook(event.data.projectId);
					});
				}
			}
			if (self._projects['prj_' + projectId].twitterUrl) {
				if ($(self.getHTMLSelectorMessageReview(projectId) + ' ' + self.getHTMLSelectorReviewMessageTwitter(projectId)).length > 0) {
					$(self.getHTMLSelectorMessageReview(projectId) + ' ' + self.getHTMLSelectorReviewMessageTwitter(projectId)).bind('click.reviewmessage', { projectId : projectId }, function(event) {
						event.preventDefault();
						self._eventTwitter(event.data.projectId);
					});
				}
			}
			if ($(self.getHTMLSelectorMessageReview(projectId) + ' ' + self.getHTMLSelectorReviewMessageClose(projectId)).length > 0) {
				$(self.getHTMLSelectorMessageReview(projectId) + ' ' + self.getHTMLSelectorReviewMessageClose(projectId)).attr('href', 'javascript:void(0);');
				$(self.getHTMLSelectorMessageReview(projectId) + ' ' + self.getHTMLSelectorReviewMessageClose(projectId)).bind('click.reviewmessage', { projectId : projectId }, function(event) {
					event.preventDefault();
					self._eventCloseWindow(event.data.projectId);
				});
			}
		}(jQuery));
	},

	// vote event
	_eventVote : function(projectId) {
		'use strict';
		// get this object
		var self = this;
		(function($) {
			window.open(self._projects['prj_' + projectId].voteUrl, '_blank');
		}(jQuery));
	},

	// send URL to Facebook event
	_eventFacebook : function(projectId) {
		'use strict';
		// get this object
		var self = this;
		(function($) {
			window.open(self._projects['prj_' + projectId].facebookUrl, '_blank');
		}(jQuery));
	},

	// send URL to Twitter event
	_eventTwitter : function(projectId) {
		'use strict';
		// get this object
		var self = this;
		(function($) {
			window.open(self._projects['prj_' + projectId].twitterUrl, '_blank');
		}(jQuery));
	},

	// close mini information event
	_eventCloseWindow : function(projectId) {
		'use strict';
		// get this object
		var self = this;
		(function($) {
			// close review message window
			if ($(self.getHTMLSelectorMessageReview(projectId)).length > 0) {
				$(self.getHTMLSelectorMessageReview(projectId)).hide();
			}
			// send information and closing window
			$.ajax({
				url: ajaxurl,
				async: true,
				cache: false,
				data: {
					action: self._settingsPrefix + '_' + projectId + '__review_message_close',
					security: self._settingsSecurity
				},
				type: 'POST'
			});
		}(jQuery));
	},

	// get HTML prefix
	_getHTMLPrefix : function(projectId) {
		'use strict';
		// exit
		return this._settingsPrefix + '_' + projectId + '__';
	},

	// get HTML name for message review
	_getHTMLNameMessageReview : function(projectId) {
		'use strict';
		// exit
		return this._getHTMLPrefix(projectId) + 'message_review';
	},

	// get HTML name for review message vote
	_getHTMLNameReviewMessageVote : function(projectId) {
		'use strict';
		// exit
		return this._getHTMLPrefix(projectId) + 'review_message_vote';
	},

	// get HTML name for review message Facebook
	_getHTMLNameReviewMessageFacebook : function(projectId) {
		'use strict';
		// exit
		return this._getHTMLPrefix(projectId) + 'review_message_facebook';
	},

	// get HTML name for review message Twitter
	_getHTMLNameReviewMessageTwitter : function(projectId) {
		'use strict';
		// exit
		return this._getHTMLPrefix(projectId) + 'review_message_twitter';
	},

	// get HTML name for review message close
	_getHTMLNameReviewMessageClose : function(projectId) {
		'use strict';
		// exit
		return this._getHTMLPrefix(projectId) + 'review_message_close';
	}
};

// initialize
var kocujInternalLibV1aBackendReviewMessage = new kocujInternalLibV1aClassBackendReviewMessage();
