<?php

/**
 * element-type-frontend.class.php
 *
 * @author Dominik Kocuj <dominik@kocuj.pl>
 * @license http://www.gnu.org/licenses/gpl-2.0.html
 * @copyright Copyright (c) 2013-2016 Dominik Kocuj
 * @package kocuj_sitemap
 */

// set namespace
namespace KocujSitemapPlugin\Interfaces;

// security
if ((!defined('ABSPATH')) || ((isset($_SERVER['SCRIPT_FILENAME'])) && (basename($_SERVER['SCRIPT_FILENAME']) === basename(__FILE__)))) {
	header('HTTP/1.1 404 Not Found');
	die();
}

/**
 * Interface for element type - frontend
 *
 */
interface ElementTypeFrontend {
	/**
	 * Check if this type exists
	 *
	 * @access public
	 * @return bool This type exists (true) or not (false)
	 */
	public function checkExists();

	/**
	 * Get type letter
	 *
	 * @access public
	 * @return string Type letter
	 */
	public function getTypeLetter();

	/**
	 * Get configuration options
	 *
	 * @access public
	 * @return array Configuration options
	 */
	public function getConfigOptions();

	/**
	 * Check section name
	 *
	 * @access public
	 * @return bool Section name exists (true) or not (false)
	 */
	public function checkSectionName();

	/**
	 * Get section name
	 *
	 * @access public
	 * @return string Section name
	 */
	public function getSectionName();

	/**
	 * Get ID to check
	 *
	 * @access public
	 * @param array $element Element
	 * @param string $section Section name
	 * @return int ID to check
	 */
	public function getIDToCheck(array $element, $section);

	/**
	 * Get sections to check
	 *
	 * @access public
	 * @param array $element Element
	 * @return array Sections to check
	 */
	public function getSectionsToCheck(array $element);

	/**
	 * Check if there are exclude parameters (true) or not (false)
	 *
	 * @access public
	 * @return bool There are exclude parameters (true) or not (false)
	 */
	public function checkExcludeParameters();

	/**
	 * Get exclude parameters suffixes
	 *
	 * @access public
	 * @return array Exclude parameters suffixes
	 */
	public function getExcludeParametersSuffixes();

	/**
	 * Get types which should be removed when they have no children
	 *
	 * @access public
	 * @return array Types which should be removed when they have no children
	 */
	public function getTypesRequiresChildren();

	/**
	 * Check if there should be an "ul" list tag
	 *
	 * @access public
	 * @return bool There should be an "ul" list tag (true) or not (false)
	 */
	public function checkListTag();

	/**
	 * Check if this type is configurable in order
	 *
	 * @access public
	 * @return bool This type is configurable in order (true) or not (false)
	 */
	public function checkConfigurableOrder();

	/**
	 * Get text before element
	 *
	 * @access public
	 * @param array $element Element
	 * @param bool $isWidget Sitemap for widget (true) or not (false) - default: false
	 * @param string $locale Language locale - default: empty
	 * @return array Text before element
	 */
	public function getBeforeElement(array $element, $isWidget, $locale = '');

	/**
	 * Get text after element
	 *
	 * @access public
	 * @param array $element Element
	 * @param bool $isWidget Sitemap for widget (true) or not (false) - default: false
	 * @param string $locale Language locale - default: empty
	 * @return array Text after element
	 */
	public function getAfterElement(array $element, $isWidget, $locale = '');
}
