<?php

/**
 * menus.class.php
 *
 * @author Dominik Kocuj <dominik@kocuj.pl>
 * @license http://www.gnu.org/licenses/gpl-2.0.html
 * @copyright Copyright (c) 2013-2016 Dominik Kocuj
 * @package kocuj_sitemap
 */

// set namespace
namespace KocujSitemapPlugin\Classes\ElementType\Backend;

// security
if ((!defined('ABSPATH')) || ((isset($_SERVER['SCRIPT_FILENAME'])) && (basename($_SERVER['SCRIPT_FILENAME']) === basename(__FILE__)))) {
	header('HTTP/1.1 404 Not Found');
	die();
}

/**
 * Menus type administration panel class
 *
 * @access public
 */
class Menus implements \KocujSitemapPlugin\Interfaces\ElementTypeBackend {
	/**
	 * Menu name
	 *
	 * @access private
	 * @var string
	 */
	private $menuName = '';

	/**
	 * Menu data
	 *
	 * @access private
	 * @var array
	 */
	private $menuData = NULL;

	/**
	 * Add menus by reccurence
	 *
	 * @access private
	 * @param int $parentId Menu parent id
	 * @param string $locale Language locale - default: empty
	 * @return array Output array
	 */
	private function addReccurence($parentId, $locale = '') {
		// initialize
		$array = array();
		// get menu
		if ($this->menuData === NULL) {
			\KocujSitemapPlugin\Classes\MultipleLanguages::getInstance()->beforeGetMenu($locale);
			$this->menuData = wp_get_nav_menu_items($this->menuName, array(
				'order'                  => 'ASC',
				'orderby'                => 'menu_order',
				'post_type'              => 'nav_menu_item',
				'post_status'            => 'publish',
				'output'                 => ARRAY_A,
				'output_key'             => 'menu_order',
				'nopaging'               => true,
				'update_post_term_cache' => false,
			));
			\KocujSitemapPlugin\Classes\MultipleLanguages::getInstance()->afterGetMenu($locale);
		}
		// get data
		if (!empty($this->menuData)) {
			foreach ($this->menuData as $element) {
				if ((int)$element->menu_item_parent === $parentId) {
					\KocujSitemapPlugin\Classes\MultipleLanguages::getInstance()->beforeGetMenuItem($element->ID, $locale);
					$type = 'unknown';
					if ($element->type === 'post_type') {
						$typeTemp = get_post_type($element->object_id);
						if ($typeTemp !== false) {
							$type = 'post';
						} else {
							$type = 'custom';
						}
					}
					if ($element->type === 'taxonomy') {
						$termTemp = get_term_by('id', $element->object_id, 'category');
						if ($termTemp !== false) {
							$type = 'category';
						} else {
							$type = 'term';
						}
					}
					if ($element->type !== 'taxonomy') {
						$title = apply_filters('the_title', \KocujSitemapPlugin\Classes\MultipleLanguages::getInstance()->getTranslatedMenuTitle($element->title, $element->ID, $locale), $element->object_ID);
					} else {
						$title = \KocujSitemapPlugin\Classes\MultipleLanguages::getInstance()->getTranslatedMenuTitle($element->title, $element->ID, $locale);
					}
					$linkText = apply_filters('kocujsitemap_linktitle', $title, $element->ID, 'menu', $locale); // for compatibility with 1.x.x
					\KocujSitemapPlugin\Classes\Base::getInstance()->filterOldInfo('kocujsitemap_linktitle', 'kocujsitemap_link_text'); // for compatibility with 1.x.x
					$linkText = apply_filters('kocujsitemap_link_text', $linkText, $element->ID, 'menu', $locale);
					if (!isset($linkText[0]) /* strlen($linkText) === 0 */ ) {
						$linkText = '-';
					}
					$link = apply_filters('kocujsitemap_menuelement', \KocujInternalLib\V1a\Classes\Helper::getInstance()->getLinkAnchor(\KocujSitemapPlugin\Classes\Url::getInstance()->removeProtocolLocal(\KocujSitemapPlugin\Classes\MultipleLanguages::getInstance()->getTranslatedMenuURL($element->url, $element->ID, $locale)), $linkText), $element->object_id, $locale); // for compatibility with 1.x.x
					\KocujSitemapPlugin\Classes\Base::getInstance()->filterOldInfo('kocujsitemap_menuelement', 'kocujsitemap_element'); // for compatibility with 1.x.x
					$link = apply_filters('kocujsitemap_element', $link, $element->ID, 'menu', $locale);
					$pos = count($array);
					$array[$pos] = array(
						'id' => $element->object_id,
						'tp' => $type,
						'lk' => $link,
					);
					\KocujSitemapPlugin\Classes\MultipleLanguages::getInstance()->afterGetMenuItem($element->ID, $locale);
					$array[$pos]['ch'] = $this->addReccurence($element->ID, $locale);
					if (empty($array[$pos]['ch'])) {
						unset($array[$pos]['ch']);
					}
				}
			}
		}
		// exit
		return $array;
	}

	/**
	 * Add menus to sitemap
	 *
	 * @access public
	 * @param string $locale Language locale - default: empty
	 * @return array Output array
	 */
	public function getElementArray($locale = '') {
		// initialize
		$array = array();
		// add menus to sitemap
		$value = \KocujSitemapPlugin\Classes\Base::getInstance()->getKocujInternalLibObj()->getObj('config')->getOption('DisplayMenus');
		if ($value) {
			$menus = \KocujSitemapPlugin\Classes\Base::getInstance()->getKocujInternalLibObj()->getObj('config')->getOption('Menus');
			if (empty($menus)) {
				$menus = apply_filters('kocujsitemap_defaultmenus', array()); // for compatibility with 1.x.x
				\KocujSitemapPlugin\Classes\Base::getInstance()->filterOldInfo('kocujsitemap_defaultmenus', 'kocujsitemap_default_menus'); // for compatibility with 1.x.x
				$menus = apply_filters('kocujsitemap_default_menus', $menus);
			}
			if (!empty($menus)) {
				foreach ($menus as $menu) {
					$exists = wp_get_nav_menu_object($menu);
					if ($exists !== false) {
						$this->menuData = NULL;
						$this->menuName = $menu;
						$array2 = $this->addReccurence(0, $locale);
						$array = array_merge($array, $array2);
					}
				}
			}
		}
		// exit
		return $array;
	}

	/**
	 * Get administration page settings
	 *
	 * @access public
	 * @return array Administration page settings
	 */
	public function getAdminPageSettings() {
		// get administration page settings
		return array(
			'title' => __('Menus list options', 'kocuj-sitemap'),
			'id'    => 'menus_options',
			'tabs'  => array(
				'menus_displaying' => __('Displaying menu items', 'kocuj-sitemap'),
				'menus_list'       => __('Menus list', 'kocuj-sitemap'),
			),
			'help'  => array(
				'overview' => array(
					'title'   => __('Overview', 'kocuj-sitemap'),
					'content' =>
						__('This is the place where you can enable or disable displaying of menu items in the sitemap. Here you can also change how they will be displayed.', 'kocuj-sitemap').'</p>'.
						'<p>'.__('Options are divided into three tabs: `displaying menu items`, `menus list` and `section title`. Each tab can be selected by clicking on it.', 'kocuj-sitemap').'</p>'.
						'<p>'.__('To save changed settings, click on the button `save menus list options`.', 'kocuj-sitemap'),
				),
				'displaying_menu_items' => array(
					'title'   => __('`Displaying menu items` tab', 'kocuj-sitemap'),
					'content' =>
						__('There are the following options in this tab:', 'kocuj-sitemap').'</p>'.
						'<p><ul>'.
						'<li><em>`'.__('Display menus', 'kocuj-sitemap').'`</em>: '.__('If this option is activated, there will be menu items list displayed in the sitemap.', 'kocuj-sitemap').'</li>'.
						'</ul>',
				),
				'menus_list' => array(
					'title'   => __('`Menus list` tab', 'kocuj-sitemap'),
					'content' =>
						__('You can select multiple menus to be displayed in sitemap. To do this, click on the dropdown field and select one menu from the list. If you have done this step in the dropdown list which was empty, there will be added another empty dropdown list where you can select another menu from the list.', 'kocuj-sitemap').'</p>'.
						'<p>'.__('If you want to change the order of the menu, you can click on one of the arrow next to the entry to move it up or down.', 'kocuj-sitemap').'</p>'.
						'<p>'.__('Clicking on the `X` button deletes the entry.', 'kocuj-sitemap'),
				),
				'section_title' => array(
					'title'   => __('`Section title` tab', 'kocuj-sitemap'),
					'content' =>
						__('In this tab you can set the title of the section with menu items. It is used if option `divide display into sections` in the main settings of the Kocuj Sitemap plugin is activated.', 'kocuj-sitemap').'</p>'.
						'<p>'.__('There are fields to enter the section title for each language that is available in your WordPress installation. If you have not activated any of the supported plugins for multilingualism, there will be visible only two fields to enter the title - for current WordPress language and for default section title in English language.', 'kocuj-sitemap').'</p>'.
						'<p>'.__('It is not necessary to enter section titles here. However, the place is here in order to be able to display the title of the section in your chosen language if there is no translation for it. If you leave this empty and if you will not have a translation of section title for current language and for default language (English language), there will be displayed the standard section title in English language.', 'kocuj-sitemap'),
				),
			),
		);
	}

	/**
	 * Get administration page data
	 *
	 * @access public
	 * @return array Administration page data
	 */
	public function getAdminPageData() {
		// exit
		return array(
			'pages'   => array(
				\KocujSitemapPlugin\Classes\Base::getInstance()->getKocujInternalLibObj()->getObj('admin')->getBlockHelper('DisplayMenus', 'checkbox', __('If this option is activated, there will be menu items list displayed in the sitemap.', 'kocuj-sitemap')),
				(get_terms('nav_menu')) ?
					\KocujSitemapPlugin\Classes\Base::getInstance()->getKocujInternalLibObj()->getObj('admin')->getBlockHelper('Menus', 'selectmenu', '') :
					\KocujSitemapPlugin\Classes\Base::getInstance()->getKocujInternalLibObj()->getObj('admin')->getBlockHelper('', 'statictext', __('No menus. Options here will be activated as soon as you create any menu.', 'kocuj-sitemap')),
			),
			'submit'  => array(
				'title' => __('Save menus list options', 'kocuj-sitemap'),
				'info'  => __('Save current menus list options', 'kocuj-sitemap'),
			),
			'buttons' => '',
		);
	}

	/**
	 * Get administration panel order name
	 *
	 * @access public
	 * @return string Administration panel order name
	 */
	public function getAdminOrderName() {
		// get administration panel order name
		return __('Menus', 'kocuj-sitemap');
	}

	/**
	 * Get administration cache actions
	 *
	 * @access public
	 * @return array Administration cache actions
	 */
	public function getAdminCacheActions() {
		// get administration cache actions
		return array(
			'wp_update_nav_menu',
			'wp_delete_nav_menu',
		);
	}

	/**
	 * Get administration cache filters
	 *
	 * @access public
	 * @return array Administration cache filters
	 */
	public function getAdminCacheFilters() {
		// get administration cache filters
		return array();
	}
}
