<?php

/**
 * lib-urls.class.php
 *
 * @author Dominik Kocuj <dominik@kocuj.pl>
 * @license http://www.gnu.org/licenses/gpl-2.0.html
 * @copyright Copyright (c) 2016 Dominik Kocuj
 * @package kocuj_internal_lib
 */

// set namespace
namespace KocujInternalLib\V1a\Classes;

// security
if ((!defined('ABSPATH')) || ((isset($_SERVER['SCRIPT_FILENAME'])) && (basename($_SERVER['SCRIPT_FILENAME']) === basename(__FILE__)))) {
	header('HTTP/1.1 404 Not Found');
	die();
}

/**
 * Library URL-s class
 *
 * @access public
 */
class LibUrls {
	/**
	 * Singleton instance
	 *
	 * @access private
	 * @var object
	 */
	private static $instance = NULL;

	/**
	 * Kocuj Internal Lib directory
	 *
	 * @access protected
	 * @var string
	 */
	protected $dir = '';

	/**
	 * Kocuj Internal Lib URL
	 *
	 * @access private
	 * @var string
	 */
	private $url = '';

	/**
	 * Kocuj Internal Lib CSS URL
	 *
	 * @access private
	 * @var string
	 */
	private $CSSUrl = '';

	/**
	 * Kocuj Internal Lib images URL
	 *
	 * @access private
	 * @var string
	 */
	private $imagesUrl = '';

	/**
	 * Kocuj Internal Lib JavaScript URL
	 *
	 * @access private
	 * @var string
	 */
	private $javaScriptUrl = '';

	/**
	 * Constructor
	 *
	 * @access protected
	 * @return void
	 */
	protected function __construct() {
		// set URL-s
		if (!isset($this->dir[0]) /* strlen($this->dir) === 0 */ ) {
			$this->dir = realpath(dirname(__FILE__).'/../');
		}
		$path = ABSPATH;
		if ($path[strlen($path)-1] === '/') {
			$path = substr($path, 0, -1);
		}
		$this->url = site_url().'/'.substr($this->dir, strlen($path));
		$this->CSSUrl = $this->url.'/css';
		$this->imagesUrl = $this->url.'/images';
		$this->javaScriptUrl = $this->url.'/js';
	}

	/**
	 * Disable cloning of object
	 *
	 * @access private
	 * @return void
	 */
	private function __clone() {
	}

	/**
	 * Get singleton instance
	 *
	 * @access public
	 * @return object Singleton instance
	 */
	public static function getInstance() {
		// optionally create new instance
		if (!self::$instance) {
			self::$instance = new \KocujInternalLib\V1a\Classes\LibUrls();
		}
		// exit
		return self::$instance;
	}

	/**
	 * Get Kocuj Internal Lib URL
	 *
	 * @access public
	 * @return string Kocuj Internal Lib URL
	 */
	public function getUrl() {
		// get Kocuj Internal Lib URL
		return $this->url;
	}

	/**
	 * Get Kocuj Internal Lib CSS URL
	 *
	 * @access public
	 * @return string Kocuj Internal Lib CSS URL
	 */
	public function getCSSUrl() {
		// get Kocuj Internal Lib CSS URL
		return $this->CSSUrl;
	}

	/**
	 * Get Kocuj Internal Lib images URL
	 *
	 * @access public
	 * @return string Kocuj Internal Lib images URL
	 */
	public function getImagesUrl() {
		// get Kocuj Internal Lib images URL
		return $this->imagesUrl;
	}

	/**
	 * Get Kocuj Internal Lib JavaScript URL
	 *
	 * @access public
	 * @return string Kocuj Internal Lib JavaScript URL
	 */
	public function getJavaScriptUrl() {
		// get Kocuj Internal Lib JavaScript URL
		return $this->javaScriptUrl;
	}
}
