// Copyright (c) 2016 Dominik Kocuj <dominik@kocuj.pl>
// License: http://www.gnu.org/licenses/gpl-2.0.html

/* jshint globalstrict: true */

/* global document */
/* global jQuery */
/* global window */

/* global kocujInternalLibV1aHelper */

/* global kocujInternalLibV1aModalSettings */

// modal window prototype constructor
function kocujInternalLibV1aClassModal() {
	'use strict';
	/* jshint validthis: true */
	// get this object
	var self = this;
	// get settings
	if (typeof kocujInternalLibV1aModalSettings !== 'undefined') {
		if (kocujInternalLibV1aModalSettings.prefix !== undefined) {
			self._settingsPrefix = kocujInternalLibV1aModalSettings.prefix;
		}
	}
}

// modal window prototype
kocujInternalLibV1aClassModal.prototype = {
	// projects
	_projects : [],
	// append default window (true) or not (false)
	_appendDefault : false,
	// appended windows id
	_append : [],
	// visible default window (true) or not (false)
	_visibleDefault : false,
	// visible windows id
	_visible : [],
	// fading content of default window
	_fadingContentDefault : 0,
	// fading content windows id
	_fadingContent : [],
	// settings
	_settingsPrefix : '',

	// add project
	addProject : function(projectId) {
		'use strict';
		// parse parameters
		projectId = kocujInternalLibV1aHelper.initializeString(projectId);
		if (projectId === '') {
			return;
		}
		// add project
		this._projects['prj_' + projectId] = true;
	},

	// get HTML selector for modal mask
	getHTMLSelectorModalMask : function(projectId) {
		'use strict';
		// exit
		return '#' + this._getHTMLNameModalMask(projectId);
	},

	// get HTML selector for modal container
	getHTMLSelectorModalContainer : function(projectId) {
		'use strict';
		// exit
		return '#' + this._getHTMLNameModalContainer(projectId);
	},

	// get HTML selector for modal dialog
	getHTMLSelectorModalDialog : function(projectId) {
		'use strict';
		// exit
		return '#' + this._getHTMLNameModalDialog(projectId);
	},

	// get HTML selector for modal dialog inside
	getHTMLSelectorModalDialogInside : function(projectId) {
		'use strict';
		// exit
		return '#' + this._getHTMLNameModalDialogInside(projectId);
	},

	// add close event
	addCloseEvent : function(projectId, elementPath, id, callback) {
		'use strict';
		// get this object
		var self = this;
		(function($) {
			// parse parameters
			elementPath = kocujInternalLibV1aHelper.initializeString(elementPath);
			id = kocujInternalLibV1aHelper.initializeNumeric(id);
			callback = kocujInternalLibV1aHelper.initializeString(callback);
			// add close event
			var idString = '';
			if (id !== '') {
				idString = '_' + id;
			}
			$(elementPath).attr('href', '#');
			$(elementPath).bind('click', {
				callback: callback
			}, function(evt) {
				evt.preventDefault();
				if (((id === '') && ((self._fadingContentDefault === undefined) ||
						(self._fadingContentDefault > 0))) ||
						((id !== '') && ((self._fadingContent['pos' + id] === undefined) ||
						(self._fadingContent['pos' + id] > 0)))) {
					$(self.getHTMLSelectorModalDialog(projectId) + idString).fadeOut('slow', function() {
						$(self.getHTMLSelectorModalMask(projectId) + idString).fadeOut('fast', function() {
							$(self.getHTMLSelectorModalContainer(projectId) + idString).hide();
							$(self.getHTMLSelectorModalMask(projectId) + idString).hide();
							if ((evt.data !== undefined) && (evt.data) &&
									(evt.data.callback !== undefined)) {
								/* jshint evil: true */
								eval(evt.data.callback);
							}
							$(self.getHTMLSelectorModalDialogInside(projectId) + idString).html('');
						});
					});
				} else {
					$(self.getHTMLSelectorModalDialog(projectId) + idString).hide();
					$(self.getHTMLSelectorModalMask(projectId) + idString).fadeOut('fast', function() {
						$(self.getHTMLSelectorModalContainer(projectId) + idString).hide();
						$(self.getHTMLSelectorModalMask(projectId) + idString).hide();
						if ((evt.data !== undefined) && (evt.data) &&
								(evt.data.callback !== undefined)) {
							/* jshint evil: true */
							eval(evt.data.callback);
						}
						$(self.getHTMLSelectorModalDialogInside(projectId) + idString).html('');
					});
				}
				if (id === '') {
					self._visibleDefault = false;
				} else {
					self._visible['pos' + id] = false;
				}
			});
		}(jQuery));
	},

	// add close event to mask
	addCloseEventToMask : function(projectId, id, callback) {
		'use strict';
		// get this object
		var self = this;
		// parse parameters
		id = kocujInternalLibV1aHelper.initializeNumeric(id);
		callback = kocujInternalLibV1aHelper.initializeString(callback);
		// remove close event from mask
		var idString = '';
		if (id !== '') {
			idString = '_' + id;
		}
		this.addCloseEvent(projectId, self.getHTMLSelectorModalMask(projectId) + idString, id, callback);
	},

	// remove close event
	removeCloseEvent : function(elementPath) {
		'use strict';
		// get this object
		var self = this;
		(function($) {
			// parse parameters
			elementPath = kocujInternalLibV1aHelper.initializeString(elementPath);
			// remove close event
			$(elementPath).unbind('click');
		}(jQuery));
	},

	// remove close event from mask
	removeCloseEventFromMask : function(projectId, id) {
		'use strict';
		// get this object
		var self = this;
		// parse parameters
		id = kocujInternalLibV1aHelper.initializeNumeric(id);
		// remove close event from mask
		var idString = '';
		if (id !== '') {
			idString = '_' + id;
		}
		this.removeCloseEvent(self.getHTMLSelectorModalMask(projectId) + idString);
	},

	// prepare modal window
	prepareModal : function(projectId, content, width, height, id) {
		'use strict';
		// get this object
		var self = this;
		(function($) {
			// parse parameters
			projectId = kocujInternalLibV1aHelper.initializeString(projectId);
			if (projectId === '') {
				return;
			}
			content = kocujInternalLibV1aHelper.initializeString(content);
			width = kocujInternalLibV1aHelper.initializeNumeric(width);
			height = kocujInternalLibV1aHelper.initializeNumeric(height);
			if ((width === '') || (width <= 0) || (height === '') || (height <= 0)) {
				return;
			}
			id = kocujInternalLibV1aHelper.initializeNumeric(id);
			var idString = '';
			if (id !== '') {
				idString = '_' + id;
			}
			// check if project exists
			if (self._projects['prj_' + projectId] === undefined) {
				return;
			}
			// append window
			var append = false;
			if (id === '') {
				if (!self._appendDefault) {
					append = true;
					self._appendDefault = true;
				}
			} else {
				if ((self._append['pos' + id] === undefined) || (!self._append['pos' + id])) {
					append = true;
					self._append['pos' + id] = true;
				}
			}
			if (append) {
				$('body').prepend(
					'<div id="' + self._getHTMLNameModalContainer(projectId) + idString + '">' +
					'<div id="' + self._getHTMLNameModalDialog(projectId) + idString + '">' +
					'<div id="' + self._getHTMLNameModalDialogInside(projectId) + idString + '">' +
					'</div>' +
					'</div>' +
					'<div id="' + self._getHTMLNameModalMask(projectId) + idString + '">' +
					'</div>' +
					'</div>'
				);
				$(self.getHTMLSelectorModalContainer(projectId) + idString).hide();
			}
			// set styles
			$(self.getHTMLSelectorModalContainer(projectId) + idString + ' ' + self.getHTMLSelectorModalDialog(projectId) + idString).css({
				'position': 'absolute',
				'display': 'none',
				'z-index': 999999,
				'background-color': '#000000'
			});
			$(self.getHTMLSelectorModalContainer(projectId) + idString + ' ' + self.getHTMLSelectorModalDialogInside(projectId) + idString).css({
				'background-color': '#ffffff'
			});
			// prepare mask
			$(self.getHTMLSelectorModalMask(projectId) + idString).css({
				'box-sizing': 'content-box',
				'position': 'absolute',
				'z-index': 999998,
				'background-color': '#000000',
				'display': 'none',
				'left': 0,
				'top': 0,
				'width': $(window).width(),
				'height': $(document).height()
			});
			// set new window size
			$(self.getHTMLSelectorModalDialog(projectId) + idString).width(width+20);
			$(self.getHTMLSelectorModalDialog(projectId) + idString).height(height+20);
			$(self.getHTMLSelectorModalDialogInside(projectId) + idString).css('box-sizing', 'content-box');
			$(self.getHTMLSelectorModalDialogInside(projectId) + idString).css('margin-left', '10px');
			$(self.getHTMLSelectorModalDialogInside(projectId) + idString).css('margin-right', '10px');
			$(self.getHTMLSelectorModalDialogInside(projectId) + idString).css('margin-top', '10px');
			$(self.getHTMLSelectorModalDialogInside(projectId) + idString).css('margin-bottom', '10px');
			$(self.getHTMLSelectorModalDialogInside(projectId) + idString).width(width);
			$(self.getHTMLSelectorModalDialogInside(projectId) + idString).height(height);
			// set window position
			$(self.getHTMLSelectorModalDialog(projectId) + idString).css('left', ($(window).width()/2)-((width+20)/2));
			$(self.getHTMLSelectorModalDialog(projectId) + idString).css('top', ($(window).height()/2)-((height+20)/2));
			// change window content
			$(self.getHTMLSelectorModalDialogInside(projectId) + idString).html(content);
			// add close event
			self.removeCloseEventFromMask(projectId, id);
			self.addCloseEvent(projectId, self.getHTMLSelectorModalMask(projectId) + idString, id);
		}(jQuery));
	},

	// show prepared modal window
	showPreparedModal : function(projectId, id, fadingContent, x, y, width, height) {
		'use strict';
		// get this object
		var self = this;
		(function($) {
			// parse parameters
			projectId = kocujInternalLibV1aHelper.initializeString(projectId);
			if (projectId === '') {
				return;
			}
			id = kocujInternalLibV1aHelper.initializeNumeric(id);
			var idString = '';
			if (id !== '') {
				idString = '_' + id;
			}
			fadingContent = kocujInternalLibV1aHelper.initializeNumericFloat(fadingContent);
			x = kocujInternalLibV1aHelper.initializeNumeric(x);
			y = kocujInternalLibV1aHelper.initializeNumeric(y);
			width = kocujInternalLibV1aHelper.initializeNumeric(width);
			height = kocujInternalLibV1aHelper.initializeNumeric(height);
			if (((width !== '') && (width <= 0)) || ((height !== '') && (height <= 0))) {
				return;
			}
			// check if project exists
			if (self._projects['prj_' + projectId] === undefined) {
				return;
			}
			// show modal window box
			$(self.getHTMLSelectorModalContainer(projectId) + idString).show();
			// show mask
			$(self.getHTMLSelectorModalMask(projectId) + idString).fadeTo('fast', 0.8);
			// set window position
			if (x !== '') {
				$(self.getHTMLSelectorModalDialog(projectId) + idString).css('left', x);
			}
			if (y !== '') {
				$(self.getHTMLSelectorModalDialog(projectId) + idString).css('top', y);
			}
			if (width !== '') {
				$(self.getHTMLSelectorModalDialog(projectId) + idString).width(width);
			}
			if (height !== '') {
				$(self.getHTMLSelectorModalDialog(projectId) + idString).height(height);
			}
			// show window
			if (id === '') {
				self._fadingContentDefault = fadingContent;
			} else {
				self._fadingContent['pos' + id] = fadingContent;
			}
			if (fadingContent > 0) {
				$(self.getHTMLSelectorModalDialog(projectId) + idString).fadeTo('slow', fadingContent);
			} else {
				$(self.getHTMLSelectorModalDialog(projectId) + idString).show();
			}
			// set visible status
			if (id === '') {
				self._visibleDefault = true;
			} else {
				self._visible['pos' + id] = true;
			}
		}(jQuery));
	},

	// show modal window
	showModal : function(projectId, content, width, height, id, fadingContent, x, y) {
		'use strict';
		// parse parameters
		projectId = kocujInternalLibV1aHelper.initializeString(projectId);
		if (projectId === '') {
			return;
		}
		content = kocujInternalLibV1aHelper.initializeString(content);
		width = kocujInternalLibV1aHelper.initializeNumeric(width);
		height = kocujInternalLibV1aHelper.initializeNumeric(height);
		if ((width === '') || (width <= 0) || (height === '') || (height <= 0)) {
			return;
		}
		id = kocujInternalLibV1aHelper.initializeNumeric(id);
		fadingContent = kocujInternalLibV1aHelper.initializeNumericFloat(fadingContent);
		x = kocujInternalLibV1aHelper.initializeNumeric(x);
		y = kocujInternalLibV1aHelper.initializeNumeric(y);
		// check if project exists
		if (this._projects['prj_' + projectId] === undefined) {
			return;
		}
		// show modal window
		this.prepareModal(projectId, content, width, height, id);
		this.showPreparedModal(projectId, id, fadingContent, x, y);
	},

	// check if modal window is visible
	checkVisible : function(id) {
		'use strict';
		// parse parameters
		id = kocujInternalLibV1aHelper.initializeNumeric(id);
		// check if modal window is visible
		if (id === '') {
			return this._visibleDefault;
		} else {
			if (this._visible['pos' + id] === undefined) {
				return false;
			} else {
				return this._visible['pos' + id];
			}
		}
	},

	// get HTML prefix
	_getHTMLPrefix : function(projectId) {
		'use strict';
		// exit
		return this._settingsPrefix + '_' + projectId + '__';
	},

	// get HTML name for modal mask
	_getHTMLNameModalMask : function(projectId) {
		'use strict';
		// exit
		return this._getHTMLPrefix(projectId) + 'modal_mask';
	},

	// get HTML name for modal container
	_getHTMLNameModalContainer : function(projectId) {
		'use strict';
		// exit
		return this._getHTMLPrefix(projectId) + 'modal_container';
	},

	// get HTML name for modal dialog
	_getHTMLNameModalDialog : function(projectId) {
		'use strict';
		// exit
		return this._getHTMLPrefix(projectId) + 'modal_dialog';
	},

	// get HTML name for modal dialog inside
	_getHTMLNameModalDialogInside : function(projectId) {
		'use strict';
		// exit
		return this._getHTMLPrefix(projectId) + 'modal_dialog_inside';
	}
};

// initialize
var kocujInternalLibV1aModal = new kocujInternalLibV1aClassModal();
