<?php

/**
 * settings-menu-parent-type.class.php
 *
 * @author Dominik Kocuj <dominik@kocuj.pl>
 * @license http://www.gnu.org/licenses/gpl-2.0.html
 * @copyright Copyright (c) 2016 Dominik Kocuj
 * @package kocuj_internal_lib
 */

// set namespace
namespace KocujInternalLib\V1a\Enums;

// security
if ((!defined('ABSPATH')) || ((isset($_SERVER['SCRIPT_FILENAME'])) && (basename($_SERVER['SCRIPT_FILENAME']) === basename(__FILE__)))) {
	header('HTTP/1.1 404 Not Found');
	die();
}

/**
 * Enumeration of settings menu parent type
 *
 * @access public
 */
class SettingsMenuParentType {
	/**
	 * Empty constructor for blocking of creating an instance of this class
	 *
	 * @access private
	 * @var void
	 */
	private function __construct() {}

	/**
	 * Dashboard menu
	 *
	 */
	const DASHBOARD = 1;

	/**
	 * Posts menu
	 *
	 */
	const POSTS = 2;

	/**
	 * Media menu
	 *
	 */
	const MEDIA = 3;

	/**
	 * Links menu
	 *
	 */
	const LINKS = 4;

	/**
	 * Pages menu
	 *
	 */
	const PAGES = 5;

	/**
	 * Comments menu
	 *
	 */
	const COMMENTS = 6;

	/**
	 * Themes menu
	 *
	 */
	const THEMES = 7;

	/**
	 * Plugins menu
	 *
	 */
	const PLUGINS = 8;

	/**
	 * Users menu
	 *
	 */
	const USERS = 9;

	/**
	 * Tools menu
	 *
	 */
	const TOOLS = 10;

	/**
	 * Options menu
	 *
	 */
	const OPTIONS = 11;
}
