<?php

/**
 * api-add-thanks-client-backend-add-thanks-strings.class.php
 *
 * @author Dominik Kocuj <dominik@kocuj.pl>
 * @license http://www.gnu.org/licenses/gpl-2.0.html
 * @copyright Copyright (c) 2013-2016 Dominik Kocuj
 * @package kocuj_sitemap
 */

// set namespace
namespace KocujSitemapPlugin\Classes;

// security
if ((!defined('ABSPATH')) || ((isset($_SERVER['SCRIPT_FILENAME'])) && (basename($_SERVER['SCRIPT_FILENAME']) === basename(__FILE__)))) {
	header('HTTP/1.1 404 Not Found');
	die();
}

/**
 * \KocujApiAddThanksClient\V1a\Classes\Backend\AddThanks class strings
 *
 * @access public
 */
class ApiAddThanksClientBackendAddThanksStrings implements \KocujInternalLib\V1a\Interfaces\Strings {
	/**
	 * Singleton instance
	 *
	 * @access private
	 * @var object
	 */
	private static $instance = NULL;

	/**
	 * Constructor
	 *
	 * @access private
	 * @return void
	 */
	private function __construct() {
	}

	/**
	 * Disable cloning of object
	 *
	 * @access private
	 * @return void
	 */
	private function __clone() {
	}

	/**
	 * Get singleton instance
	 *
	 * @access public
	 * @return object Singleton instance
	 */
	public static function getInstance() {
		// optionally create new instance
		if (!self::$instance) {
			self::$instance = new \KocujSitemapPlugin\Classes\ApiAddThanksClientBackendAddThanksStrings();
		}
		// exit
		return self::$instance;
	}

	/**
	 * Get string
	 *
	 * @access public
	 * @param string $id String id
	 * @return string Output string
	 */
	public function getString($id) {
		// get string
		switch ($id) {
			case 'ACTION_ADMIN_FOOTER_SCRIPT_MORE_INFO_LINK':
				return __('see more information about this', 'kocuj-sitemap');
			case 'ACTION_ADMIN_FOOTER_SCRIPT_WINDOW_TITLE':
				return __('More information about sending your website address', 'kocuj-sitemap');
			case 'ACTION_ADMIN_FOOTER_SCRIPT_WINDOW_LOADING':
				return __('Loading, please wait...', 'kocuj-sitemap');
			case 'ACTION_ADMIN_FOOTER_SCRIPT_WINDOW_LOADING_ERROR':
				return __('Loading error! Please, check your internet connection and refresh page to try again.', 'kocuj-sitemap');
			case 'ACTION_ADMIN_FOOTER_SCRIPT_SENDING':
				return __('Sending, please wait...', 'kocuj-sitemap');
			case 'ACTION_ADMIN_FOOTER_SCRIPT_ERROR':
				return __('Error! Retrying in few seconds.', 'kocuj-sitemap');
			case 'ACTION_ADMIN_FOOTER_SCRIPT_ERROR_NO_RETRIES':
				return __('Error! No data has been sent!', 'kocuj-sitemap');
			case 'ACTION_ADMIN_FOOTER_SCRIPT_ERROR_ALREADY_EXISTS':
				return __('Website address already exists.', 'kocuj-sitemap');
			case 'ACTION_ADMIN_FOOTER_SCRIPT_ERROR_WRONG_RESPONSE':
				return __('Error! Wrong response from server!', 'kocuj-sitemap');
			case 'ACTION_ADMIN_FOOTER_SCRIPT_SUCCESS':
				return __('Data has been sent. Thank you!', 'kocuj-sitemap');
		}
		// exit
		return '';
	}
}
