<?php

/**
 * pages.class.php
 *
 * @author Dominik Kocuj <dominik@kocuj.pl>
 * @license http://www.gnu.org/licenses/gpl-2.0.html
 * @copyright Copyright (c) 2013-2016 Dominik Kocuj
 * @package kocuj_sitemap
 */

// set namespace
namespace KocujSitemapPlugin\Classes\ElementType\Frontend;

// security
if ((!defined('ABSPATH')) || ((isset($_SERVER['SCRIPT_FILENAME'])) && (basename($_SERVER['SCRIPT_FILENAME']) === basename(__FILE__)))) {
	header('HTTP/1.1 404 Not Found');
	die();
}

/**
 * Pages type class
 *
 * @access public
 */
class Pages implements \KocujSitemapPlugin\Interfaces\ElementTypeFrontend {
	/**
	 * Check if this type exists
	 *
	 * @access public
	 * @return bool This type exists (true) or not (false)
	 */
	public function checkExists() {
		// check if this type exists
		return true;
	}

	/**
	 * Get type letter
	 *
	 * @access public
	 * @return string Type letter
	 */
	public function getTypeLetter() {
		// get type letter
		return 'G';
	}

	/**
	 * Get configuration options
	 *
	 * @access public
	 * @return array Configuration options
	 */
	public function getConfigOptions() {
		// get config options
		return array(
			array(
				'DisplayPages',
				'1',
				'checkbox',
				__('Display pages', 'kocuj-sitemap'),
				false,
				array(),
				false,
				0,
			),
			array(
				'DisplayPagesSort',
				'default',
				'string',
				__('Sort pages by', 'kocuj-sitemap'),
				false,
				array(),
				false,
				0,
			),
			array(
				'DisplayPagesOrder',
				'asc',
				'string',
				__('Sort pages order', 'kocuj-sitemap'),
				false,
				array(),
				false,
				0,
			),
		);
	}

	/**
	 * Check section name
	 *
	 * @access public
	 * @return bool Section name exists (true) or not (false)
	 */
	public function checkSectionName() {
		// check section name
		return true;
	}

	/**
	 * Get section name
	 *
	 * @access public
	 * @return string Section name
	 */
	public function getSectionName() {
		// get section name
		return __('Pages', 'kocuj-sitemap');
	}

	/**
	 * Get ID to check
	 *
	 * @access public
	 * @param array $element Element
	 * @param string $section Section name
	 * @return int ID to check
	 */
	public function getIDToCheck(array $element, $section) {
		// get ID to check
		return $element['id'];
	}

	/**
	 * Get sections to check
	 *
	 * @access public
	 * @param array $element Element
	 * @return array Sections to check
	 */
	public function getSectionsToCheck(array $element) {
		// get sections to check
		return array(
			'post',
		);
	}

	/**
	 * Check if there are exclude parameters (true) or not (false)
	 *
	 * @access public
	 * @return bool There are exclude parameters (true) or not (false)
	 */
	public function checkExcludeParameters() {
		// check if there are exclude parameters
		return true;
	}

	/**
	 * Get exclude parameters suffixes
	 *
	 * @access public
	 * @return array Exclude parameters suffixes
	 */
	public function getExcludeParametersSuffixes() {
		// get exclude parameters suffixes
		return array(
			'post' => __('pages', 'kocuj-sitemap'),
		);
	}

	/**
	 * Get types which should be removed when they have no children
	 *
	 * @access public
	 * @return array Types which should be removed when they have no children
	 */
	public function getTypesRequiresChildren() {
		// get types
		return array();
	}

	/**
	 * Check if there should be an "ul" list tag
	 *
	 * @access public
	 * @return bool There should be an "ul" list tag (true) or not (false)
	 */
	public function checkListTag() {
		// get if there should be an "ul" list tag
		return true;
	}

	/**
	 * Check if this type is configurable in order
	 *
	 * @access public
	 * @return bool This type is configurable in order (true) or not (false)
	 */
	public function checkConfigurableOrder() {
		// check if this type is configurable in order and separate administration page
		return true;
	}

	/**
	 * Get text before element
	 *
	 * @access public
	 * @param array $element Element
	 * @param bool $isWidget Sitemap for widget (true) or not (false) - default: false
	 * @param string $locale Language locale - default: empty
	 * @return array Text before element
	 */
	public function getBeforeElement(array $element, $isWidget = false, $locale = '') {
		// get text before element
		return '';
	}

	/**
	 * Get text after element
	 *
	 * @access public
	 * @param array $element Element
	 * @param bool $isWidget Sitemap for widget (true) or not (false) - default: false
	 * @param string $locale Language locale - default: empty
	 * @return array Text after element
	 */
	public function getAfterElement(array $element, $isWidget = false, $locale = '') {
		// get text after element
		return '';
	}
}
