// Copyright (c) 2016 Dominik Kocuj <dominik@kocuj.pl>
// License: http://www.gnu.org/licenses/gpl-2.0.html

/* jshint globalstrict: true */

/* global jQuery */
/* global window */

/* global ajaxurl */

/* global kocujInternalLibV1aHelper */
/* global kocujInternalLibV1aModal */

/* global kocujApiAddThanksClientV1aBackendAddThanksSettings */

// add thanks prototype constructor
function kocujApiAddThanksClientV1aClassBackendAddThanks() {
	'use strict';
	/* jshint validthis: true */
	// get this object
	var self = this;
	// get settings
	if (typeof kocujApiAddThanksClientV1aBackendAddThanksSettings !== 'undefined') {
		if (kocujApiAddThanksClientV1aBackendAddThanksSettings.prefix !== undefined) {
			self._settingsPrefix = kocujApiAddThanksClientV1aBackendAddThanksSettings.prefix;
		}
		if (kocujApiAddThanksClientV1aBackendAddThanksSettings.prefixKocujInternalLib !== undefined) {
			self._settingsPrefixKocujInternalLib = kocujApiAddThanksClientV1aBackendAddThanksSettings.prefixKocujInternalLib;
		}
		if (kocujApiAddThanksClientV1aBackendAddThanksSettings.security !== undefined) {
			self._settingsSecurity = kocujApiAddThanksClientV1aBackendAddThanksSettings.security;
		}
		if (kocujApiAddThanksClientV1aBackendAddThanksSettings.useProxy !== undefined) {
			if (kocujApiAddThanksClientV1aBackendAddThanksSettings.useProxy === '1') {
				self._settingsUseProxy = true;
			} else {
				self._settingsUseProxy = false;
			}
		}
		if (kocujApiAddThanksClientV1aBackendAddThanksSettings.websiteUrl !== undefined) {
			self._settingsWebsiteUrl = kocujApiAddThanksClientV1aBackendAddThanksSettings.websiteUrl;
		}
		if (kocujApiAddThanksClientV1aBackendAddThanksSettings.websiteTitle !== undefined) {
			self._settingsWebsiteTitle = kocujApiAddThanksClientV1aBackendAddThanksSettings.websiteTitle;
		}
		if (kocujApiAddThanksClientV1aBackendAddThanksSettings.websiteDescription !== undefined) {
			self._settingsWebsiteDescription = kocujApiAddThanksClientV1aBackendAddThanksSettings.websiteDescription;
		}
		if (kocujApiAddThanksClientV1aBackendAddThanksSettings.textMoreInfoLink !== undefined) {
			self._settingsTextMoreInfoLink = kocujApiAddThanksClientV1aBackendAddThanksSettings.textMoreInfoLink;
		}
		if (kocujApiAddThanksClientV1aBackendAddThanksSettings.textWindowTitle !== undefined) {
			self._settingsTextWindowTitle = kocujApiAddThanksClientV1aBackendAddThanksSettings.textWindowTitle;
		}
		if (kocujApiAddThanksClientV1aBackendAddThanksSettings.textWindowLoading !== undefined) {
			self._settingsTextWindowLoading = kocujApiAddThanksClientV1aBackendAddThanksSettings.textWindowLoading;
		}
		if (kocujApiAddThanksClientV1aBackendAddThanksSettings.textWindowLoadingError !== undefined) {
			self._settingsTextWindowLoadingError = kocujApiAddThanksClientV1aBackendAddThanksSettings.textWindowLoadingError;
		}
		if (kocujApiAddThanksClientV1aBackendAddThanksSettings.textSending !== undefined) {
			self._settingsTextSending = kocujApiAddThanksClientV1aBackendAddThanksSettings.textSending;
		}
		if (kocujApiAddThanksClientV1aBackendAddThanksSettings.textError !== undefined) {
			self._settingsTextError = kocujApiAddThanksClientV1aBackendAddThanksSettings.textError;
		}
		if (kocujApiAddThanksClientV1aBackendAddThanksSettings.textErrorNoRetries !== undefined) {
			self._settingsTextErrorNoRetries = kocujApiAddThanksClientV1aBackendAddThanksSettings.textErrorNoRetries;
		}
		if (kocujApiAddThanksClientV1aBackendAddThanksSettings.textErrorAlreadyExists !== undefined) {
			self._settingsTextErrorAlreadyExists = kocujApiAddThanksClientV1aBackendAddThanksSettings.textErrorAlreadyExists;
		}
		if (kocujApiAddThanksClientV1aBackendAddThanksSettings.textErrorWrongResponse !== undefined) {
			self._settingsTextErrorWrongResponse = kocujApiAddThanksClientV1aBackendAddThanksSettings.textErrorWrongResponse;
		}
		if (kocujApiAddThanksClientV1aBackendAddThanksSettings.textSuccess !== undefined) {
			self._settingsTextSuccess = kocujApiAddThanksClientV1aBackendAddThanksSettings.textSuccess;
		}
		if (kocujApiAddThanksClientV1aBackendAddThanksSettings.imageLoadingUrl !== undefined) {
			self._settingsImageLoadingUrl = kocujApiAddThanksClientV1aBackendAddThanksSettings.imageLoadingUrl;
		}
	}
}

// add thanks prototype
kocujApiAddThanksClientV1aClassBackendAddThanks.prototype = {
	// projects
	_projects : [],
	// sending states
	_sendState : {
		RETRY : 0,
		ERROR : 1,
		SUCCESS : 2
	},
	// settings
	_settingsPrefix : '',
	_settingsPrefixKocujInternalLib : '',
	_settingsSecurity : '',
	_settingsUseProxy : true,
	_settingsWebsiteUrl : '',
	_settingsWebsiteTitle : '',
	_settingsWebsiteDescription : '',
	_settingsTextMoreInfoLink : '',
	_settingsTextWindowTitle : '',
	_settingsTextWindowLoading : '',
	_settingsTextWindowLoadingError : '',
	_settingsTextSending : '',
	_settingsTextError : '',
	_settingsTextErrorNoRetries : '',
	_settingsTextErrorAlreadyExists : '',
	_settingsTextErrorWrongResponse : '',
	_settingsTextSuccess : '',
	_settingsImageLoadingUrl : '',

	// add project
	addProject : function(projectId, projectApiUrl, projectApiLogin, projectApiPassword) {
		'use strict';
		// parse parameters
		projectId = kocujInternalLibV1aHelper.initializeString(projectId);
		if (projectId === '') {
			return;
		}
		projectApiUrl = kocujInternalLibV1aHelper.initializeString(projectApiUrl);
		projectApiLogin = kocujInternalLibV1aHelper.initializeString(projectApiLogin);
		projectApiPassword = kocujInternalLibV1aHelper.initializeString(projectApiPassword);
		// add project
		this._projects['prj_' + projectId] = {
			projectApiUrl : projectApiUrl,
			projectApiLogin : projectApiLogin,
			projectApiPassword : projectApiPassword,
			retries : 0,
			timer : null
		};
		kocujInternalLibV1aModal.addProject(projectId);
	},

	// get HTML selector for review message
	getHTMLSelectorReviewMessageDiv : function(projectId) {
		'use strict';
		// exit
		return '#' + this._getHTMLNameReviewMessageDiv(projectId);
	},

	// get HTML selector for more information link div in review message
	getHTMLSelectorAddThanksReviewMessageMoreInfoLinkDiv : function(projectId) {
		'use strict';
		// exit
		return '#' + this._getHTMLNameAddThanksReviewMessageMoreInfoLinkDiv(projectId);
	},

	// get HTML selector for more information link in review message
	getHTMLSelectorAddThanksReviewMessageMoreInfoLink : function(projectId) {
		'use strict';
		// exit
		return this.getHTMLSelectorAddThanksReviewMessageMoreInfoLinkDiv(projectId) + ' #' + this._getHTMLNameAddThanksReviewMessageMoreInfoLink(projectId);
	},

	// get HTML selector for send button in review message
	getHTMLSelectorAddThanksReviewMessageSend : function(projectId) {
		'use strict';
		// exit
		return '#' + this._getHTMLNameAddThanksReviewMessageSend(projectId);
	},

	// get HTML selector for close message in review message
	getHTMLSelectorReviewMessageClose : function(projectId) {
		'use strict';
		// exit
		return '#' + this._getHTMLNameReviewMessageClose(projectId);
	},

	// get HTML selector for loading image in review message
	getHTMLSelectorAddThanksReviewMessageLoadingImage : function(projectId) {
		'use strict';
		// exit
		return '#' + this._getHTMLNameAddThanksReviewMessageLoadingImage(projectId);
	},

	// get HTML selector for adding thanks div in page about
	getHTMLSelectorAddThanksPageAboutDiv : function(projectId) {
		'use strict';
		// exit
		return '#' + this._getHTMLNameAddThanksPageAboutDiv(projectId);
	},

	// get HTML selector for more information link in page about
	getHTMLSelectorAddThanksPageAboutMoreInfoLink : function(projectId) {
		'use strict';
		// exit
		return this.getHTMLSelectorAddThanksPageAboutDiv(projectId) + ' #' + this._getHTMLNameAddThanksPageAboutMoreInfoLink(projectId);
	},

	// get HTML selector for send button in page about
	getHTMLSelectorAddThanksPageAboutSend : function(projectId) {
		'use strict';
		// exit
		return this.getHTMLSelectorAddThanksPageAboutDiv(projectId) + ' #' + this._getHTMLNameAddThanksPageAboutSend(projectId);
	},

	// get HTML selector for status div in page about
	getHTMLSelectorAddThanksPageAboutStatusDiv : function(projectId) {
		'use strict';
		// exit
		return this.getHTMLSelectorAddThanksPageAboutDiv(projectId) + ' #' + this._getHTMLNameAddThanksPageAboutStatusDiv(projectId);
	},

	// get HTML selector for loading div in page about
	getHTMLSelectorAddThanksPageAboutLoadingDiv : function(projectId) {
		'use strict';
		// exit
		return this.getHTMLSelectorAddThanksPageAboutDiv(projectId) + ' #' + this._getHTMLNameAddThanksPageAboutLoadingDiv(projectId);
	},

	// get HTML selector for window header with more information
	getHTMLSelectorAddThanksMoreInfoWindowHeader : function(projectId) {
		'use strict';
		// exit
		return '#' + this._getHTMLNameAddThanksMoreInfoWindowHeader(projectId);
	},

	// get HTML selector for window with more information
	getHTMLSelectorAddThanksMoreInfoWindow : function(projectId) {
		'use strict';
		// exit
		return '#' + this._getHTMLNameAddThanksMoreInfoWindow(projectId);
	},

	// set adding thanks for review message
	setReviewMessageAddThanks : function(projectId) {
		'use strict';
		// get this object
		var self = this;
		(function($) {
			// parse parameters
			projectId = kocujInternalLibV1aHelper.initializeString(projectId);
			if (projectId === '') {
				return;
			}
			// check if project exists
			if (self._projects['prj_' + projectId] === undefined) {
				return;
			}
			// add link to more information
			$(self.getHTMLSelectorAddThanksReviewMessageMoreInfoLinkDiv(projectId)).html('<a href="#" id="' + self._getHTMLNameAddThanksReviewMessageMoreInfoLink(projectId) + '">' + self._settingsTextMoreInfoLink + '</a>');
			$(self.getHTMLSelectorAddThanksReviewMessageMoreInfoLink(projectId)).attr('href', 'javascript:void(0);');
			$(self.getHTMLSelectorAddThanksReviewMessageMoreInfoLink(projectId)).bind('click', { projectId : projectId }, function(event) {
				self._showMoreInfoWindow(event.data.projectId);
			});
			// set button event to add thanks
			$(self.getHTMLSelectorAddThanksReviewMessageSend(projectId)).bind('click', { projectId : projectId }, function(event) {
				self._projects['prj_' + event.data.projectId].retries = 1;
				self._addThanks(event.data.projectId);
			});
		}(jQuery));
	},

	// set adding thanks for page about
	setPageAboutAddThanks : function(projectId) {
		'use strict';
		// get this object
		var self = this;
		(function($) {
			// parse parameters
			projectId = kocujInternalLibV1aHelper.initializeString(projectId);
			if (projectId === '') {
				return;
			}
			// check if project exists
			if (self._projects['prj_' + projectId] === undefined) {
				return;
			}
			// add link to more information
			$(self.getHTMLSelectorAddThanksPageAboutMoreInfoLink(projectId)).attr('href', 'javascript:void(0);');
			$(self.getHTMLSelectorAddThanksPageAboutMoreInfoLink(projectId)).bind('click', { projectId : projectId }, function(event) {
				self._showMoreInfoWindow(event.data.projectId);
			});
			// set button event to add thanks
			$(self.getHTMLSelectorAddThanksPageAboutSend(projectId)).bind('click', { projectId : projectId }, function(event) {
				self._projects['prj_' + event.data.projectId].retries = 1;
				self._addThanks(event.data.projectId);
			});
		}(jQuery));
	},

	// get HTML prefix
	_getHTMLPrefix : function(projectId) {
		'use strict';
		// exit
		return this._settingsPrefix + '_' + projectId + '__';
	},

	// get HTML prefix for Kocuj Internal Lib
	_getHTMLPrefixKocujInternalLib : function(projectId) {
		'use strict';
		// exit
		return this._settingsPrefixKocujInternalLib + '_' + projectId + '__';
	},

	// get HTML name for more information review message
	_getHTMLNameReviewMessageDiv : function(projectId) {
		'use strict';
		// exit
		return this._getHTMLPrefixKocujInternalLib(projectId) + 'message_review';
	},

	// get HTML name for more information link div in review message
	_getHTMLNameAddThanksReviewMessageMoreInfoLinkDiv : function(projectId) {
		'use strict';
		// exit
		return this._getHTMLPrefix(projectId) + 'add_thanks_review_message_more_info_link_div';
	},

	// get HTML name for more information link in review message
	_getHTMLNameAddThanksReviewMessageMoreInfoLink : function(projectId) {
		'use strict';
		// exit
		return this._getHTMLPrefix(projectId) + 'add_thanks_review_message_more_info_link';
	},

	// get HTML name for send button in review message
	_getHTMLNameAddThanksReviewMessageSend : function(projectId) {
		'use strict';
		// exit
		return this._getHTMLPrefix(projectId) + 'add_thanks_review_message_send';
	},

	// get HTML name for close message in review message
	_getHTMLNameReviewMessageClose : function(projectId) {
		'use strict';
		// exit
		return this._getHTMLPrefixKocujInternalLib(projectId) + 'review_message_close';
	},

	// get HTML name for loading image in review message
	_getHTMLNameAddThanksReviewMessageLoadingImage : function(projectId) {
		'use strict';
		// exit
		return this._getHTMLPrefixKocujInternalLib(projectId) + 'add_thanks_review_message_loading_image';
	},

	// get HTML name for adding thanks div in page about
	_getHTMLNameAddThanksPageAboutDiv : function(projectId) {
		'use strict';
		// exit
		return this._getHTMLPrefix(projectId) + 'add_thanks_page_about_div';
	},

	// get HTML name for more information link in page about
	_getHTMLNameAddThanksPageAboutMoreInfoLink : function(projectId) {
		'use strict';
		// exit
		return this._getHTMLPrefix(projectId) + 'add_thanks_page_about_more_info_link';
	},

	// get HTML name for send button in page about
	_getHTMLNameAddThanksPageAboutSend : function(projectId) {
		'use strict';
		// exit
		return this._getHTMLPrefix(projectId) + 'add_thanks_page_about_send';
	},

	// get HTML name for status div in page about
	_getHTMLNameAddThanksPageAboutStatusDiv : function(projectId) {
		'use strict';
		// exit
		return this._getHTMLPrefix(projectId) + 'add_thanks_page_about_status_div';
	},

	// get HTML name for loading div in page about
	_getHTMLNameAddThanksPageAboutLoadingDiv : function(projectId) {
		'use strict';
		// exit
		return this._getHTMLPrefix(projectId) + 'add_thanks_page_about_loading_div';
	},

	// get HTML name for window header with more information
	_getHTMLNameAddThanksMoreInfoWindowHeader : function(projectId) {
		'use strict';
		// exit
		return this._getHTMLPrefix(projectId) + 'add_thanks_more_info_window_header';
	},

	// get HTML name for window with more information
	_getHTMLNameAddThanksMoreInfoWindow : function(projectId) {
		'use strict';
		// exit
		return this._getHTMLPrefix(projectId) + 'add_thanks_more_info_window';
	},

	// add thanks
	_addThanks : function(projectId) {
		'use strict';
		// get this object
		var self = this;
		(function($) {
			// parse parameters
			projectId = kocujInternalLibV1aHelper.initializeString(projectId);
			if (projectId === '') {
				return;
			}
			// check if project exists
			if (self._projects['prj_' + projectId] === undefined) {
				return;
			}
			// deactivate timeout
			self._deactivateAjaxAddThanksTimeout(projectId);
			// change elements at the beginning of AJAX
			self._ajaxAddThanksBeginChangeElements(projectId);
			// add thanks
			var url = ajaxurl;
			var data = {
				action: self._settingsPrefix + '_' + projectId + '__add_thanks_proxy',
				security: self._settingsSecurity
			};
			if (!self._settingsUseProxy) {
				url = self._projects['prj_' + projectId].projectApiUrl;
				data = {
					'requestType': 'parameters',
					'responseType': 'JSON',
					'requestMethod': 'GET',
					'data' : {
						'PARAMETER_version': 1,
						'header' : {
							'login': self._projects['prj_' + projectId].projectApiLogin,
							'password': self._projects['prj_' + projectId].projectApiPassword
						},
						'request': {
							'PARAMETER_command': 'ADD_THANKS',
							'url': self._settingsWebsiteUrl,
							'title': self._settingsWebsiteTitle,
							'description': self._settingsWebsiteDescription
						}
					}
				};
				self._activateAjaxAddThanksTimeout(projectId);
			}
			$.ajax({
				url: url,
				async: true,
				cache: false,
				data: data,
				dataType: 'jsonp',
				error: function(obj, status, err) {
					self._ajaxAddThanksError(projectId, false);
				},
				success: function(data, status, obj) {
					self._ajaxAddThanksSuccess(projectId, data);
				},
				jsonpCallback: self._settingsPrefix + '_callback',
				type: 'GET'
			});
		}(jQuery));
	},

	// activate AJAX timeout for adding thanks
	_activateAjaxAddThanksTimeout : function(projectId) {
		'use strict';
		// parse parameters
		projectId = kocujInternalLibV1aHelper.initializeString(projectId);
		if (projectId === '') {
			return;
		}
		// check if project exists
		if (this._projects['prj_' + projectId] === undefined) {
			return;
		}
		// deactivate old timer
		this._deactivateAjaxAddThanksTimeout(projectId);
		// set timer
		this._projects['prj_' + projectId].timer = window.setTimeout(function() {
			this._ajaxAddThanksError(projectId, false);
		}, 30000);
	},

	// deactivate AJAX timeout for adding thanks
	_deactivateAjaxAddThanksTimeout : function(projectId) {
		'use strict';
		// parse parameters
		projectId = kocujInternalLibV1aHelper.initializeString(projectId);
		if (projectId === '') {
			return;
		}
		// check if project exists
		if (this._projects['prj_' + projectId] === undefined) {
			return;
		}
		// clear timer
		if (this._projects['prj_' + projectId].timer !== null) {
			window.clearTimeout(this._projects['prj_' + projectId].timer);
			this._projects['prj_' + projectId].timer = null;
		}
	},

	// change HTML elements at the beginning of AJAX
	_ajaxAddThanksBeginChangeElements : function(projectId) {
		'use strict';
		// get this object
		var self = this;
		(function($) {
			// parse parameters
			projectId = kocujInternalLibV1aHelper.initializeString(projectId);
			if (projectId === '') {
				return;
			}
			// check if project exists
			if (self._projects['prj_' + projectId] === undefined) {
				return;
			}
			// show information about sending process
			if ($(self.getHTMLSelectorAddThanksReviewMessageSend(projectId)).length > 0) {
				$(self.getHTMLSelectorAddThanksReviewMessageSend(projectId)).attr('disabled', true);
			}
			if ($(self.getHTMLSelectorAddThanksPageAboutSend(projectId)).length > 0) {
				$(self.getHTMLSelectorAddThanksPageAboutSend(projectId)).attr('disabled', true);
			}
			if ($(self.getHTMLSelectorAddThanksReviewMessageMoreInfoLinkDiv(projectId)).length > 0) {
				$(self.getHTMLSelectorAddThanksReviewMessageMoreInfoLinkDiv(projectId)).html('<em>' + self._settingsTextSending + '</em>');
			}
			if ($(self.getHTMLSelectorAddThanksPageAboutStatusDiv(projectId)).length > 0) {
				$(self.getHTMLSelectorAddThanksPageAboutStatusDiv(projectId)).html('<em>' + self._settingsTextSending + '</em>');
				$(self.getHTMLSelectorAddThanksPageAboutStatusDiv(projectId)).show();
				$(self.getHTMLSelectorAddThanksPageAboutLoadingDiv(projectId)).show();
			}
			// disable closing review message
			if ($(self.getHTMLSelectorReviewMessageClose(projectId)).length > 0) {
				$(self.getHTMLSelectorReviewMessageClose(projectId)).hide();
				$(self.getHTMLSelectorReviewMessageDiv(projectId)).append('<div id="' + self._getHTMLNameAddThanksReviewMessageLoadingImage(projectId) + '" style="margin-left:5px;margin-bottom:5px;"><img src="' + self._settingsImageLoadingUrl + '" alt="" /></div>');
			}
		}(jQuery));
	},

	// change HTML elements at the ending of AJAX
	_ajaxAddThanksEndChangeElements : function(projectId, state) {
		'use strict';
		// get this object
		var self = this;
		(function($) {
			// parse parameters
			projectId = kocujInternalLibV1aHelper.initializeString(projectId);
			if (projectId === '') {
				return;
			}
			state = kocujInternalLibV1aHelper.initializeNumeric(state);
			// check if project exists
			if (self._projects['prj_' + projectId] === undefined) {
				return;
			}
			// change HTML elements in review message
			if ($(self.getHTMLSelectorAddThanksReviewMessageLoadingImage(projectId)).length > 0) {
				$(self.getHTMLSelectorAddThanksReviewMessageLoadingImage(projectId)).remove();
			}
			if ((state !== self._sendState.RETRY) && ($(self.getHTMLSelectorReviewMessageClose(projectId)).length > 0)) {
				$(self.getHTMLSelectorReviewMessageClose(projectId)).show();
			}
			if ((state !== self._sendState.RETRY) && (state !== self._sendState.SUCCESS) && ($(self.getHTMLSelectorAddThanksReviewMessageSend(projectId)).length > 0)) {
				$(self.getHTMLSelectorAddThanksReviewMessageSend(projectId)).removeAttr('disabled');
			}
			if ((state !== self._sendState.RETRY) && (state !== self._sendState.SUCCESS) && ($(self.getHTMLSelectorAddThanksPageAboutSend(projectId)).length > 0)) {
				$(self.getHTMLSelectorAddThanksPageAboutSend(projectId)).removeAttr('disabled');
			}
		}(jQuery));
	},

	// AJAX loading success for adding thanks
	_ajaxAddThanksSuccess : function(projectId, data) {
		'use strict';
		// get this object
		var self = this;
		(function($) {
			// parse parameters
			projectId = kocujInternalLibV1aHelper.initializeString(projectId);
			if (projectId === '') {
				return;
			}
			// check if project exists
			if (self._projects['prj_' + projectId] === undefined) {
				return;
			}
			// deactivate timeout
			self._deactivateAjaxAddThanksTimeout(projectId);
			// prepare text to display
			var text = self._settingsTextSuccess;
			// check results
			if ((data.status !== undefined) && (data.status.id !== undefined)) {
				if (data.status.id !== 'OK') {
					if (data.status.id === 'CT_ADD_THANKS_URLALREADYEXISTS') {
						text = self._settingsTextErrorAlreadyExists;
					} else {
						self._ajaxAddThanksError(projectId, true);
						return;
					}
				}
			} else {
				self._ajaxAddThanksError(projectId, true);
				return;
			}
			// change elements at the end of AJAX
			self._ajaxAddThanksEndChangeElements(projectId, self._sendState.SUCCESS);
			// save information about added thanks
			$.ajax({
				url: ajaxurl,
				async: true,
				cache: false,
				data: {
					action: self._settingsPrefix + '_' + projectId + '__add_thanks_finished',
					security: self._settingsSecurity
				},
				type: 'POST'
			});
			// show information about success
			if ($(self.getHTMLSelectorAddThanksReviewMessageMoreInfoLinkDiv(projectId)).length > 0) {
				$(self.getHTMLSelectorAddThanksReviewMessageMoreInfoLinkDiv(projectId)).html('<strong>' + text + '</strong>');
			}
			if ($(self.getHTMLSelectorAddThanksPageAboutStatusDiv(projectId)).length > 0) {
				$(self.getHTMLSelectorAddThanksPageAboutStatusDiv(projectId)).html('<strong>' + text + '</strong>');
				$(self.getHTMLSelectorAddThanksPageAboutStatusDiv(projectId)).show();
				$(self.getHTMLSelectorAddThanksPageAboutLoadingDiv(projectId)).hide();
			}
			// add timeout to remove adding thanks div
			if (($(self.getHTMLSelectorAddThanksReviewMessageSend(projectId)).length > 0) || ($(self.getHTMLSelectorAddThanksPageAboutDiv(projectId)).length > 0)) {
				self._projects['prj_' + projectId].timer = window.setTimeout(function() {
					// deactivate timeout
					self._deactivateAjaxAddThanksTimeout(projectId);
					// remove adding thanks div
					if ($(self.getHTMLSelectorAddThanksReviewMessageSend(projectId)).length > 0) {
						$(self.getHTMLSelectorAddThanksReviewMessageSend(projectId)).parent().fadeOut('slow', function() {
							$(self.getHTMLSelectorAddThanksReviewMessageSend(projectId)).parent().remove();
						});
					}
					if ($(self.getHTMLSelectorAddThanksPageAboutDiv(projectId)).length > 0) {
						$(self.getHTMLSelectorAddThanksPageAboutDiv(projectId)).fadeOut('slow', function() {
							$(self.getHTMLSelectorAddThanksPageAboutDiv(projectId)).remove();
						});
					}
				}, 5000);
			}
		}(jQuery));
	},

	// AJAX loading error for adding thanks
	_ajaxAddThanksError : function(projectId, protocolError) {
		'use strict';
		// get this object
		var self = this;
		(function($) {
			// parse parameters
			projectId = kocujInternalLibV1aHelper.initializeString(projectId);
			if (projectId === '') {
				return;
			}
			protocolError = kocujInternalLibV1aHelper.initializeBoolean(protocolError);
			// check if project exists
			if (self._projects['prj_' + projectId] === undefined) {
				return;
			}
			// deactivate timeout
			self._deactivateAjaxAddThanksTimeout(projectId);
			// change elements at the end of AJAX
			self._ajaxAddThanksEndChangeElements(projectId, self._sendState.RETRY);
			// add retry
			self._projects['prj_' + projectId].retries++;
			// show information about error
			var info = self._settingsTextError;
			if (self._projects['prj_' + projectId].retries > 3) {
				if (!protocolError) {
					info = self._settingsTextErrorNoRetries;
				} else {
					info = self._settingsTextErrorWrongResponse;
				}
			}
			if ($(self.getHTMLSelectorAddThanksReviewMessageMoreInfoLinkDiv(projectId)).length > 0) {
				$(self.getHTMLSelectorAddThanksReviewMessageMoreInfoLinkDiv(projectId)).html('<strong>' + info + '</strong>');
			}
			if ($(self.getHTMLSelectorAddThanksPageAboutStatusDiv(projectId)).length > 0) {
				$(self.getHTMLSelectorAddThanksPageAboutStatusDiv(projectId)).html('<strong>' + info + '</strong>');
				$(self.getHTMLSelectorAddThanksPageAboutStatusDiv(projectId)).show();
				$(self.getHTMLSelectorAddThanksPageAboutLoadingDiv(projectId)).hide();
			}
			// retry
			if (self._projects['prj_' + projectId].retries <= 3) {
				self._projects['prj_' + projectId].timer = window.setTimeout(function() {
					self._addThanks(projectId);
				}, 5000);
			}
			// change elements at the end of AJAX
			if (self._projects['prj_' + projectId].retries > 3) {
				self._ajaxAddThanksEndChangeElements(projectId, self._sendState.ERROR);
			}
		}(jQuery));
	},

	// show window with more information
	_showMoreInfoWindow : function(projectId) {
		'use strict';
		// get this object
		var self = this;
		(function($) {
			// parse parameters
			projectId = kocujInternalLibV1aHelper.initializeString(projectId);
			if (projectId === '') {
				return;
			}
			// check if project exists
			if (self._projects['prj_' + projectId] === undefined) {
				return;
			}
			// prepare modal window
			var totalHeight = parseInt($(window).height(), 10)-200;
			if (totalHeight < 140) {
				totalHeight = 140;
			}
			kocujInternalLibV1aModal.prepareModal(projectId,
				'<div id="' + self._getHTMLNameAddThanksMoreInfoWindowHeader(projectId) + '">' +
				self._settingsTextWindowTitle +
				'</div>' +
				'<div id="' + self._getHTMLNameAddThanksMoreInfoWindow(projectId) + '">' +
				'<em>' +
				self._settingsTextWindowLoading +
				'</em>' +
				'</div>', 600, totalHeight, projectId);
			// set style
			$(self.getHTMLSelectorAddThanksMoreInfoWindowHeader(projectId)).css({
				'box-sizing': 'content-box',
				'font-size': '13px',
				'text-align': 'center',
				'font-weight': 'normal',
				'line-height': '28px',
				'width': '600px',
				'height': '28px',
				'color': '#cccccc',
				'background-color': '#464646'
			});
			$(self.getHTMLSelectorAddThanksMoreInfoWindow(projectId)).css({
				'box-sizing': 'content-box',
				'font-size': '12px',
				'text-align': 'left',
				'font-weight': 'normal',
				'width': '580px',
				'height': parseInt(totalHeight-28-20, 10) + 'px',
				'padding': '10px 10px 10px 10px',
				'color': '#464646',
				'background-color': '#ffffff',
				'border-bottom-color': '#000000',
				'border-bottom-style': 'solid',
				'border-bottom-width': '0',
				'overflow': 'auto'
			});
			// show window
			kocujInternalLibV1aModal.showPreparedModal(projectId, '', 1.0);
			// call AJAX
			$.ajax({
				url: ajaxurl,
				async: true,
				cache: false,
				data: {
					action: self._settingsPrefix + '_' + projectId + '__add_thanks_more_info_window_display',
					security: self._settingsSecurity
				},
				error: function(obj, status, err) {
					self._ajaxMoreInfoWindowError(projectId, obj, status, err);
				},
				success: function(data, status, obj) {
					self._ajaxMoreInfoWindowSuccess(projectId, data, status, obj);
				},
				type: 'POST'
			});
		}(jQuery));
	},

	// AJAX loading success for window with more information
	_ajaxMoreInfoWindowSuccess : function(projectId, data, status, obj) {
		'use strict';
		// get this object
		var self = this;
		(function($) {
			// parse parameters
			projectId = kocujInternalLibV1aHelper.initializeString(projectId);
			// set HTML data
			$(self.getHTMLSelectorAddThanksMoreInfoWindow(projectId)).html(data);
			// set external links
			$(self.getHTMLSelectorAddThanksMoreInfoWindow(projectId) + ' a[rel=external]').attr('target', '_blank');
		}(jQuery));
	},

	// AJAX loading error for window with more information
	_ajaxMoreInfoWindowError : function(projectId, obj, status, err) {
		'use strict';
		// get this object
		var self = this;
		(function($) {
			// parse parameters
			projectId = kocujInternalLibV1aHelper.initializeString(projectId);
			// set HTML data
			$(self.getHTMLSelectorAddThanksMoreInfoWindow(projectId)).html('<strong>' + self._settingsTextWindowLoadingError + '</strong>');
		}(jQuery));
	}
};

// initialize
var kocujApiAddThanksClientV1aBackendAddThanks = new kocujApiAddThanksClientV1aClassBackendAddThanks();
