<?php

/**
 * project-type.class.php
 *
 * @author Dominik Kocuj <dominik@kocuj.pl>
 * @license http://www.gnu.org/licenses/gpl-2.0.html
 * @copyright Copyright (c) 2016 Dominik Kocuj
 * @package kocuj_internal_lib
 */

// set namespace
namespace KocujInternalLib\V1a\Enums;

// security
if ((!defined('ABSPATH')) || ((isset($_SERVER['SCRIPT_FILENAME'])) && (basename($_SERVER['SCRIPT_FILENAME']) === basename(__FILE__)))) {
	header('HTTP/1.1 404 Not Found');
	die();
}

/**
 * Enumeration of type of project
 *
 * @access public
 */
class ProjectType {
	/**
	 * Empty constructor for blocking of creating an instance of this class
	 *
	 * @access private
	 * @var void
	 */
	private function __construct() {}

	/**
	 * It is plugin
	 *
	 */
	const PLUGIN = 0;

	/**
	 * It is theme
	 *
	 */
	const THEME = 1;
}
