<?php

/**
 * dirs.class.php
 *
 * @author Dominik Kocuj <dominik@kocuj.pl>
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU General Public License v2 or later
 * @copyright Copyright (c) 2016 Dominik Kocuj
 * @package kocuj_internal_lib
 */

// set namespace
namespace KocujInternalLib\V2a\Classes\Project;

// security
if ((!defined('ABSPATH')) || ((isset($_SERVER['SCRIPT_FILENAME'])) && (basename($_SERVER['SCRIPT_FILENAME']) === basename(__FILE__)))) {
	header('HTTP/1.1 404 Not Found');
	die();
}

/**
 * Directories class
 *
 * @access public
 */
class Dirs extends \KocujInternalLib\V2a\Classes\ProjectObject {
	/**
	 * Project directory
	 *
	 * @access private
	 * @var string
	 */
	private $projectDir = '';

	/**
	 * License directory
	 *
	 * @access private
	 * @var string
	 */
	private $licenseDir = '';

	/**
	 * Custom images directory
	 *
	 * @access private
	 * @var string
	 */
	private $customImagesDir = '';

	/**
	 * TinyMCE buttons JavaScript directory
	 *
	 * @access private
	 * @var string
	 */
	private $tinyMceButtonsJSDir = '';

	/**
	 * TinyMCE buttons PHP directory
	 *
	 * @access private
	 * @var string
	 */
	private $tinyMceButtonsPHPDir = '';

	/**
	 * Constructor
	 *
	 * @access public
	 * @param object $projectObj \KocujInternalLib\V2a\Classes\Project object for current project
	 * @return void
	 */
	public function __construct($projectObj) {
		// execute parent constructor
		parent::__construct($projectObj);
		// set directories
		$this->projectDir = dirname($this->getProjectObj()->getSettingMainFilename());
		$this->licenseDir = $this->projectDir;
		$this->customImagesDir = $this->projectDir.'/images';
		$this->tinyMceButtonsJSDir = $this->projectDir.'/js/tiny-mce';
		$this->tinyMceButtonsPHPDir = $this->projectDir.'/php/tiny-mce';
	}

	/**
	 * Get project directory
	 *
	 * @access public
	 * @return string Project directory
	 */
	public function getProjectDir() {
		// get project directory
		return $this->projectDir;
	}

	/**
	 * Set license subdirectory inside the project directory
	 *
	 * @access public
	 * @param string $licenseSubDir License subdirectory inside the project directory
	 * @return void
	 */
	public function setLicenseSubDir($licenseSubDir) {
		// set license subdirectory inside the project directory
		$this->licenseDir = $this->projectDir.'/'.$licenseSubDir;
	}

	/**
	 * Get license directory
	 *
	 * @access public
	 * @return string License directory
	 */
	public function getLicenseDir() {
		// get license directory
		return $this->licenseDir;
	}

	/**
	 * Set custom images subdirectory inside the project directory
	 *
	 * @access public
	 * @param string $customImagesDir Custom images subdirectory inside the project directory
	 * @return void
	 */
	public function setCustomImagesSubDir($customImagesSubDir) {
		// set custom images subdirectory inside the project directory
		$this->customImagesDir = $this->projectDir.'/'.$customImagesSubDir;
	}

	/**
	 * Get custom images directory
	 *
	 * @access public
	 * @return string Custom images directory
	 */
	public function getCustomImagesDir() {
		// get custom images directory
		return $this->customImagesDir;
	}

	/**
	 * Set TinyMCE buttons JavaScript subdirectory inside the project directory
	 *
	 * @access public
	 * @param string $tinyMceButtonsJSSubDir TinyMCE buttons JavaScript subdirectory inside the project directory
	 * @return void
	 */
	public function setTinyMceButtonsJSSubDir($tinyMceButtonsJSSubDir) {
		// set TinyMCE buttons JavaScript subdirectory inside the project directory
		$this->tinyMceButtonsJSDir = $this->projectDir.'/'.$tinyMceButtonsJSSubDir;
	}

	/**
	 * Get TinyMCE buttons JavaScript directory
	 *
	 * @access public
	 * @return string TinyMCE buttons JavaScript directory
	 */
	public function getTinyMceButtonsJSDir() {
		// get TinyMCE buttons JavaScript directory
		return $this->tinyMceButtonsJSDir;
	}

	/**
	 * Set TinyMCE buttons PHP subdirectory inside the project directory
	 *
	 * @access public
	 * @param string $tinyMceButtonsPHPSubDir TinyMCE buttons PHP subdirectory inside the project directory
	 * @return void
	 */
	public function setTinyMceButtonsPHPSubDir($tinyMceButtonsPHPSubDir) {
		// set TinyMCE buttons PHP subdirectory inside the project directory
		$this->tinyMceButtonsPHPDir = $this->projectDir.'/'.$tinyMceButtonsPHPSubDir;
	}

	/**
	 * Get TinyMCE buttons PHP directory
	 *
	 * @access public
	 * @return string TinyMCE buttons PHP directory
	 */
	public function getTinyMceButtonsPHPDir() {
		// get TinyMCE buttons PHP directory
		return $this->tinyMceButtonsPHPDir;
	}
}
