<?php

/**
 * add-thanks.class.php
 *
 * @author Dominik Kocuj <dominik@kocuj.pl>
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU General Public License v2 or later
 * @copyright Copyright (c) 2016 Dominik Kocuj
 * @package kocuj_internal_lib\kocuj_pl_lib
 */

// set namespace
namespace KocujPlLib\V2a\Classes\Project\Backend;

// security
if ((!defined('ABSPATH')) || ((isset($_SERVER['SCRIPT_FILENAME'])) && (basename($_SERVER['SCRIPT_FILENAME']) === basename(__FILE__)))) {
	header('HTTP/1.1 404 Not Found');
	die();
}

/**
 * Adding thanks class
 *
 * @access public
 */
class AddThanks extends \KocujInternalLib\V2a\Classes\ProjectObject {
	/**
	 * Adding thanks is set to be displayed (true) or adding thanks will not be displayed (false)
	 *
	 * @access private
	 * @var bool
	 */
	private $addThanksDisplay = false;

	/**
	 * Constructor
	 *
	 * @access public
	 * @param object $projectObj \KocujPlLib\V2a\Classes\Project object for current project
	 * @return void
	 */
	public function __construct($projectObj) {
		// execute parent constructor
		parent::__construct($projectObj);
		// add uninstall action
		add_action($this->getProjectObj()->getProjectKocujInternalLibObj()->getObj('project-helper')->getPrefix().'__plugin_uninstall', array($this, 'actionPluginUninstall'), 1);
		// check use permissions to display adding thanks
		if ((\KocujInternalLib\V2a\Classes\Helper::getInstance()->checkUserIPLocal()) || ((!current_user_can('manage_network_plugins')) && (!current_user_can('activate_plugins')) && (!current_user_can('install_plugins'))) || ($this->getThanksAddedOptionValue())) {
			return;
		}
		// add actions
		add_action('admin_footer', array($this, 'actionAdminFooter'), 1);
	}

	/**
	 * Set adding thanks to display (true) or not (false)
	 *
	 * @access public
	 * @param bool $addThanksDisplay Adding thanks will be displayed (true) or not (false)
	 * @return void
	 */
	public function setAddThanksDisplay($addThanksDisplay) {
		// set value
		$this->addThanksDisplay = $addThanksDisplay;
		// add "scripts
		if ($addThanksDisplay) {
			\KocujInternalLib\V2a\Classes\JsHelper::getInstance()->addHelperJS(true);
			\KocujInternalLib\V2a\Classes\JsHelper::getInstance()->addExceptionJS(true);
			\KocujInternalLib\V2a\Classes\JsHelper::getInstance()->addModalJS(true);
			if (\KocujInternalLib\V2a\Classes\JsHelper::getInstance()->getThrowErrors()) {
				\KocujInternalLib\V2a\Classes\JsHelper::getInstance()->addScript(\KocujPlLib\V2a\Classes\Helper::getInstance()->getPrefix().'-exception-code', \KocujPlLib\V2a\Classes\LibUrls::getInstance()->getJavaScriptUrl(), 'exception-code', array(), \KocujPlLib\V2a\Classes\Version::getInstance()->getVersion(), true);
				\KocujInternalLib\V2a\Classes\JsHelper::getInstance()->addScript(\KocujPlLib\V2a\Classes\Helper::getInstance()->getPrefix().'-exception', \KocujPlLib\V2a\Classes\LibUrls::getInstance()->getJavaScriptUrl(), 'exception', array(
					\KocujInternalLib\V2a\Classes\Helper::getInstance()->getPrefix().'-exception',
					\KocujPlLib\V2a\Classes\Helper::getInstance()->getPrefix().'-exception-code',
				), \KocujPlLib\V2a\Classes\Version::getInstance()->getVersion(), true);
			}
		}
	}

	/**
	 * Get thanks added option name
	 *
	 * @access public
	 * @return string Thanks added option name
	 */
	public function getThanksAddedOptionName() {
		// exit
		return $this->getProjectObj()->getProjectKocujInternalLibObj()->getSettingInternalName().'__thanks_added';
	}

	/**
	 * Get if thanks has been added (true) or not (false)
	 *
	 * @access public
	 * @return bool Thanks has been added (true) or not (false)
	 */
	public function getThanksAddedOptionValue() {
		// exit
		return (\KocujInternalLib\V2a\Classes\Helper::getInstance()->getOptionForNetworkOrSite($this->getThanksAddedOptionName()) === false) ?
			false :
			true;
	}

	/**
	 * Action for adding JavaScript scripts
	 *
	 * @access public
	 * @return void
	 */
	public function actionAdminFooter() {
		// add scripts
		if ($this->addThanksDisplay) {
			$deps = array(
				'jquery',
				\KocujInternalLib\V2a\Classes\Helper::getInstance()->getPrefix().'-helper',
				\KocujInternalLib\V2a\Classes\Helper::getInstance()->getPrefix().'-modal',
			);
			if (\KocujInternalLib\V2a\Classes\JsHelper::getInstance()->getThrowErrors()) {
				$deps[] = \KocujPlLib\V2a\Classes\Helper::getInstance()->getPrefix().'-exception';
			}
			\KocujInternalLib\V2a\Classes\JsHelper::getInstance()->addScript(\KocujPlLib\V2a\Classes\Helper::getInstance()->getPrefix().'-backend-add-thanks', \KocujPlLib\V2a\Classes\LibUrls::getInstance()->getJavaScriptUrl().'/backend', 'add-thanks', $deps, \KocujPlLib\V2a\Classes\Version::getInstance()->getVersion(), true, true, 'kocujPLV2aBackendAddThanksVals', array(
				'prefix'                 => \KocujPlLib\V2a\Classes\Helper::getInstance()->getPrefix(),
				'prefixKocujIL'          => \KocujInternalLib\V2a\Classes\Helper::getInstance()->getPrefix(),
				'security'               => wp_create_nonce(\KocujPlLib\V2a\Classes\Helper::getInstance()->getPrefix().'__add_thanks'),
				'useProxy'               => ((\KocujInternalLib\V2a\Classes\Helper::getInstance()->getUrlProtocol() !== 'http') && (ini_get('allow_url_fopen') === '1')) ?
					'1' :
					'0',
				'websiteUrl'             => get_home_url(),
				'websiteTitle'           => get_bloginfo('name', 'display'),
				'websiteDescription'     => get_bloginfo('description', 'display'),
				'textMoreInfoLink'       => $this->getProjectObj()->getStringsObj('backend_add-thanks')->getString('ACTION_ADMIN_FOOTER_SCRIPT_MORE_INFO_LINK'),
				'textWindowTitle'        => $this->getProjectObj()->getStringsObj('backend_add-thanks')->getString('ACTION_ADMIN_FOOTER_SCRIPT_WINDOW_TITLE'),
				'textWindowLoading'      => $this->getProjectObj()->getStringsObj('backend_add-thanks')->getString('ACTION_ADMIN_FOOTER_SCRIPT_WINDOW_LOADING'),
				'textWindowLoadingError' => $this->getProjectObj()->getStringsObj('backend_add-thanks')->getString('ACTION_ADMIN_FOOTER_SCRIPT_WINDOW_LOADING_ERROR'),
				'textSending'            => $this->getProjectObj()->getStringsObj('backend_add-thanks')->getString('ACTION_ADMIN_FOOTER_SCRIPT_SENDING'),
				'textError'              => $this->getProjectObj()->getStringsObj('backend_add-thanks')->getString('ACTION_ADMIN_FOOTER_SCRIPT_ERROR'),
				'textErrorNoRetries'     => $this->getProjectObj()->getStringsObj('backend_add-thanks')->getString('ACTION_ADMIN_FOOTER_SCRIPT_ERROR_NO_RETRIES'),
				'textErrorAlreadyExists' => $this->getProjectObj()->getStringsObj('backend_add-thanks')->getString('ACTION_ADMIN_FOOTER_SCRIPT_ERROR_ALREADY_EXISTS'),
				'textErrorWrongResponse' => $this->getProjectObj()->getStringsObj('backend_add-thanks')->getString('ACTION_ADMIN_FOOTER_SCRIPT_ERROR_WRONG_RESPONSE'),
				'textSuccess'            => $this->getProjectObj()->getStringsObj('backend_add-thanks')->getString('ACTION_ADMIN_FOOTER_SCRIPT_SUCCESS'),
				'imageLoadingUrl'        => \KocujPlLib\V2a\Classes\LibUrls::getInstance()->getImagesUrl().'/loading.gif',
			), true);
		}
	}

	/**
	 * Action for uninstall plugin
	 *
	 * @access public
	 * @return void
	 */
	public function actionPluginUninstall() {
		// remove option
		\KocujInternalLib\V2a\Classes\Helper::getInstance()->deleteOptionForNetworkOrSite($this->getThanksAddedOptionName());
	}
}
