<?php

/**
 * pages.class.php
 *
 * @author Dominik Kocuj <dominik@kocuj.pl>
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU General Public License v2 or later
 * @copyright Copyright (c) 2013-2016 Dominik Kocuj
 * @package kocuj_sitemap
 */

// set namespace
namespace KocujSitemapPlugin\Classes\ElementType\Backend;

// security
if ((!defined('ABSPATH')) || ((isset($_SERVER['SCRIPT_FILENAME'])) && (basename($_SERVER['SCRIPT_FILENAME']) === basename(__FILE__)))) {
	header('HTTP/1.1 404 Not Found');
	die();
}

/**
 * Pages type administration panel class
 *
 * @access public
 */
class Pages implements \KocujSitemapPlugin\Interfaces\ElementTypeBackend {
	/**
	 * Add pages by reccurence
	 *
	 * @access private
	 * @param int $parentId Page parent id
	 * @param string $locale Language locale - default: empty
	 * @return array Output array
	 */
	private function addReccurence($parentId, $locale = '') {
		// initialize
		$array = array();
		// get pages
		$value = \KocujSitemapPlugin\Classes\Base::getInstance()->getKocujInternalLibObj()->getObj('config')->getOption('DisplayPagesSort');
		$sortColumn = 'menu_order';
		if ((isset($value[0]) /* strlen($value) > 0 */ ) && ($value !== 'default')) {
			switch ($value) {
				case 'title';
					$sortColumn = 'post_title';
				break;
				case 'id';
					$sortColumn = 'ID';
				break;
				case 'date';
					$sortColumn = 'post_date';
				break;
				case 'moddate';
					$sortColumn = 'post_modified';
				break;
			}
		}
		$value = \KocujSitemapPlugin\Classes\Base::getInstance()->getKocujInternalLibObj()->getObj('config')->getOption('DisplayPagesOrder');
		$sortOrder = 'ASC';
		if (isset($value[0]) /* strlen($value) > 0 */ ) {
			switch ($value) {
				case 'desc':
					$sortOrder = 'DESC';
				break;
			}
		}
		\KocujSitemapPlugin\Classes\MultipleLanguages::getInstance()->beforeGetPages($locale);
		$pages = get_pages(array(
			'parent'       => $parentId,
			'sort_column'  => $sortColumn,
			'sort_order'   => $sortOrder,
			'post_type'    => 'page',
			'post_status'  => 'publish',
			'hierarchical' => 0,
			'offset'       => 0,
			'number'       => '',
		));
		\KocujSitemapPlugin\Classes\MultipleLanguages::getInstance()->afterGetPages($locale);
		if (!empty($pages)) {
			foreach ($pages as $page) {
				\KocujSitemapPlugin\Classes\MultipleLanguages::getInstance()->beforeGetPageItem($page->ID, $locale);
				$linkText = apply_filters('kocujsitemap_linktitle', apply_filters('the_title', \KocujSitemapPlugin\Classes\MultipleLanguages::getInstance()->getTranslatedPageTitle($page->post_title, $page->ID, $locale), $page->ID), $page->ID, 'page', $locale); // for compatibility with 1.x.x
				\KocujSitemapPlugin\Classes\Base::getInstance()->filterOldInfo('kocujsitemap_linktitle', 'kocujsitemap_link_text'); // for compatibility with 1.x.x
				$linkText = apply_filters('kocujsitemap_link_text', $linkText, $page->ID, 'page', $locale);
				if (!isset($linkText[0]) /* strlen($linkText) === 0 */ ) {
					$linkText = '-';
				}
				$link = apply_filters('kocujsitemap_element', \KocujInternalLib\V2a\Classes\HtmlHelper::getInstance()->getLinkAnchor(\KocujSitemapPlugin\Classes\Helpers\Url::getInstance()->removeProtocolLocal(\KocujSitemapPlugin\Classes\MultipleLanguages::getInstance()->getTranslatedPageURL(get_permalink($page->ID), $page->ID, $locale)), $linkText), $page->ID, 'page', $locale);
				$pos = count($array);
				$arrayAdd = array(
					'id' => $page->ID,
					'tp' => 'page',
					'lk' => $link,
				);
				if ($sortColumn === 'post_title') {
					$arrayAdd['sortname'] = $linkText;
				}
				$array[$pos] = $arrayAdd;
				\KocujSitemapPlugin\Classes\MultipleLanguages::getInstance()->afterGetPageItem($page->ID, $locale);
				$array[$pos]['ch'] = $this->addReccurence($page->ID, $locale);
				if (empty($array[$pos]['ch'])) {
					unset($array[$pos]['ch']);
				}
			}
			if ($sortColumn === 'post_title') {
				$array = \KocujSitemapPlugin\Classes\Helpers\Sort::getInstance()->sortElements($array, $sortOrder);
			}
		}
		// exit
		return $array;
	}

	/**
	 * Add page to sitemap
	 *
	 * @access public
	 * @param string $locale Language locale - default: empty
	 * @return array Output array
	 */
	public function getElementArray($locale = '') {
		// initialize
		$array = array();
		// add pages to sitemap
		$value = \KocujSitemapPlugin\Classes\Base::getInstance()->getKocujInternalLibObj()->getObj('config')->getOption('DisplayPages');
		if ($value) {
			$array = $this->addReccurence(0, $locale);
		}
		// exit
		return $array;
	}

	/**
	 * Get administration page settings
	 *
	 * @access public
	 * @return array Administration page settings
	 */
	public function getAdminPageSettings() {
		// get administration page settings
		return array(
			'title' => __('Pages list options', 'kocuj-sitemap'),
			'id'    => 'pages_options',
			'tabs'  => array(
				'pages_displaying' => __('Displaying pages', 'kocuj-sitemap'),
				'pages_options'    => __('Options', 'kocuj-sitemap'),
			),
			'help'  => array(
				'overview' => array(
					'title'   => __('Overview', 'kocuj-sitemap'),
					'content' =>
						__('This is the place where you can enable or disable displaying of pages in the sitemap. Here you can also change how they will be displayed.', 'kocuj-sitemap').'</p>'.
						'<p>'.__('Options are divided into three tabs: `displaying pages`, `options` and `section title`. Each tab can be selected by clicking on it.', 'kocuj-sitemap').'</p>'.
						'<p>'.__('To save changed settings, click on the button `save pages list options`.', 'kocuj-sitemap'),
				),
				'displaying_pages' => array(
					'title'   => __('`Displaying pages` tab', 'kocuj-sitemap'),
					'content' =>
						__('There are the following options in this tab:', 'kocuj-sitemap').'</p>'.
						'<p><ul>'.
						'<li><em>`'.__('Display pages', 'kocuj-sitemap').'`</em>: '.__('If this option is activated, there will be pages list displayed in the sitemap.', 'kocuj-sitemap').'</li>'.
						'</ul>',
				),
				'options' => array(
					'title'   => __('`Options` tab', 'kocuj-sitemap'),
					'content' =>
						__('There are the following options in this tab:', 'kocuj-sitemap').'</p>'.
						'<p><ul>'.
						'<li><em>`'.__('Sort pages by', 'kocuj-sitemap').'`</em>: '.__('You can sort pages in the sitemap using the selected pages properties. There are the following pages properties to select:', 'kocuj-sitemap').
						'<ul>'.
						'<li><em>`'.__('default', 'kocuj-sitemap').'`</em>: '.__('Pages will be sorted by default order.', 'kocuj-sitemap').'</li>'.
						'<li><em>`'.__('created date', 'kocuj-sitemap').'`</em>: '.__('Pages will be sorted by created date.', 'kocuj-sitemap').'</li>'.
						'<li><em>`'.__('last modification date', 'kocuj-sitemap').'`</em>: '.__('Pages will be sorted by last modification date.', 'kocuj-sitemap').'</li>'.
						'<li><em>`'.__('title', 'kocuj-sitemap').'`</em>: '.__('Pages will be sorted by title.', 'kocuj-sitemap').'</li>'.
						'<li><em>`'.__('ID', 'kocuj-sitemap').'`</em>: '.__('Pages will be sorted by post identifier.', 'kocuj-sitemap').'</li>'.
						'</ul>'.
						'</li>'.
						'<li><em>`'.__('Sort pages order', 'kocuj-sitemap').'`</em>: '.__('You can sort pages by ascending or descending order. It works only if option `sort pages by` is not set to `default`.', 'kocuj-sitemap').'</li>'.
						'</ul>',
				),
				'section_title' => array(
					'title'   => __('`Section title` tab', 'kocuj-sitemap'),
					'content' =>
						__('In this tab you can set the title of the section with pages. It is used if option `divide display into sections` in the main settings of the Kocuj Sitemap plugin is activated.', 'kocuj-sitemap').'</p>'.
						'<p>'.__('There are fields to enter the section title for each language that is available in your WordPress installation. If you have not activated any of the supported plugins for multilingualism, there will be visible only two fields to enter the title - for current WordPress language and for default section title in English language.', 'kocuj-sitemap').'</p>'.
						'<p>'.__('It is not necessary to enter section titles here. However, the place is here in order to be able to display the title of the section in your chosen language if there is no translation for it. If you leave this empty and if you will not have a translation of section title for current language and for default language (English language), there will be displayed the standard section title in English language.', 'kocuj-sitemap'),
				),
			),
		);
	}

	/**
	 * Get administration page data
	 *
	 * @access public
	 * @return array Administration page data
	 */
	public function getAdminPageData() {
		// get administration page data
		$sortArray = array(
			'default' => __('default', 'kocuj-sitemap'),
			'date'    => __('created date', 'kocuj-sitemap'),
			'moddate' => __('last modification date', 'kocuj-sitemap'),
			'title'   => __('title', 'kocuj-sitemap'),
			'id'      => __('ID', 'kocuj-sitemap'),
		);
		$sortByArray = array(
			'asc'  => __('ascending', 'kocuj-sitemap'),
			'desc' => __('descending', 'kocuj-sitemap'),
		);
		// exit
		return array(
			'pages'   => array(
				\KocujSitemapPlugin\Classes\Base::getInstance()->getKocujInternalLibObj()->getObj('admin')->getBlockHelper('DisplayPages', 'checkbox', __('If this option is activated, there will be pages list displayed in the sitemap.', 'kocuj-sitemap')),
				\KocujSitemapPlugin\Classes\Base::getInstance()->getKocujInternalLibObj()->getObj('admin')->getBlockHelper('DisplayPagesSort', 'select', __('You can sort pages in the sitemap using the selected pages properties.', 'kocuj-sitemap'), $sortArray).
					\KocujSitemapPlugin\Classes\Base::getInstance()->getKocujInternalLibObj()->getObj('admin')->getBlockHelper('DisplayPagesOrder', 'select', __('You can sort pages by ascending or descending order.', 'kocuj-sitemap'), $sortByArray, __('(works only if option `sort pages by` is not set to `default`)', 'kocuj-sitemap')),
			),
			'submit'  => array(
				'title' => __('Save pages list options', 'kocuj-sitemap'),
				'info'  => __('Save current pages list options', 'kocuj-sitemap'),
			),
			'buttons' => '',
		);
	}

	/**
	 * Get administration panel order name
	 *
	 * @access public
	 * @return string Administration panel order name
	 */
	public function getAdminOrderName() {
		// get administration panel order name
		return __('Pages', 'kocuj-sitemap');
	}

	/**
	 * Get administration cache actions
	 *
	 * @access public
	 * @return array Administration cache actions
	 */
	public function getAdminCacheActions() {
		// get administration cache actions
		return array(
			'wp_insert_post',
			'post_updated',
			'after_delete_post',
		);
	}

	/**
	 * Get administration cache filters
	 *
	 * @access public
	 * @return array Administration cache filters
	 */
	public function getAdminCacheFilters() {
		// get administration cache filters
		return array();
	}
}
