<?php

/**
 * current-screen-id.class.php
 *
 * @author Dominik Kocuj <dominik@kocuj.pl>
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU General Public License v2 or later
 * @copyright Copyright (c) 2016 Dominik Kocuj
 * @package kocuj_internal_lib
 */

// set namespace
namespace KocujInternalLib\V2a\Classes\Project\Backend;

// security
if ((!defined('ABSPATH')) || ((isset($_SERVER['SCRIPT_FILENAME'])) && (basename($_SERVER['SCRIPT_FILENAME']) === basename(__FILE__)))) {
	header('HTTP/1.1 404 Not Found');
	die();
}

/**
 * Set current screen identifier class
 *
 * @access public
 */
class CurrentScreenId extends \KocujInternalLib\V2a\Classes\ProjectObject {
	/**
	 * Callback for parameter "page"
	 *
	 * @access private
	 * @param string $value Value of parameter "page"
	 * @return string Parsed value of parameter "page"
	 */
	private function callbackParameterPage($value) {
		// exit
		return (isset($value[0]) /* strlen($value) > 0 */ ) ?
			'menu_page_'.$value :
			'admin';
	}

	/**
	 * Callback for parameter "post_type"
	 *
	 * @access private
	 * @param string $value Value of parameter "post_type"
	 * @param int $postValue Value of parameter "post"
	 * @return string Parsed value of parameter "post_type"
	 */
	private function callbackParameterPostType($value, $postValue) {
		// exit
		return (isset($value[0]) /* strlen($value) > 0 */ ) ?
			$value :
			get_post_type($postValue);
	}

	/**
	 * Callback for parameter "taxonomy"
	 *
	 * @access private
	 * @param string $value Value of parameter "taxonomy"
	 * @return string Parsed value of parameter "taxonomy"
	 */
	private function callbackParameterTaxonomy($value) {
		// exit
		return $value;
	}

	/**
	 * Get current screen identifier; it can do it even if function "get_current_screen" returns NULL
	 *
	 * @access public
	 * @return array Current screen identifier or empty string if function "get_current_screen" returns NULL (in element "original") and alternative screen identifier which is almost always available (in element "alternative") or empty array if it is not an administration panel
	 */
	public function get() {
		// check if it is administration panel
		if ((!is_admin()) && (!is_network_admin())) {
			return array();
		}
		// set data for screen identifier
		$parsCallbacks = array(
			'page'      => array(
				'callback'             => array($this, 'callbackParameterPage'),
				'additionalparameters' => array(),
			),
			'post_type' => array(
				'callback'             => array($this, 'callbackParameterPostType'),
				'additionalparameters' => array(
					'post',
				),
			),
			'taxonomy'  => array(
				'callback'             => array($this, 'callbackParameterTaxonomy'),
				'additionalparameters' => array(),
			),
		);
		$ids = array(
			'edit.php'            => 'edit-{post_type}',
			'post-new.php'        => '{post_type}',
			'post.php'            => '{post_type}',
			'edit-tags.php'       => 'edit-{taxonomy}',
			'media-new.php'       => 'media',
			'themes.php'          => 'appearance_page_{page}',
			'admin.php'           => '{page}',
			'options-general.php' => 'settings_page_{page}',
			'link-add.php'        => 'link',
			'link.php'            => 'link',
			'index.php'           => 'dashboard',
		);
		if (is_network_admin()) {
			$ids = array_merge($ids, array(
				'users.php'   => 'users-network',
				'plugins.php' => 'plugins-network',
				'sites.php'   => 'sites-network',
				'themes.php'  => 'themes-network',
			));
		}
		// get script name
		$div = explode('/', \KocujInternalLib\V2a\Classes\Helper::getInstance()->getScriptUrl());
		$scriptName = $div[count($div)-1];
		// get screen identifier
		if (isset($ids[$scriptName])) {
			// get identifier
			$id = $ids[$scriptName];
			// parse parameters
			foreach ($parsCallbacks as $parameter => $data) {
				if (strpos($id, '{'.$parameter.'}') !== false) {
					// get parameters values
					$parsNames = array_merge(array(
						$parameter,
					), $data['additionalparameters']);
					$parsValues = array();
					foreach ($parsNames as $name) {
						if (isset($_GET[$name])) {
							$parsValues[] = $_GET[$name];
						} else {
							$parsValues[] = '';
						}
					}
					// replace tag
					$id = str_replace('{'.$parameter.'}', call_user_func_array($data['callback'], $parsValues), $id);
				}
			}
		} else {
			// get identifier based on script name
			$div = explode('.', $scriptName);
			$id = $div[count($div)-1];
		}
		// get original screen identifier
		$screen = (function_exists('get_current_screen')) ?
			get_current_screen() :
			NULL;
		if (!empty($screen)) {
			$originalId = $screen->id;
		} else {
			$originalId = '';
		}
		// exit
		return array(
			'original'    => $originalId,
			'alternative' => $id,
		);
	}
}
