<?php

/**
 * installation-date.class.php
 *
 * @author Dominik Kocuj <dominik@kocuj.pl>
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU General Public License v2 or later
 * @copyright Copyright (c) 2016 Dominik Kocuj
 * @package kocuj_internal_lib
 */

// set namespace
namespace KocujInternalLib\V2a\Classes\Project\Backend;

// security
if ((!defined('ABSPATH')) || ((isset($_SERVER['SCRIPT_FILENAME'])) && (basename($_SERVER['SCRIPT_FILENAME']) === basename(__FILE__)))) {
	header('HTTP/1.1 404 Not Found');
	die();
}

/**
 * Set installation date class
 *
 * @access public
 */
class InstallationDate extends \KocujInternalLib\V2a\Classes\ProjectObject {
	/**
	 * Constructor
	 *
	 * @access public
	 * @param object $projectObj \KocujInternalLib\V2a\Classes\Project object for current project
	 * @return void
	 */
	public function __construct($projectObj) {
		// execute parent constructor
		parent::__construct($projectObj);
		// add uninstall action
		add_action($this->getProjectObj()->getObj('project-helper')->getPrefix().'__plugin_uninstall', array($this, 'actionPluginUninstall'), 1);
		// check if it is backend
		if ((!is_admin()) && (!is_network_admin())) {
			return;
		}
		// optionally create installation date
		$value = $this->getInstallationDateOptionValue();
		if ($value === false) {
			\KocujInternalLib\V2a\Classes\Helper::getInstance()->addOrUpdateOptionForNetworkOrSite($this->getInstallationDateOptionName(), date('Y-m-d'));
		}
	}

	/**
	 * Get installation date option name
	 *
	 * @access public
	 * @return string Installation date option name
	 */
	public function getInstallationDateOptionName() {
		// exit
		return $this->getProjectObj()->getSettingInternalName().'__installation_date';
	}

	/**
	 * Get installation date from database
	 *
	 * @access public
	 * @return string Installation date from database
	 */
	public function getInstallationDateOptionValue() {
		// exit
		return \KocujInternalLib\V2a\Classes\Helper::getInstance()->getOptionForNetworkOrSite($this->getInstallationDateOptionName());
	}

	/**
	 * Action for uninstall plugin
	 *
	 * @access public
	 * @return void
	 */
	public function actionPluginUninstall() {
		// remove option
		\KocujInternalLib\V2a\Classes\Helper::getInstance()->deleteOptionForNetworkOrSite($this->getInstallationDateOptionName());
	}
}
