<?php

/**
 * plugin-uninstall.class.php
 *
 * @author Dominik Kocuj <dominik@kocuj.pl>
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU General Public License v2 or later
 * @copyright Copyright (c) 2016 Dominik Kocuj
 * @package kocuj_internal_lib
 */

// set namespace
namespace KocujInternalLib\V2a\Classes\Project;

// security
if ((!defined('ABSPATH')) || ((isset($_SERVER['SCRIPT_FILENAME'])) && (basename($_SERVER['SCRIPT_FILENAME']) === basename(__FILE__)))) {
	header('HTTP/1.1 404 Not Found');
	die();
}

/**
 * Plugin uninstallation class
 *
 * @access public
 */
class PluginUninstall extends \KocujInternalLib\V2a\Classes\ProjectObject {
	/**
	 * Constructor; creating an object will automatically uninstall the plugin; it should be executed in file "uninstall.php" in plugin directory
	 *
	 * @access public
	 * @param object $projectObj \KocujInternalLib\V2a\Classes\Project object for current project
	 * @return void
	 */
	public function __construct($projectObj) {
		// execute parent constructor
		parent::__construct($projectObj);
		// check if it is uninstallation of plugin
		if (!defined('WP_UNINSTALL_PLUGIN')) {
			header('HTTP/1.1 404 Not Found');
			die();
		}
		// check if it is plugin
		$type = $this->getProjectObj()->getSettingType();
		if ($type !== \KocujInternalLib\V2a\Enums\ProjectType::PLUGIN) {
			return;
		}
		// remove administration data from database
		$this->getProjectObj()->getObj('project-helper')->doAction('plugin_uninstall');
		$this->getProjectObj()->getObj('config')->uninstallOptions();
		if (is_multisite()) {
			global $wpdb;
			$ids = $wpdb->get_col('SELECT blog_id FROM '.$wpdb->blogs);
			if (!empty($ids)) {
				$currentId = get_current_blog_id();
				foreach ($ids as $id) {
					if ($id !== $currentId) {
						switch_to_blog($id);
						$this->getProjectObj()->getObj('config')->uninstallOptions(true);
						restore_current_blog();
					}
				}
			}
		}
	}
}
