<?php

/**
 * add-thanks-ajax.class.php
 *
 * @author Dominik Kocuj <dominik@kocuj.pl>
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU General Public License v2 or later
 * @copyright Copyright (c) 2016 Dominik Kocuj
 * @package kocuj_internal_lib\kocuj_pl_lib
 */

// set namespace
namespace KocujPlLib\V2a\Classes\Project\Backend;

// security
if ((!defined('ABSPATH')) || ((isset($_SERVER['SCRIPT_FILENAME'])) && (basename($_SERVER['SCRIPT_FILENAME']) === basename(__FILE__)))) {
	header('HTTP/1.1 404 Not Found');
	die();
}

/**
 * Set adding thanks AJAX class
 *
 * @access public
 */
class AddThanksAjax extends \KocujInternalLib\V2a\Classes\ProjectObject {
	/**
	 * Constructor
	 *
	 * @access public
	 * @param object $projectObj \KocujPlLib\V2a\Classes\Project object for current project
	 * @return void
	 */
	public function __construct($projectObj) {
		// execute parent constructor
		parent::__construct($projectObj);
		// check use permissions to display adding thanks
		if ((\KocujInternalLib\V2a\Classes\Helper::getInstance()->checkUserIPLocal()) || ((!current_user_can('manage_network_plugins')) && (!current_user_can('activate_plugins')) && (!current_user_can('install_plugins')))) {
			return;
		}
		// add actions
		add_action('wp_ajax_'.$this->getProjectObj()->getObj('project-helper')->getPrefix().'__add_thanks_proxy', array($this, 'actionAjaxProxy'));
		add_action('wp_ajax_'.$this->getProjectObj()->getObj('project-helper')->getPrefix().'__add_thanks_finished', array($this, 'actionAjaxFinished'));
		add_action('wp_ajax_'.$this->getProjectObj()->getObj('project-helper')->getPrefix().'__add_thanks_more_info_window_display', array($this, 'actionAjaxMoreInfoWindowDisplay'));
	}

	/**
	 * Action for proxy to Kocuj API
	 *
	 * @access public
	 * @return void
	 */
	public function actionAjaxProxy() {
		// check AJAX nonce
		check_ajax_referer(\KocujPlLib\V2a\Classes\Helper::getInstance()->getPrefix().'__add_thanks', 'security');
		// check if proxy is enabled
		if ((\KocujInternalLib\V2a\Classes\Helper::getInstance()->getUrlProtocol() === 'http') || (ini_get('allow_url_fopen') !== '1')) {
			wp_die();
		}
		// initialize
		$error = false;
		// get content
		$handle = @fopen($this->getProjectObj()->getApiUrl().'?'.
			'callback='.urlencode(\KocujPlLib\V2a\Classes\Helper::getInstance()->getPrefix()).'_callback&'.
			'requestType=parameters&'.
			'responseType=JSON&'.
			'requestMethod=GET&'.
			urlencode('data[PARAMETER_version]').'=1&'.
			urlencode('data[header][login]').'='.urlencode($this->getProjectObj()->getApiLogin()).'&'.
			urlencode('data[header][password]').'='.urlencode($this->getProjectObj()->getApiPassword()).'&'.
			urlencode('data[request][PARAMETER_command]').'=ADD_THANKS&'.
			urlencode('data[request][url]').'='.urlencode(get_home_url()).'&'.
			urlencode('data[request][title]').'='.urlencode(get_bloginfo('name', 'display')).'&'.
			urlencode('data[request][description]').'='.urlencode(get_bloginfo('description', 'display')).'&'.
			'_='.time(), 'r');
		if ($handle) {
			// load content
			$output = '';
			while (!feof($handle)) {
				$buffer = fgets($handle, 4096);
				if ($buffer !== false) {
					$output .= $buffer;
				} else {
					$error = true;
					break;
				}
			}
			if (!fclose($handle)) {
				$error = true;
			}
			// show output
			if (!$error) {
				header('Content-Type: application/json');
				echo $output;
			}
		} else {
			$error = true;
		}
		// handle errors
		if ($error) {
			header('HTTP/1.1 500 Internal Server Error');
		}
		// close connection
		wp_die();
	}

	/**
	 * Action for set that adding thanks has been finished
	 *
	 * @access public
	 * @return void
	 */
	public function actionAjaxFinished() {
		// check AJAX nonce
		check_ajax_referer(\KocujPlLib\V2a\Classes\Helper::getInstance()->getPrefix().'__add_thanks', 'security');
		// set that adding thanks has been finished
		\KocujInternalLib\V2a\Classes\Helper::getInstance()->addOrUpdateOptionForNetworkOrSite($this->getProjectObj()->getObj('backend_add-thanks')->getThanksAddedOptionName(), '1');
		// close connection
		wp_die();
	}

	/**
	 * Action for displaying more information about adding thanks in window
	 *
	 * @access public
	 * @return void
	 */
	public function actionAjaxMoreInfoWindowDisplay() {
		// check AJAX nonce
		check_ajax_referer(\KocujPlLib\V2a\Classes\Helper::getInstance()->getPrefix().'__add_thanks', 'security');
		// get list of websites where website address can be displayed
		$websites = array_merge(array(
			\KocujPlLib\V2a\Classes\Helper::getInstance()->getKocujPlUrl(false),
		), $this->getProjectObj()->getAdditionalWebsites());
		$websitesString = '';
		$loopCount = count($websites);
		for ($z=0; $z<$loopCount; $z++) {
			if ($z > 0) {
				$websitesString .= (($z < $loopCount-1) ?
					', ' :
					' '.$this->getProjectObj()->getStringsObj('backend_add-thanks-ajax')->getString('ACTION_AJAX_ADD_THANKS_MORE_INFO_WINDOW_DISPLAY_WEBSITES_AND').' ');
			}
			$websitesString .= '<strong>'.$websites[$z].'</strong>';
		}
		// show more information about adding thanks
		printf($this->getProjectObj()->getStringsObj('backend_add-thanks-ajax')->getString('ACTION_AJAX_ADD_THANKS_MORE_INFO_WINDOW_DISPLAY_MORE_1'), $websitesString);
		echo '<br /><br />';
		echo $this->getProjectObj()->getStringsObj('backend_add-thanks-ajax')->getString('ACTION_AJAX_ADD_THANKS_MORE_INFO_WINDOW_DISPLAY_MORE_2');
		echo '<br /><br />';
		echo $this->getProjectObj()->getStringsObj('backend_add-thanks-ajax')->getString('ACTION_AJAX_ADD_THANKS_MORE_INFO_WINDOW_DISPLAY_MORE_3');
		echo '<ul style="list-style:disc;margin-left:15px;">';
		echo '<li>';
		echo $this->getProjectObj()->getStringsObj('backend_add-thanks-ajax')->getString('ACTION_AJAX_ADD_THANKS_MORE_INFO_WINDOW_DISPLAY_MORE_4');
		echo '</li><li>';
		echo $this->getProjectObj()->getStringsObj('backend_add-thanks-ajax')->getString('ACTION_AJAX_ADD_THANKS_MORE_INFO_WINDOW_DISPLAY_MORE_5');
		echo '</li><li>';
		echo $this->getProjectObj()->getStringsObj('backend_add-thanks-ajax')->getString('ACTION_AJAX_ADD_THANKS_MORE_INFO_WINDOW_DISPLAY_MORE_6');
		echo '</li>';
		echo '</ul>';
		echo $this->getProjectObj()->getStringsObj('backend_add-thanks-ajax')->getString('ACTION_AJAX_ADD_THANKS_MORE_INFO_WINDOW_DISPLAY_MORE_7');
		echo '<br /><br />';
		echo $this->getProjectObj()->getStringsObj('backend_add-thanks-ajax')->getString('ACTION_AJAX_ADD_THANKS_MORE_INFO_WINDOW_DISPLAY_MORE_8');
		// close connection
		wp_die();
	}
}
