<?php

/**
 * page-about-add-thanks.class.php
 *
 * @author Dominik Kocuj <dominik@kocuj.pl>
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU General Public License v2 or later
 * @copyright Copyright (c) 2016 Dominik Kocuj
 * @package kocuj_internal_lib\kocuj_pl_lib
 */

// set namespace
namespace KocujPlLib\V2a\Classes\Project\Backend;

// security
if ((!defined('ABSPATH')) || ((isset($_SERVER['SCRIPT_FILENAME'])) && (basename($_SERVER['SCRIPT_FILENAME']) === basename(__FILE__)))) {
	header('HTTP/1.1 404 Not Found');
	die();
}

/**
 * Set adding thanks from page about class
 *
 * @access public
 */
class PageAboutAddThanks extends \KocujInternalLib\V2a\Classes\ProjectObject {
	/**
	 * Page about with adding thanks is set to be displayed (true) or page about with adding thanks will not be displayed (false)
	 *
	 * @access private
	 * @var bool
	 */
	private $pageAboutAddThanksDisplay = false;

	/**
	 * Constructor
	 *
	 * @access public
	 * @param object $projectObj \KocujPlLib\V2a\Classes\Project object for current project
	 * @return void
	 */
	public function __construct($projectObj) {
		// execute parent constructor
		parent::__construct($projectObj);
		// check use permissions to display adding thanks
		if ((\KocujInternalLib\V2a\Classes\Helper::getInstance()->checkUserIPLocal()) || ((!current_user_can('manage_network_plugins')) && (!current_user_can('activate_plugins')) && (!current_user_can('install_plugins')))) {
			return;
		}
		// add actions
		add_action($this->getProjectObj()->getProjectKocujInternalLibObj()->getObj('project-helper')->getPrefix().'__after_page_about', array($this, 'actionAfterPageAbout'));
		add_action('admin_print_footer_scripts', array($this, 'actionPrintFooterScripts'), \KocujInternalLib\V2a\Classes\Helper::getInstance()->calculateMaxPriority('admin_print_footer_scripts'));
	}

	/**
	 * Action for displaying adding thanks button in page about
	 *
	 * @access public
	 * @return void
	 */
	public function actionAfterPageAbout() {
		// show adding thanks
		echo '<div id="'.esc_attr($this->getProjectObj()->getObj('project-helper')->getPrefix().'__add_thanks_page_about_div').'">';
		echo '<hr />';
		echo '<br />';
		if ($this->getProjectObj()->getProjectKocujInternalLibObj()->getSettingType() === \KocujInternalLib\V2a\Enums\ProjectType::PLUGIN) {
			echo $this->getProjectObj()->getStringsObj('backend_page-about-add-thanks')->getString('ACTION_AFTER_PAGE_ABOUT_TEXT_PLUGIN');
		} else {
			echo $this->getProjectObj()->getStringsObj('backend_page-about-add-thanks')->getString('ACTION_AFTER_PAGE_ABOUT_TEXT_THEME');
		}
		echo ' ';
		printf($this->getProjectObj()->getStringsObj('backend_page-about-add-thanks')->getString('ACTION_AFTER_PAGE_ABOUT_TEXT'), \KocujInternalLib\V2a\Classes\HtmlHelper::getInstance()->getLinkAnchorBegin('#', array(
			'id' => $this->getProjectObj()->getObj('project-helper')->getPrefix().'__add_thanks_page_about_more_info_link',
		)), \KocujInternalLib\V2a\Classes\HtmlHelper::getInstance()->getLinkAnchorEnd());
		echo '<br /><br />';
		echo '<input type="button" class="button button-small" id="'.esc_attr($this->getProjectObj()->getObj('project-helper')->getPrefix().'__add_thanks_page_about_send').'" value="'.$this->getProjectObj()->getStringsObj('backend_page-about-add-thanks')->getString('ACTION_AFTER_PAGE_ABOUT_ADD_THANKS').'" />';
		echo '<br />';
		echo '<div id="'.esc_attr($this->getProjectObj()->getObj('project-helper')->getPrefix().'__add_thanks_page_about_status_div').'" style="display:none;">&nbsp;</div>';
		echo '<div id="'.esc_attr($this->getProjectObj()->getObj('project-helper')->getPrefix().'__add_thanks_page_about_loading_div').'" style="display:none;">';
		echo \KocujInternalLib\V2a\Classes\HtmlHelper::getInstance()->getHTMLImage(\KocujPlLib\V2a\Classes\LibUrls::getInstance()->getImagesUrl().'/loading.gif');
		echo '</div>';
		echo '</div>';
		// add scripts
		$this->getProjectObj()->getObj('backend_add-thanks')->setAddThanksDisplay(true);
		// set page about with adding thanks to be displayed
		$this->pageAboutAddThanksDisplay = true;
	}

	/**
	 * Action for scripts
	 *
	 * @access public
	 * @return void
	 */
	public function actionPrintFooterScripts() {
		// initialize page about script
		if ($this->pageAboutAddThanksDisplay) {
			?>
				<script type="text/javascript">
				/* <![CDATA[ */
					(function($) {
						$(document).ready(function() {
							kocujPLV2aBackendAddThanks.addProjectIfNotExists('<?php echo esc_js($this->getProjectObj()->getProjectKocujInternalLibObj()->getSettingInternalName()); ?>', '<?php echo esc_js($this->getProjectObj()->getApiUrl()); ?>', '<?php echo esc_js($this->getProjectObj()->getApiLogin()); ?>', '<?php echo esc_js($this->getProjectObj()->getApiPassword()); ?>');
							kocujPLV2aBackendAddThanks.setPageAboutAddThanks('<?php echo esc_js($this->getProjectObj()->getProjectKocujInternalLibObj()->getSettingInternalName()); ?>');
						});
					}(jQuery));
				/* ]]> */
				</script>
			<?php
		}
	}
}
