<?php

/**
 * review-message-add-thanks.class.php
 *
 * @author Dominik Kocuj <dominik@kocuj.pl>
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU General Public License v2 or later
 * @copyright Copyright (c) 2016 Dominik Kocuj
 * @package kocuj_internal_lib\kocuj_pl_lib
 */

// set namespace
namespace KocujPlLib\V2a\Classes\Project\Backend;

// security
if ((!defined('ABSPATH')) || ((isset($_SERVER['SCRIPT_FILENAME'])) && (basename($_SERVER['SCRIPT_FILENAME']) === basename(__FILE__)))) {
	header('HTTP/1.1 404 Not Found');
	die();
}

/**
 * Set adding thanks from review message class
 *
 * @access public
 */
class ReviewMessageAddThanks extends \KocujInternalLib\V2a\Classes\ProjectObject {
	/**
	 * Review message with adding thanks is set to be displayed (true) or review message with adding thanks will not be displayed (false)
	 *
	 * @access private
	 * @var bool
	 */
	private $reviewMessageAddThanksDisplay = false;

	/**
	 * Constructor
	 *
	 * @access public
	 * @param object $projectObj \KocujPlLib\V2a\Classes\Project object for current project
	 * @return void
	 */
	public function __construct($projectObj) {
		// execute parent constructor
		parent::__construct($projectObj);
		// check use permissions to display adding thanks
		if ((\KocujInternalLib\V2a\Classes\Helper::getInstance()->checkUserIPLocal()) || ((!current_user_can('manage_network_plugins')) && (!current_user_can('activate_plugins')) && (!current_user_can('install_plugins')))) {
			return;
		}
		// add filters
		add_filter('admin_head', array($this, 'adminHead'), \KocujInternalLib\V2a\Classes\Helper::getInstance()->calculateMaxPriority('admin_head'));
		add_filter($this->getProjectObj()->getProjectKocujInternalLibObj()->getObj('project-helper')->getPrefix().'__review_message_element_class', array($this, 'filterReviewMessageElementClass'));
		add_filter($this->getProjectObj()->getProjectKocujInternalLibObj()->getObj('project-helper')->getPrefix().'__review_message_elements_before', array($this, 'filterReviewMessageElementsBefore'));
		// add actions
		add_action('admin_print_footer_scripts', array($this, 'actionPrintFooterScripts'), \KocujInternalLib\V2a\Classes\Helper::getInstance()->calculateMaxPriority('admin_print_footer_scripts'));
	}

	/**
	 * Action for displaying CSS stylesheet
	 *
	 * @access public
	 * @return void
	 */
	public function adminHead() {
		?>
			<style type="text/css" media="all">
			<!--
				#<?php echo $this->getProjectObj()->getObj('project-helper')->getPrefix(); ?>__add_thanks_review_message_more_info_link_div {
					font-size: 12px;
				}

				.<?php echo $this->getProjectObj()->getObj('project-helper')->getPrefix(); ?>__add_thanks_review_message_element_div {
					height: 50px;
				}

				@media screen and (max-width: 782px) {
					#<?php echo $this->getProjectObj()->getObj('project-helper')->getPrefix(); ?>__add_thanks_review_message_more_info_link_div {
						font-size: 13px;
					}

					.<?php echo $this->getProjectObj()->getObj('project-helper')->getPrefix(); ?>__add_thanks_review_message_element_div {
						height: 75px;
					}
				}
			-->
			</style>
		<?php
	}

	/**
	 * Filter for element class in review message
	 *
	 * @access public
	 * @param string $class Class
	 * @return string Class
	 */
	public function filterReviewMessageElementClass($class) {
		// exit
		return $class.((isset($class[0]) /* strlen($class) > 0 */ ) ?
				' ' :
				''
			).$this->getProjectObj()->getObj('project-helper')->getPrefix().'__add_thanks_review_message_element_div';
	}

	/**
	 * Filter for elements before other elements in review message
	 *
	 * @access public
	 * @param array $elements Elements
	 * @return array Elements
	 */
	public function filterReviewMessageElementsBefore(array $elements) {
		// add element
		$elements[] = '<input type="button" class="button button-small" id="'.esc_attr($this->getProjectObj()->getObj('project-helper')->getPrefix().'__add_thanks_review_message_send').'" value="'.esc_attr($this->getProjectObj()->getStringsObj('backend_review-message-add-thanks')->getString('FILTER_REVIEW_MESSAGE_ELEMENTS_BEFORE_ADD_THANKS')).'" />'.
			'<br />'.
			'<div id="'.esc_attr($this->getProjectObj()->getObj('project-helper')->getPrefix().'__add_thanks_review_message_more_info_link_div').'">&nbsp;</div>';
		// add scripts
		$this->getProjectObj()->getObj('backend_add-thanks')->setAddThanksDisplay(true);
		// set review message with adding thanks to be displayed
		$this->reviewMessageAddThanksDisplay = true;
		// exit
		return $elements;
	}

	/**
	 * Action for scripts
	 *
	 * @access public
	 * @return void
	 */
	public function actionPrintFooterScripts() {
		// initialize review message script
		if ($this->reviewMessageAddThanksDisplay) {
			?>
				<script type="text/javascript">
				/* <![CDATA[ */
					(function($) {
						$(document).ready(function() {
							kocujPLV2aBackendAddThanks.addProjectIfNotExists('<?php echo esc_js($this->getProjectObj()->getProjectKocujInternalLibObj()->getSettingInternalName()); ?>', '<?php echo esc_js($this->getProjectObj()->getApiUrl()); ?>', '<?php echo esc_js($this->getProjectObj()->getApiLogin()); ?>', '<?php echo esc_js($this->getProjectObj()->getApiPassword()); ?>');
							kocujPLV2aBackendAddThanks.setReviewMessageAddThanks('<?php echo esc_js($this->getProjectObj()->getProjectKocujInternalLibObj()->getSettingInternalName()); ?>');
						});
					}(jQuery));
				/* ]]> */
				</script>
			<?php
		}
	}
}
