<?php

/**
 * backend-review-message-add-thanks.class.php
 *
 * @author Dominik Kocuj <dominik@kocuj.pl>
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU General Public License v2 or later
 * @copyright Copyright (c) 2013-2016 Dominik Kocuj
 * @package kocuj_sitemap
 */

// set namespace
namespace KocujSitemapPlugin\Classes\KocujPlLibStrings;

// security
if ((!defined('ABSPATH')) || ((isset($_SERVER['SCRIPT_FILENAME'])) && (basename($_SERVER['SCRIPT_FILENAME']) === basename(__FILE__)))) {
	header('HTTP/1.1 404 Not Found');
	die();
}

/**
 * \KocujPlLib\V2a\Classes\Backend\ReviewMessageAddThanks class strings
 *
 * @access public
 */
class BackendReviewMessageAddThanks implements \KocujInternalLib\V2a\Interfaces\Strings {
	/**
	 * Singleton instance
	 *
	 * @access private
	 * @var object
	 */
	private static $instance = NULL;

	/**
	 * Constructor
	 *
	 * @access private
	 * @return void
	 */
	private function __construct() {
	}

	/**
	 * Disable cloning of object
	 *
	 * @access private
	 * @return void
	 */
	private function __clone() {
	}

	/**
	 * Get singleton instance
	 *
	 * @access public
	 * @return object Singleton instance
	 */
	public static function getInstance() {
		// optionally create new instance
		if (!self::$instance) {
			self::$instance = new self();
		}
		// exit
		return self::$instance;
	}

	/**
	 * Get string
	 *
	 * @access public
	 * @param string $id String id
	 * @return string Output string
	 */
	public function getString($id) {
		// get string
		switch ($id) {
			case 'FILTER_REVIEW_MESSAGE_ELEMENTS_BEFORE_ADD_THANKS':
				return __('Send your website address to author', 'kocuj-sitemap');
			case 'FILTER_REVIEW_MESSAGE_ELEMENTS_BEFORE_SCRIPT_MORE_INFO_LINK':
				return __('see more information about this', 'kocuj-sitemap');
			case 'FILTER_REVIEW_MESSAGE_ELEMENTS_BEFORE_SCRIPT_WINDOW_TITLE':
				return __('More information about sending your website address', 'kocuj-sitemap');
			case 'FILTER_REVIEW_MESSAGE_ELEMENTS_BEFORE_SCRIPT_WINDOW_LOADING':
				return __('Loading, please wait...', 'kocuj-sitemap');
			case 'FILTER_REVIEW_MESSAGE_ELEMENTS_BEFORE_SCRIPT_WINDOW_LOADING_ERROR':
				return __('Loading error! Please, check your internet connection and refresh page to try again.', 'kocuj-sitemap');
		}
		// exit
		return '';
	}
}
