<?php

/**
 * widget.class.php
 *
 * @author Dominik Kocuj <dominik@kocuj.pl>
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU General Public License v2 or later
 * @copyright Copyright (c) 2013-2016 Dominik Kocuj
 * @package kocuj_sitemap
 */

// set namespace
namespace KocujSitemapPlugin\Classes;

// security
if ((!defined('ABSPATH')) || ((isset($_SERVER['SCRIPT_FILENAME'])) && (basename($_SERVER['SCRIPT_FILENAME']) === basename(__FILE__)))) {
	header('HTTP/1.1 404 Not Found');
	die();
}

/**
 * Widget plugin class
 *
 * @access public
 */
class Widget {
	/**
	 * Singleton instance
	 *
	 * @access private
	 * @var object
	 */
	private static $instance = NULL;

	/**
	 * Widget id - sitemap
	 *
	 * @access private
	 * @var int
	 */
	private $widgetSitemapId = 0;

	/**
	 * Excludes types
	 *
	 * @access private
	 * @var array
	 */
	private $excludes = array();

	/**
	 * Constructor
	 *
	 * @access private
	 * @return void
	 */
	private function __construct() {
		// add widget
		$id = Base::getInstance()->getKocujInternalLibObj()->getObj('config')->addWidgetOptionsContainer('kocujsitemap_widget_sitemap');
		Base::getInstance()->getKocujInternalLibObj()->getObj('config')->addOption('kocujsitemap_widget_sitemap_title', '', 'string', __('Title', 'kocuj-sitemap'), false, array(), true, $id);
		Base::getInstance()->getKocujInternalLibObj()->getObj('config')->addOption('kocujsitemap_widget_sitemap_displaytitle', '1', 'checkbox', __('Display title', 'kocuj-sitemap'), false, array(), true, $id);
		$labels = array();
		$excludes = Sitemap::getInstance()->getExcludeDefaults($labels, '', 'kocujsitemap_widget_default_exclude_');
		if (!empty($excludes)) {
			foreach ($excludes as $key => $val) {
				$this->excludes[$key] = $val;
				Base::getInstance()->getKocujInternalLibObj()->getObj('config')->addOption('kocujsitemap_widget_sitemap_exclude_'.$key, '', 'string', __('Exclude', 'kocuj-sitemap').' '.implode(', ', ((isset($labels[$key])) ?
						$labels[$key] :
						''
					)), false, array(), true, $id);
			}
		}
		wp_register_sidebar_widget('kocujsitemap_widget_sitemap', __('Sitemap', 'kocuj-sitemap'), array($this, 'widgetSitemap'), array(
			/* translators: %s: Name of this plugin ("Kocuj Sitemap") */
			'description' => sprintf(__('Sitemap generated by the %s plugin.', 'kocuj-sitemap'), 'Kocuj Sitemap'),
		));
		if ((is_admin()) || (is_network_admin())) {
			Base::getInstance()->getKocujInternalLibObj()->getObj('admin')->addWidgetSettings('kocujsitemap_widget_sitemap', __('Sitemap', 'kocuj-sitemap'), array($this, 'widgetControlSitemapShow'), array($this, 'widgetControlSitemapUpdate'));
		}
		$this->widgetSitemapId = $id;
	}

	/**
	 * Disable cloning of object
	 *
	 * @access private
	 * @return void
	 */
	private function __clone() {
	}

	/**
	 * Get singleton instance
	 *
	 * @access public
	 * @return object Singleton instance
	 */
	public static function getInstance() {
		// optionally create new instance
		if (!self::$instance) {
			self::$instance = new self();
		}
		// exit
		return self::$instance;
	}

	/**
	 * Widget - sitemap
	 *
	 * @access public
	 * @param array $args Arguments
	 * @return void
	 */
	public function widgetSitemap(array $args) {
		// get arguments
		$beforeWidget = (isset($args['before_widget'])) ?
			$args['before_widget'] :
			'';
		$afterWidget = (isset($args['after_widget'])) ?
			$args['after_widget'] :
			'';
		$beforeTitle = (isset($args['before_title'])) ?
			$args['before_title'] :
			'';
		$afterTitle = (isset($args['after_title'])) ?
			$args['after_title'] :
			'';
		// show before widget
		echo $beforeWidget;
		// optionally show title
		if (Base::getInstance()->getKocujInternalLibObj()->getObj('config')->getOption('kocujsitemap_widget_sitemap_displaytitle')) {
			$title = Base::getInstance()->getKocujInternalLibObj()->getObj('config')->getOption('kocujsitemap_widget_sitemap_title');
			echo $beforeTitle;
			if (isset($title[0]) /* strlen($title) > 0 */ ) {
				echo $title;
			} else {
				_e('Sitemap', 'kocuj-sitemap');
			}
			echo $afterTitle;
		}
		// show widget
		$exclude = array();
		if (!empty($this->excludes)) {
			foreach ($this->excludes as $key => $val) {
				$value = Base::getInstance()->getKocujInternalLibObj()->getObj('config')->getOption('kocujsitemap_widget_sitemap_exclude_'.$key);
				if (!isset($value[0]) /* strlen($value) === 0 */ ) {
					$value = $val;
				}
				$exclude[$key] = explode(',', $value);
			}
		}
		echo Sitemap::getInstance()->getDisplay('', 'kocujsitemapwidget', $exclude, true);
		// show after widget
		echo $afterWidget;
	}

	/**
	 * Widget control show - sitemap
	 *
	 * @access public
	 * @return void
	 */
	public function widgetControlSitemapShow() {
		// show form
		Base::getInstance()->getKocujInternalLibObj()->getObj('admin')->blockHelper('kocujsitemap_widget_sitemap_title', 'text', __('Title to display', 'kocuj-sitemap'));
		Base::getInstance()->getKocujInternalLibObj()->getObj('admin')->blockHelper('kocujsitemap_widget_sitemap_displaytitle', 'checkbox', __('Display title in top of widget', 'kocuj-sitemap'));
		if (!empty($this->excludes)) {
			Base::getInstance()->getKocujInternalLibObj()->getObj('admin')->blockHelper('', 'emptyline');
			Base::getInstance()->getKocujInternalLibObj()->getObj('admin')->blockHelper('', 'statictext', __('You can exclude some entries below by adding comma separated identifiers list.', 'kocuj-sitemap'));
			Base::getInstance()->getKocujInternalLibObj()->getObj('admin')->blockHelper('', 'emptyline');
			foreach ($this->excludes as $key => $val) {
				Base::getInstance()->getKocujInternalLibObj()->getObj('admin')->blockHelper('kocujsitemap_widget_sitemap_exclude_'.$key, 'text', __('Comma separated list of identifiers to exclude in the sitemap', 'kocuj-sitemap'));
			}
		}
	}

	/**
	 * Widget control update - sitemap
	 *
	 * @access public
	 * @return void
	 */
	public function widgetControlSitemapUpdate() {
		// update options
		Base::getInstance()->getKocujInternalLibObj()->getObj('config')->updateOptions(true, $this->widgetSitemapId);
	}
}
