<?php

/**
 * config.class.php
 *
 * @author Dominik Kocuj <dominik@kocuj.pl>
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU General Public License v2 or later
 * @copyright Copyright (c) 2013-2016 Dominik Kocuj
 * @package kocuj_sitemap
 */

// set namespace
namespace KocujSitemapPlugin\Classes\KocujInternalLibStrings\All;

// security
if ((!defined('ABSPATH')) || ((isset($_SERVER['SCRIPT_FILENAME'])) && (basename($_SERVER['SCRIPT_FILENAME']) === basename(__FILE__)))) {
	header('HTTP/1.1 404 Not Found');
	die();
}

/**
 * \KocujInternalLib\V3a\Classes\Project\Components\All\Config classes strings
 *
 * @access public
 */
class Config implements \KocujInternalLib\V3a\Interfaces\Strings {
	/**
	 * Singleton instance
	 *
	 * @access private
	 * @var object
	 */
	private static $instance = NULL;

	/**
	 * Constructor
	 *
	 * @access private
	 * @return void
	 */
	private function __construct() {
	}

	/**
	 * Disable cloning of object
	 *
	 * @access private
	 * @return void
	 */
	private function __clone() {
	}

	/**
	 * Get singleton instance
	 *
	 * @access public
	 * @return object Singleton instance
	 */
	public static function getInstance() {
		// optionally create new instance
		if (!self::$instance) {
			self::$instance = new self();
		}
		// exit
		return self::$instance;
	}

	/**
	 * Get string
	 *
	 * @access public
	 * @param string $id String id
	 * @return string Output string
	 */
	public function getString($id) {
		// get string
		switch ($id) {
			case 'TYPE_CHECKBOX_ON_OFF':
				return __('should be on or off', 'kocuj-sitemap');
			case 'TYPE_NUMERIC_NUMERIC':
				return __('should be numeric', 'kocuj-sitemap');
			case 'TYPE_NUMERIC_PLUS_SMALLER_THAN_ZERO':
				return __('should be bigger or equal to zero', 'kocuj-sitemap');
			case 'TYPE_NUMERIC_MINUS_BIGGER_THAN_ZERO':
				return __('should be smaller or equal to zero', 'kocuj-sitemap');
			case 'TYPE_POST_NUMERIC_EXIST':
				return __('must be numeric and should be already existing post', 'kocuj-sitemap');
			case 'TYPE_PAGE_NUMERIC_EXIST':
				return __('must be numeric and should be already existing page', 'kocuj-sitemap');
			case 'TYPE_DATE_FORMAT':
				return __('must be in format "yy-mm-dd"', 'kocuj-sitemap');
			case 'TYPE_TIME_FORMAT':
				return __('must be in format "hh:ii"', 'kocuj-sitemap');
			case 'TYPE_DATETIME_FORMAT':
				return __('must be in format "yy-mm-dd hh:ii"', 'kocuj-sitemap');
		}
		// exit
		return '';
	}
}
