<?php

/**
 * init.class.php
 *
 * @author Dominik Kocuj <dominik@kocuj.pl>
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU General Public License v2 or later
 * @copyright Copyright (c) 2016 Dominik Kocuj
 * @package kocuj_internal_lib
 */

// set namespace
namespace KocujInternalLib\V3a\Classes\Project\Components\Backend\EditorVisualButtons;

// security
if ((!defined('ABSPATH')) || ((isset($_SERVER['SCRIPT_FILENAME'])) && (basename($_SERVER['SCRIPT_FILENAME']) === basename(__FILE__)))) {
	header('HTTP/1.1 404 Not Found');
	die();
}

/**
 * Visual editor buttons (component initialization) class
 *
 * @access public
 */
class Init extends \KocujInternalLib\V3a\Classes\ComponentInitObject {
	/**
	 * Constructor
	 *
	 * @access public
	 * @param object $projectObj \KocujInternalLib\V3a\Classes\Project object for current project
	 * @return void
	 */
	public function __construct($projectObj) {
		// execute parent
		parent::__construct($projectObj);
		// add filters
		$this->getProjectObj()->getComponent('core', 'actions-filters-helper')->addFilterWhenNeeded('mce_external_plugins', 'backend', 'editor-visual-buttons', '', 'filterMceExternalPlugins', \KocujInternalLib\V3a\Classes\Helper::getInstance()->calculateMaxPriority('mce_external_plugins'));
		$this->getProjectObj()->getComponent('core', 'actions-filters-helper')->addFilterWhenNeeded('mce_external_languages', 'backend', 'editor-visual-buttons', '', 'filterMceExternalLanguages', \KocujInternalLib\V3a\Classes\Helper::getInstance()->calculateMaxPriority('mce_external_languages'));
		$this->getProjectObj()->getComponent('core', 'actions-filters-helper')->addFilterWhenNeeded('mce_buttons', 'backend', 'editor-visual-buttons', '', 'filterMceButtons', \KocujInternalLib\V3a\Classes\Helper::getInstance()->calculateMaxPriority('mce_buttons'));
	}
}
