<?php

/**
 * init.class.php
 *
 * @author Dominik Kocuj <dominik@kocuj.pl>
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU General Public License v2 or later
 * @copyright Copyright (c) 2016 Dominik Kocuj
 * @package kocuj_internal_lib
 */

// set namespace
namespace KocujInternalLib\V3a\Classes\Project\Components\Backend\InstallationDate;

// security
if ((!defined('ABSPATH')) || ((isset($_SERVER['SCRIPT_FILENAME'])) && (basename($_SERVER['SCRIPT_FILENAME']) === basename(__FILE__)))) {
	header('HTTP/1.1 404 Not Found');
	die();
}

/**
 * Installation date (component initialization) class
 *
 * @access public
 */
class Init extends \KocujInternalLib\V3a\Classes\ComponentInitObject {
	/**
	 * Constructor
	 *
	 * @access public
	 * @param object $projectObj \KocujInternalLib\V3a\Classes\Project object for current project
	 * @return void
	 */
	public function __construct($projectObj) {
		// execute parent
		parent::__construct($projectObj);
		// add uninstall action
		$this->getProjectObj()->getComponent('core', 'actions-filters-helper')->addActionWhenNeeded($this->getProjectObj()->getComponent('core', 'project-helper')->getPrefix().'__plugin_uninstall', 'backend', 'installation-date', '', 'actionPluginUninstall', 1);
		// optionally create installation date
		$value = $this->getProjectObj()->getComponent('backend', 'installation-date')->getInstallationDateOptionValue();
		if ($value === false) {
			$this->getProjectObj()->getComponent('core', 'meta')->addOrUpdateOption($this->getProjectObj()->getComponent('backend', 'installation-date')->OPTION_NAME_INSTALL_DATE, date('Y-m-d'));
		}
	}
}
