<?php

/**
 * config.class.php
 *
 * @author Dominik Kocuj <dominik@kocuj.pl>
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU General Public License v2 or later
 * @copyright Copyright (c) 2013-2016 Dominik Kocuj
 * @package kocuj_sitemap
 */

// set namespace
namespace KocujSitemapPlugin\Classes;

// security
if ((!defined('ABSPATH')) || ((isset($_SERVER['SCRIPT_FILENAME'])) && (basename($_SERVER['SCRIPT_FILENAME']) === basename(__FILE__)))) {
	header('HTTP/1.1 404 Not Found');
	die();
}

/**
 * Plugin configuration class
 *
 * @access public
 */
class Config extends \KocujInternalLib\V3a\Classes\Project\Components\All\Config\Component {
	/**
	 * Constructor
	 *
	 * @access public
	 * @param object $projectObj \KocujInternalLib\V3a\Classes\Project object for current project
	 * @return void
	 */
	public function __construct($projectObj) {
		// execute parent constructor
		parent::__construct($projectObj);
		// set container name
		$this->containerName = 'kocujsitemap_options';
		$this->containerMultisiteName = 'kocujsitemap_options_mu';
	}

	/**
	 * Initialization after adding to Kocuj Internal Lib object
	 *
	 * @access public
	 * @return void
	 */
	public function initAfterAddToAdmin() {
		// execute parent method
		parent::initAfterAddToAdmin();
		// add types
		$this->addType('numericH', 'typeNumericH', 'typeUpdateNumeric', 'typeGetNumeric');
		// add options
		$this->addOption('PoweredBy', '0', 'checkbox', __('Display `powered by` information below sitemap', 'kocuj-sitemap'), false, array(), false, 0, false);
		$this->addOption('UseHTML5', '1', 'checkbox', __('Use HTML 5 tags', 'kocuj-sitemap'), false, array(), false, 0, false);
		$this->addOption('LinkToMainSite', '1', 'checkbox', __('Display link to main site', 'kocuj-sitemap'), false, array(), false, 0, false);
		$this->addOption('DisplaySections', '1', 'checkbox', __('Divide display into sections', 'kocuj-sitemap'), false, array(), false, 0, false);
		$this->addOption('HLevelMain', '2', 'numericH', __('Header text level value for each section', 'kocuj-sitemap'), false, array(), false, 0, false);
		$this->addOption('HLevelWidget', '4', 'numericH', __('Header text level value for each section in widget', 'kocuj-sitemap'), false, array(), false, 0, false);
		$this->addOption('MarginLeft', '0', 'numericplus', __('Force left margin in pixels for each level on multi-level list', 'kocuj-sitemap'), false, array(), false, 0, false);
		$this->addOption('ButtonEditor', '1', 'checkbox', __('Enable sitemap button in visual and HTML editor', 'kocuj-sitemap'), false, array(), false, 0, false);
		$this->addOption('Cache', '1', 'checkbox', __('Enable cache', 'kocuj-sitemap'), false, array(), false, 0, false);
		$this->addOption('CacheFrontend', '0', 'checkbox', __('Generate cache on the website instead of in the administration panel', 'kocuj-sitemap'), false, array(), false, 0, false);
		$this->addOption('CacheAdditionalCompress', '0', 'checkbox', __('Enable additional compression of cache', 'kocuj-sitemap'), false, array(), false, 0, false);
		$def = array();
		$types = Sitemap::getInstance()->getElementsTypes(true);
		if (!empty($types)) {
			$def = array_keys($types);
		}
		$this->addOption('OrderList', $def, 'string', __('Order of elements', 'kocuj-sitemap'), true, array(
			'allowreorganize'   => true,
			'allowclose'        => false,
			'addonlastnotempty' => false,
			'removeonempty'     => false,
			'addbutton'         => false,
			'marginleft'        => 310,
			'verticalcenter'    => 9,
		), false, 0, false);
		$types = Sitemap::getInstance()->getElementsTypes();
		if (!empty($types)) {
			foreach ($types as $key => $val) {
				if ($val['object']->checkExists()) {
					$options = $val['object']->getConfigOptions();
					if (!empty($options)) {
						foreach ($options as $option) {
							$this->addOption($option[0], $option[1], $option[2], $option[3], $option[4], $option[5], $option[6], $option[7], false);
						}
					}
				}
			}
		}
		// add multi-language plugins options
		$this->addOption('Multilang', '', 'string', __('Use plugin for multiple languages', 'kocuj-sitemap'), false, array(), false, 0, false);
		// add options for section names
		$types = Sitemap::getInstance()->getElementsTypes();
		$languages = MultipleLanguages::getInstance()->getLanguages();
		if ((!empty($types)) && (!empty($languages))) {
			foreach ($types as $key => $type) {
				$options = $this->getSitemapTypeLanguagesOptionsNames($key);
				if (!empty($options)) {
					foreach ($options as $option) {
						$this->addOption($option['option'], '', 'string', __('Section title', 'kocuj-sitemap'), false, array(), false, 0, false);
					}
				}
			}
		}
	}

	/**
	 * Get sitemap type languages options names
	 *
	 * @access public
	 * @param string $type Sitemap type
	 * @return array Sitemap type languages options names
	 */
	public function getSitemapTypeLanguagesOptionsNames($type) {
		// initialize
		$options = array();
		// get languages options names for type
		$object = Sitemap::getInstance()->getElementTypeObject($type);
		if ($object->checkSectionName()) {
			$data = Sitemap::getInstance()->getElementType($type);
			if (!empty($data)) {
				$options[] = array(
					'option'   => 'SectionName_'.$type.'_en_US',
					'language' => 'en_US',
				);
				$languages = MultipleLanguages::getInstance()->getLanguages();
				if (!empty($languages)) {
					foreach ($languages as $language) {
						if (($language !== 'en_US') && ($language !== 'en')) {
							$options[] = array(
								'option'   => 'SectionName_'.$type.'_'.$language,
								'language' => $language,
							);
						}
					}
				}
			}
		}
		// exit
		return $options;
	}

	/**
	 * Check option value - numeric
	 *
	 * @access public
	 * @param string $name Option name
	 * @param array $option Option settings
	 * @param array|bool|float|int|string $value Value to check
	 * @param string &$error Returned error text
	 * @return bool Status - true or false
	 */
	public function typeNumericH($name, array $option, $value, &$error) {
		// check value
		$ok = false;
		if ($value === '') {
			$value = 0;
		}
		if (is_numeric($value)) {
			$ok = true;
		}
		if (!$ok) {
			$error = '"'.$option[3].'" '.__('should be numeric', 'kocuj-sitemap');
		} else {
			if (($value < 1) || ($value > 6)) {
				$error = '"'.$option[3].'" '.__('must be between 1 and 6', 'kocuj-sitemap');
				$ok = false;
			}
		}
		// exit
		return $ok;
	}
}
