<?php

/**
 * component.class.php
 *
 * @author Dominik Kocuj <dominik@kocuj.pl>
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU General Public License v2 or later
 * @copyright Copyright (c) 2016 Dominik Kocuj
 * @package kocuj_internal_lib
 */

// set namespace
namespace KocujInternalLib\V4a\Classes\Project\Components\Backend\EditorTextButtons;

// security
if ((!defined('ABSPATH')) || ((isset($_SERVER['SCRIPT_FILENAME'])) && (basename($_SERVER['SCRIPT_FILENAME']) === basename(__FILE__)))) {
	header('HTTP/1.1 404 Not Found');
	die();
}

/**
 * Text editor buttons class
 *
 * @access public
 */
class Component extends \KocujInternalLib\V4a\Classes\ComponentObject {
	/**
	 * Buttons
	 *
	 * @access private
	 * @var array
	 */
	private $buttons = array();

	/**
	 * Add button to text editor
	 *
	 * @access public
	 * @param string $id Button id; must be unique for this project
	 * @param string $title Button title
	 * @param string $helpText Help text for button
	 * @param string $codeBegin Begin of code added after clicking on button
	 * @param string $codeEnd End of code added after clicking on button
	 * @param int $priority Button priority - default: empty
	 * @param string $accessKey Access key - default: empty
	 * @return void
	 */
	public function addButton($id, $title, $helpText, $codeBegin, $codeEnd, $priority = 0, $accessKey = '') {
		// check if button does not exist already
		if (isset($this->buttons[$id])) {
			return;
		}
		// add button
		$this->buttons[$id] = array(
			'title'     => $title,
			'helptext'  => $helpText,
			'codebegin' => $codeBegin,
			'codeend'   => $codeEnd,
			'priority'  => $priority,
			'accesskey' => $accessKey,
		);
	}

	/**
	 * Action for show text editor buttons
	 *
	 * @access public
	 * @return void
	 */
	public function actionPrintFooterScripts() {
		// check if Quicktags script is active
		if (!wp_script_is('quicktags')) {
			return;
		}
		// show text editor buttons
		if (!empty($this->buttons)) {
			?>
				<script type="text/javascript">
				/* <![CDATA[ */
					(function($) {
						$(document).ready(function() {
							<?php
								foreach ($this->buttons as $id => $button) {
									echo 'QTags.addButton(\''.esc_js($this->getProjectObj()->getComponent('core', 'project-helper')->getPrefix().'__'.$id).'\', \''.esc_js($button['title']).'\', \''.esc_js($button['codebegin']).'\', \''.esc_js($button['codeend']).'\', \''.esc_js($button['accesskey']).'\', \''.esc_js($button['helptext']).'\', \''.esc_js($button['priority']).'\');'.PHP_EOL;
								}
							?>
						});
					}(jQuery));
				/* ]]> */
				</script>
			<?php
		}
	}
}
