<?php

/**
 * init.class.php
 *
 * @author Dominik Kocuj <dominik@kocuj.pl>
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU General Public License v2 or later
 * @copyright Copyright (c) 2016 Dominik Kocuj
 * @package kocuj_internal_lib
 */

// set namespace
namespace KocujInternalLib\V4a\Classes\Project\Components\Backend\EditorTextButtons;

// security
if ((!defined('ABSPATH')) || ((isset($_SERVER['SCRIPT_FILENAME'])) && (basename($_SERVER['SCRIPT_FILENAME']) === basename(__FILE__)))) {
	header('HTTP/1.1 404 Not Found');
	die();
}

/**
 * Text editor buttons (component initialization) class
 *
 * @access public
 */
class Init extends \KocujInternalLib\V4a\Classes\ComponentInitObject {
	/**
	 * Constructor
	 *
	 * @access public
	 * @param object $projectObj \KocujInternalLib\V4a\Classes\Project object for current project
	 * @return void
	 */
	public function __construct($projectObj) {
		// execute parent
		parent::__construct($projectObj);
		// add actions
		$this->getProjectObj()->getComponent('core', 'actions-filters-helper')->addActionWhenNeeded('admin_print_footer_scripts', 'backend', 'editor-text-buttons', '', 'actionPrintFooterScripts', \KocujInternalLib\V4a\Classes\Helper::getInstance()->calculateMaxPriority('admin_print_footer_scripts'));
	}
}
