<?php

/**
 * init.class.php
 *
 * @author Dominik Kocuj <dominik@kocuj.pl>
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU General Public License v2 or later
 * @copyright Copyright (c) 2016 Dominik Kocuj
 * @package kocuj_internal_lib
 */

// set namespace
namespace KocujInternalLib\V5a\Classes\Project\Components\Backend\ReviewMessage;

// security
if ((!defined('ABSPATH')) || ((isset($_SERVER['SCRIPT_FILENAME'])) && (basename($_SERVER['SCRIPT_FILENAME']) === basename(__FILE__)))) {
	header('HTTP/1.1 404 Not Found');
	die();
}

/**
 * Review message (component initialization) class
 *
 * @access public
 */
class Init extends \KocujInternalLib\V5a\Classes\ComponentInitObject {
	/**
	 * Required components
	 *
	 * @access protected
	 * @var array
	 */
	protected $requiredComponents = array(
		'' => array(
			'all' => array(
				'js-ajax',
			),
			'backend' => array(
				'installation-date',
				'message',
			),
		),
	);

	/**
	 * Constructor
	 *
	 * @access public
	 * @param object $projectObj \KocujInternalLib\V5a\Classes\Project object for current project
	 * @return void
	 */
	public function __construct($projectObj) {
		// execute parent
		parent::__construct($projectObj);
		// add uninstall action
		$this->getProjectObj()->getComponent('core', 'actions-filters-helper')->addActionWhenNeeded($this->getProjectObj()->getComponent('core', 'project-helper')->getPrefix().'__plugin_uninstall', 'backend', 'review-message', '', 'actionPluginUninstall', 1);
		// add actions
		if ((current_user_can('manage_network')) || (current_user_can('manage_options'))) {
			$this->getProjectObj()->getComponent('core', 'actions-filters-helper')->addActionWhenNeeded('admin_head', 'backend', 'review-message', '', 'actionAdminHead', 1);
			$this->getProjectObj()->getComponent('core', 'actions-filters-helper')->addActionWhenNeeded('admin_print_footer_scripts', 'backend', 'review-message', '', 'actionPrintFooterScripts', \KocujInternalLib\V5a\Classes\Helper::getInstance()->calculateMaxPriority('admin_print_footer_scripts'));
		}
		// add actions for AJAX
		if ((current_user_can('manage_network')) || (current_user_can('manage_options'))) {
			$this->getProjectObj()->getComponent('core', 'actions-filters-helper')->addActionWhenNeeded('wp_ajax_'.$this->getProjectObj()->getComponent('core', 'project-helper')->getPrefix().'__review_message_close', 'backend', 'review-message', 'ajax', 'actionAjaxClose');
		}
	}
}
