<?php

/**
 * init.class.php
 *
 * @author Dominik Kocuj <dominik@kocuj.pl>
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU General Public License v2 or later
 * @copyright Copyright (c) 2016 Dominik Kocuj
 * @package kocuj_internal_lib
 */

// set namespace
namespace KocujInternalLib\V5a\Classes\Project\Components\All\JsAjax;

// security
if ((!defined('ABSPATH')) || ((isset($_SERVER['SCRIPT_FILENAME'])) && (basename($_SERVER['SCRIPT_FILENAME']) === basename(__FILE__)))) {
	header('HTTP/1.1 404 Not Found');
	die();
}

/**
 * Configuration (component initialization) class
 *
 * @access public
 */
class Init extends \KocujInternalLib\V5a\Classes\ComponentInitObject {
	/**
	 * Constructor
	 *
	 * @access public
	 * @param object $projectObj \KocujInternalLib\V5a\Classes\Project object for current project
	 * @return void
	 */
	public function __construct($projectObj) {
		// execute parent
		parent::__construct($projectObj);
		// add actions for AJAX
		$this->getProjectObj()->getComponent('core', 'actions-filters-helper')->addActionWhenNeeded('wp_ajax_'.$this->getProjectObj()->getComponent('core', 'project-helper')->getPrefix().'__js_ajax', 'all', 'js-ajax', 'ajax', 'actionAjaxProxy');
	}
}
