<?php

/**
 * component.class.php
 *
 * @author Dominik Kocuj <dominik@kocuj.pl>
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU General Public License v2 or later
 * @copyright Copyright (c) 2016 Dominik Kocuj
 * @package kocuj_internal_lib\kocuj_pl_lib
 */

// set namespace
namespace KocujPlLib\V5a\Classes\Project\Components\Backend\AddThanks;

// security
if ((!defined('ABSPATH')) || ((isset($_SERVER['SCRIPT_FILENAME'])) && (basename($_SERVER['SCRIPT_FILENAME']) === basename(__FILE__)))) {
	header('HTTP/1.1 404 Not Found');
	die();
}

/**
 * Adding thanks class
 *
 * @access public
 */
class Component extends \KocujInternalLib\V5a\Classes\ComponentObject {
	/**
	 * Option name - thanks added
	 *
	 */
	const OPTION_NAME_THANKS_ADDED = 'thanks_added';

	/**
	 * Adding thanks is set to be displayed (true) or adding thanks will not be displayed (false)
	 *
	 * @access private
	 * @var bool
	 */
	private $addThanksDisplay = false;

	/**
	 * Set adding thanks to display (true) or not (false)
	 *
	 * @access public
	 * @param bool $addThanksDisplay Adding thanks will be displayed (true) or not (false)
	 * @return void
	 */
	public function setAddThanksDisplay($addThanksDisplay) {
		// set value
		$this->addThanksDisplay = $addThanksDisplay;
		// add "scripts
		if ($addThanksDisplay) {
			\KocujInternalLib\V5a\Classes\JsHelper::getInstance()->addHelperJS(true);
			\KocujInternalLib\V5a\Classes\JsHelper::getInstance()->addExceptionJS(true);
			\KocujInternalLib\V5a\Classes\JsHelper::getInstance()->addModalJS(true);
			$this->getProjectObj()->getProjectKocujInternalLibObj()->getComponent('all', 'js-ajax')->addAjaxJS();
			if (\KocujInternalLib\V5a\Classes\JsHelper::getInstance()->getThrowErrors()) {
				\KocujInternalLib\V5a\Classes\JsHelper::getInstance()->addScript(\KocujPlLib\V5a\Classes\Helper::getInstance()->getPrefix().'-exception-code', \KocujPlLib\V5a\Classes\LibUrls::getInstance()->getJavaScriptUrl(), 'exception-code', array(), \KocujPlLib\V5a\Classes\Version::getInstance()->getVersion(), true);
				\KocujInternalLib\V5a\Classes\JsHelper::getInstance()->addScript(\KocujPlLib\V5a\Classes\Helper::getInstance()->getPrefix().'-exception', \KocujPlLib\V5a\Classes\LibUrls::getInstance()->getJavaScriptUrl(), 'exception', array(
					\KocujInternalLib\V5a\Classes\Helper::getInstance()->getPrefix().'-exception',
					\KocujPlLib\V5a\Classes\Helper::getInstance()->getPrefix().'-exception-code',
				), \KocujPlLib\V5a\Classes\Version::getInstance()->getVersion(), true);
			}
		}
	}

	/**
	 * Get if thanks has been added (true) or not (false)
	 *
	 * @access public
	 * @return bool Thanks has been added (true) or not (false)
	 */
	public function getThanksAddedOptionValue() {
		// exit
		return ($this->getProjectObj()->getProjectKocujInternalLibObj()->getComponent('core', 'meta')->getOption(self::OPTION_NAME_THANKS_ADDED) === false) ?
			false :
			true;
	}

	/**
	 * Action for adding JavaScript scripts
	 *
	 * @access public
	 * @return void
	 */
	public function actionAdminFooter() {
		// add scripts
		if ((!$this->getThanksAddedOptionValue()) && ($this->addThanksDisplay)) {
			$deps = array(
				'jquery',
				\KocujInternalLib\V5a\Classes\Helper::getInstance()->getPrefix().'-helper',
				\KocujInternalLib\V5a\Classes\Helper::getInstance()->getPrefix().'-all-js-ajax',
				\KocujInternalLib\V5a\Classes\Helper::getInstance()->getPrefix().'-modal',
			);
			if (\KocujInternalLib\V5a\Classes\JsHelper::getInstance()->getThrowErrors()) {
				$deps[] = \KocujPlLib\V5a\Classes\Helper::getInstance()->getPrefix().'-exception';
			}
			\KocujInternalLib\V5a\Classes\JsHelper::getInstance()->addScript(\KocujPlLib\V5a\Classes\Helper::getInstance()->getPrefix().'-backend-add-thanks', \KocujPlLib\V5a\Classes\LibUrls::getInstance()->getJavaScriptUrl().'/project/components/backend/add-thanks', 'add-thanks', $deps, \KocujPlLib\V5a\Classes\Version::getInstance()->getVersion(), true, true, 'kocujPLV5aBackendAddThanksVals', array(
				'prefix'                 => \KocujPlLib\V5a\Classes\Helper::getInstance()->getPrefix(),
				'prefixKocujIL'          => \KocujInternalLib\V5a\Classes\Helper::getInstance()->getPrefix(),
				'security'               => wp_create_nonce(\KocujPlLib\V5a\Classes\Helper::getInstance()->getPrefix().'__add_thanks'),
				'websiteUrl'             => get_home_url(),
				'websiteTitle'           => get_bloginfo('name', 'display'),
				'websiteDescription'     => get_bloginfo('description', 'display'),
				'textMoreInfoLink'       => $this->getProjectObj()->getStringsObj('backend', 'add-thanks')->getString('ACTION_ADMIN_FOOTER_SCRIPT_MORE_INFO_LINK'),
				'textWindowTitle'        => $this->getProjectObj()->getStringsObj('backend', 'add-thanks')->getString('ACTION_ADMIN_FOOTER_SCRIPT_WINDOW_TITLE'),
				'textWindowLoading'      => $this->getProjectObj()->getStringsObj('backend', 'add-thanks')->getString('ACTION_ADMIN_FOOTER_SCRIPT_WINDOW_LOADING'),
				'textWindowLoadingError' => $this->getProjectObj()->getStringsObj('backend', 'add-thanks')->getString('ACTION_ADMIN_FOOTER_SCRIPT_WINDOW_LOADING_ERROR'),
				'textSending'            => $this->getProjectObj()->getStringsObj('backend', 'add-thanks')->getString('ACTION_ADMIN_FOOTER_SCRIPT_SENDING'),
				'textError'              => $this->getProjectObj()->getStringsObj('backend', 'add-thanks')->getString('ACTION_ADMIN_FOOTER_SCRIPT_ERROR'),
				'textErrorNoRetries'     => $this->getProjectObj()->getStringsObj('backend', 'add-thanks')->getString('ACTION_ADMIN_FOOTER_SCRIPT_ERROR_NO_RETRIES'),
				'textErrorAlreadyExists' => $this->getProjectObj()->getStringsObj('backend', 'add-thanks')->getString('ACTION_ADMIN_FOOTER_SCRIPT_ERROR_ALREADY_EXISTS'),
				'textErrorWrongResponse' => $this->getProjectObj()->getStringsObj('backend', 'add-thanks')->getString('ACTION_ADMIN_FOOTER_SCRIPT_ERROR_WRONG_RESPONSE'),
				'textSuccess'            => $this->getProjectObj()->getStringsObj('backend', 'add-thanks')->getString('ACTION_ADMIN_FOOTER_SCRIPT_SUCCESS'),
				'imageLoadingUrl'        => \KocujPlLib\V5a\Classes\LibUrls::getInstance()->getImagesUrl().'/project/components/backend/add-thanks/loading.gif',
			), true);
		}
	}

	/**
	 * Action for uninstall plugin
	 *
	 * @access public
	 * @return void
	 */
	public function actionPluginUninstall() {
		// remove option
		$this->getProjectObj()->getProjectKocujInternalLibObj()->getComponent('core', 'meta')->deleteOption(self::OPTION_NAME_THANKS_ADDED);
	}
}
