<?php

/**
 * component.class.php
 *
 * @author Dominik Kocuj <dominik@kocuj.pl>
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU General Public License v2 or later
 * @copyright Copyright (c) 2016 Dominik Kocuj
 * @package kocuj_internal_lib
 */

// set namespace
namespace KocujInternalLib\V5a\Classes\Project\Components\Backend\PageAbout;

// security
if ((!defined('ABSPATH')) || ((isset($_SERVER['SCRIPT_FILENAME'])) && (basename($_SERVER['SCRIPT_FILENAME']) === basename(__FILE__)))) {
	header('HTTP/1.1 404 Not Found');
	die();
}

/**
 * About page class
 *
 * @access public
 */
class Component extends \KocujInternalLib\V5a\Classes\ComponentObject {
	/**
	 * Data
	 *
	 * @access private
	 * @var array
	 */
	private $data = array();

	/**
	 * Set page data
	 *
	 * @access public
	 * @param array $data Page data; there are available the following attributes: "additionalinfo1" (string type; first additional information to add to page), "additionalinfo2" (string type; second additional information to add to page), "imagefilename" (string type; filename of image to add at the top of the page)
	 * @return void
	 */
	public function setPageData(array $data) {
		// set page data
		$this->data = array();
		if (isset($data['imagefilename'])) {
			$this->data['imagefilename'] = $data['imagefilename'];
		}
		if (isset($data['additionalinfo1'])) {
			$this->data['additionalinfo1'] = $data['additionalinfo1'];
		}
		if (isset($data['additionalinfo2'])) {
			$this->data['additionalinfo2'] = $data['additionalinfo2'];
		}
	}

	/**
	 * Show page with information about plugin or theme
	 *
	 * @access public
	 * @return void
	 */
	public function showPage() {
		// add action before page
		$this->getProjectObj()->getComponent('core', 'project-helper')->doAction('before_page_about_div');
		// show begin div
		echo '<div'.$this->getProjectObj()->getComponent('core', 'project-helper')->applyFiltersForHTMLStyleAndClass('page_about_div').' id="'.$this->getProjectObj()->getComponent('core', 'project-helper')->getPrefix().'__div_page_about">';
		$this->getProjectObj()->getComponent('core', 'project-helper')->doAction('before_page_about');
		// optionally show image
		if (isset($this->data['imagefilename'])) {
			// check if file exists
			$filename = $this->getProjectObj()->getComponent('core', 'dirs')->getCustomImagesDir().'/'.$this->data['imagefilename'];
			if (is_file($filename)) {
				// show image
				echo \KocujInternalLib\V5a\Classes\HtmlHelper::getInstance()->getHTMLImage($this->getProjectObj()->getComponent('core', 'urls')->getCustomImagesUrl().'/'.$this->data['imagefilename'], array(
					'style' => 'width:100%;height:auto;',
				));
				echo '<br />';
			}
		}
		// show title
		$version = $this->getProjectObj()->getMainSettingVersion();
		echo '<strong>'.$this->getProjectObj()->getMainSettingTitleOriginal().((isset($version[0]) /* strlen($version) > 0 */ ) ?
				' v.'.$version :
				''
			).'</strong>';
		echo '<br />';
		// show project URL-s
		$url = $this->getProjectObj()->getMainSettingUrl();
		if (isset($url[0]) /* strlen($url) > 0 */ ) {
			echo \KocujInternalLib\V5a\Classes\HtmlHelper::getInstance()->getLinkAnchor($url, '', array(
				'external' => true,
			));
			echo '<br />';
		}
		// show news channels links
		$linkRSS = $this->getProjectObj()->getSettingArray('newschannels', 'rss');
		$linkFacebook = $this->getProjectObj()->getSettingArray('newschannels', 'facebook');
		$linkTwitter = $this->getProjectObj()->getSettingArray('newschannels', 'twitter');
		if ((isset($linkRSS[0]) /* strlen($linkRSS) > 0 */ ) || (isset($linkFacebook[0]) /* strlen($linkFacebook) > 0 */ ) || (isset($linkTwitter[0]) /* strlen($linkTwitter) > 0 */ )) {
			echo '<br />';
			if (isset($linkRSS[0]) /* strlen($linkRSS) > 0 */ ) {
				echo \KocujInternalLib\V5a\Classes\HtmlHelper::getInstance()->getHTMLImage(\KocujInternalLib\V5a\Classes\LibUrls::getInstance()->getImagesUrl().'/project/components/backend/page-about/icon-rss.png', array(
					'style' => 'float:left;',
				)).'&nbsp;'.\KocujInternalLib\V5a\Classes\HtmlHelper::getInstance()->getLinkAnchor($linkRSS, '', array(
					'external' => true,
				));
				echo '<div style="clear:both;"></div>';
			}
			if (isset($linkFacebook[0]) /* strlen($linkFacebook) > 0 */ ) {
				echo \KocujInternalLib\V5a\Classes\HtmlHelper::getInstance()->getHTMLImage(\KocujInternalLib\V5a\Classes\LibUrls::getInstance()->getImagesUrl().'/project/components/backend/page-about/icon-facebook.png', array(
					'style' => 'float:left;',
				)).'&nbsp;'.\KocujInternalLib\V5a\Classes\HtmlHelper::getInstance()->getLinkAnchor($linkFacebook, '', array(
					'external' => true,
				));
				echo '<div style="clear:both;"></div>';
			}
			if (isset($linkTwitter[0]) /* strlen($linkTwitter) > 0 */ ) {
				echo \KocujInternalLib\V5a\Classes\HtmlHelper::getInstance()->getHTMLImage(\KocujInternalLib\V5a\Classes\LibUrls::getInstance()->getImagesUrl().'/project/components/backend/page-about/icon-twitter.png', array(
					'style' => 'float:left;',
				)).'&nbsp;'.\KocujInternalLib\V5a\Classes\HtmlHelper::getInstance()->getLinkAnchor($linkTwitter, '', array(
					'external' => true,
				));
				echo '<div style="clear:both;"></div>';
			}
		}
		// show empty line
		echo '<br />';
		// show author information
		$author = $this->getProjectObj()->getSettingArray('author', 'name');
		if (isset($author[0]) /* strlen($author) > 0 */ ) {
			echo $this->getProjectObj()->getStringsObj('backend', 'page-about')->getString('SHOW_PAGE_AUTHOR').': '.$author;
			$authorUrl = $this->getProjectObj()->getSettingArray('author', 'url');
			if (isset($authorUrl[0]) /* strlen($authorUrl) > 0 */ ) {
				echo ' ('.\KocujInternalLib\V5a\Classes\HtmlHelper::getInstance()->getLinkAnchor($authorUrl, '', array(
					'external' => true,
				)).')';
			}
			$authorEmail = $this->getProjectObj()->getSettingArray('author', 'email');
			if (isset($authorEmail[0]) /* strlen($authorEmail) > 0 */ ) {
				echo ' &lt;'.\KocujInternalLib\V5a\Classes\HtmlHelper::getInstance()->getMailAnchor($authorEmail).'&gt;';
			}
			echo '<br />';
		}
		// show license information
		$licenseName = $this->getProjectObj()->getMainSettingLicenseName();
		if (isset($licenseName[0]) /* strlen($licenseName) > 0 */ ) {
			echo $this->getProjectObj()->getStringsObj('backend', 'page-about')->getString('SHOW_PAGE_LICENSE').': '.$this->getProjectObj()->getComponent('backend', 'license')->getLicenseLink();
			echo '<br /><br />';
		}
		// show icons license information
		printf($this->getProjectObj()->getStringsObj('backend', 'page-about')->getString('SHOW_PAGE_LICENSE_ICONS'), \KocujInternalLib\V5a\Classes\HtmlHelper::getInstance()->getLinkAnchor('http://useiconic.com/open/', '', array(
			'external' => true,
		)), \KocujInternalLib\V5a\Classes\HtmlHelper::getInstance()->getLinkAnchor('https://opensource.org/licenses/MIT/', 'MIT', array(
			'external' => true,
		)), \KocujInternalLib\V5a\Classes\HtmlHelper::getInstance()->getLinkAnchor('http://wusoftware.pl/', '', array(
			'external' => true,
		)), \KocujInternalLib\V5a\Classes\HtmlHelper::getInstance()->getLinkAnchor('http://www.gnu.org/licenses/gpl-2.0.html', 'GPL', array(
			'external' => true,
		)));
		echo '<br /><br />';
		// show first additional information
		if (isset($this->data['additionalinfo1'])) {
			echo $this->data['additionalinfo1'];
			echo '<br /><br />';
		}
		// show second additional information
		if (isset($this->data['additionalinfo2'])) {
			echo $this->data['additionalinfo2'];
			echo '<br /><br />';
		}
		// show support information
		$supportEmail = $this->getProjectObj()->getSettingArray('support', 'email');
		$supportUrl = $this->getProjectObj()->getSettingArray('support', 'url');
		if ((isset($supportEmail[0]) /* strlen($supportEmail) > 0 */ ) || (isset($supportUrl[0]) /* strlen($supportUrl) > 0 */ )) {
			echo '<hr />';
			echo '<br />';
			echo $this->getProjectObj()->getStringsObj('backend', 'page-about')->getString('SHOW_PAGE_SUPPORT_BUGS_FEATURES').':';
			echo '<br />';
			if (isset($supportEmail[0]) /* strlen($supportEmail) > 0 */ ) {
				echo \KocujInternalLib\V5a\Classes\HtmlHelper::getInstance()->getHTMLImage(\KocujInternalLib\V5a\Classes\LibUrls::getInstance()->getImagesUrl().'/project/components/backend/page-about/support-email.png', array(
					'style' => 'float:left;',
				)).'&nbsp;'.\KocujInternalLib\V5a\Classes\HtmlHelper::getInstance()->getMailAnchor($supportEmail);
				echo '<div style="clear:both;"></div>';
			}
			if (isset($supportUrl[0]) /* strlen($supportUrl) > 0 */ ) {
				echo \KocujInternalLib\V5a\Classes\HtmlHelper::getInstance()->getHTMLImage(\KocujInternalLib\V5a\Classes\LibUrls::getInstance()->getImagesUrl().'/project/components/backend/page-about/support-url.png', array(
					'style' => 'float:left;',
				)).'&nbsp;'.\KocujInternalLib\V5a\Classes\HtmlHelper::getInstance()->getLinkAnchor($supportUrl, '', array(
					'external' => true,
				));
				echo '<div style="clear:both;"></div>';
			}
			echo '<br />';
		}
		// show information about telling others about this plugin or theme
		$url = $this->getProjectObj()->getMainSettingUrl();
		if (isset($url[0]) /* strlen($url) > 0 */ ) {
			$tellFacebookUrl = $this->getProjectObj()->getSettingArray('tellothers', 'facebook');
			$tellTwitterUrl = $this->getProjectObj()->getSettingArray('tellothers', 'twitter');
			if ((isset($tellFacebookUrl[0]) /* strlen($tellFacebookUrl) > 0 */ ) || (isset($tellTwitterUrl[0]) /* strlen($tellTwitterUrl) > 0 */ )) {
				echo '<hr />';
				echo '<br />';
				echo '<strong>';
				if ($this->getProjectObj()->getMainSettingType() === \KocujInternalLib\V5a\Enums\ProjectType::PLUGIN) {
					echo $this->getProjectObj()->getStringsObj('backend', 'page-about')->getString('SHOW_PAGE_TELL_OTHERS_PLUGIN');
				}
				if ($this->getProjectObj()->getMainSettingType() === \KocujInternalLib\V5a\Enums\ProjectType::THEME) {
					echo $this->getProjectObj()->getStringsObj('backend', 'page-about')->getString('SHOW_PAGE_TELL_OTHERS_THEME');
				}
				echo '</strong>';
				echo '<br />';
				if (isset($tellFacebookUrl[0]) /* strlen($tellFacebookUrl) > 0 */ ) {
					echo \KocujInternalLib\V5a\Classes\HtmlHelper::getInstance()->getLinkAnchor($tellFacebookUrl, \KocujInternalLib\V5a\Classes\HtmlHelper::getInstance()->getHTMLImage(\KocujInternalLib\V5a\Classes\LibUrls::getInstance()->getImagesUrl().'/project/components/backend/page-about/icon-facebook.png', array(
						'style' => 'float:left;',
					)), array(
						'external' => true,
					));
				}
				if (isset($tellTwitterUrl[0]) /* strlen($tellTwitterUrl) > 0 */ ) {
					echo \KocujInternalLib\V5a\Classes\HtmlHelper::getInstance()->getLinkAnchor($tellTwitterUrl, \KocujInternalLib\V5a\Classes\HtmlHelper::getInstance()->getHTMLImage(\KocujInternalLib\V5a\Classes\LibUrls::getInstance()->getImagesUrl().'/project/components/backend/page-about/icon-twitter.png', array(
						'style' => 'float:left;',
					)), array(
						'external' => true,
					));
				}
				echo '<div style="clear:both;"></div>';
				echo '<br />';
			}
		}
		// show end div
		$this->getProjectObj()->getComponent('core', 'project-helper')->doAction('after_page_about');
		echo '</div>';
		// add action after page
		$this->getProjectObj()->getComponent('core', 'project-helper')->doAction('after_page_about_div');
	}
}
