<?php

/**
 * multiple-languages-data.class.php
 *
 * @author Dominik Kocuj <dominik@kocuj.pl>
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU General Public License v2 or later
 * @copyright Copyright (c) 2013-2016 Dominik Kocuj
 * @package kocuj_sitemap
 */

// set namespace
namespace KocujSitemapPlugin\Classes;

// security
if ((!defined('ABSPATH')) || ((isset($_SERVER['SCRIPT_FILENAME'])) && (basename($_SERVER['SCRIPT_FILENAME']) === basename(__FILE__)))) {
	header('HTTP/1.1 404 Not Found');
	die();
}

/**
 * Multiple languages plugin class
 *
 * @access public
 */
class MultipleLanguagesData {
	/**
	 * Singleton instance
	 *
	 * @access private
	 * @var object
	 */
	private static $instance = NULL;

	/**
	 * Classes data for multi-languages plugins
	 *
	 * @access private
	 * @var array
	 */
	private $data = array();

	/**
	 * Multi-language plugins filenames
	 *
	 * @access private
	 * @var array
	 */
	private $pluginsFiles = array();

	/**
	 * Constructor
	 *
	 * @access private
	 * @return void
	 */
	private function __construct() {
		// set list of all multi-languages plugins classes
		$classes = array(
			'\\KocujSitemapPlugin\\Classes\\MultipleLanguages\\QTranslate'  => array(
				'original' => true,
			),
			'\\KocujSitemapPlugin\\Classes\\MultipleLanguages\\QTranslateX' => array(
				'original' => true,
			),
		);
		// get list of additional multi-languages plugins classes
		$additionalMultiLangClassesOld = apply_filters('kocujsitemap_additionalmultilangphpclasses', array()); // for compatibility with 1.x.x
		Base::getInstance()->filterOldInfo('kocujsitemap_additionalmultilangphpclasses', 'kocujsitemap_additional_multiple_languages_php_classes'); // for compatibility with 1.x.x
		$additionalMultiLangClasses = apply_filters('kocujsitemap_additional_multiple_languages_php_classes', array());
		$additionalMultiLangClasses = $additionalMultiLangClassesOld+$additionalMultiLangClasses;
		if (!empty($additionalMultiLangClasses)) {
			$additional = array();
			foreach ($additionalMultiLangClasses as $key => $val) {
				$additional[$val['class']] = $val;
				if (isset($classes[$val['class']])) {
					unset($additional[$val['class']]);
				} else {
					unset($additional[$val['class']]['class']);
				}
			}
			$classes = $classes+$additional;
		}
		// load all classes
		if (!empty($classes)) {
			// load all classes
			$keys = array_keys($classes);
			foreach ($keys as $key) {
				$class = $classes[$key];
				$ok = false;
				if ((isset($class['original'])) || ((isset($class['filename'])) && (is_file($class['filename']))) || ((isset($class['dir'])) && (is_file($class['dir'])))) {
					if (!isset($class['original'])) {
						if (isset($class['filename'])) {
							include $class['filename'];
						} else {
							if (isset($class['dir'])) { // for compatibility with 1.x.x
								include $class['dir']; // for compatibility with 1.x.x
							} // for compatibility with 1.x.x
						}
					}
					if ((isset($class['original'])) || (class_exists($key))) {
						$ok = true;
						$instance = call_user_func($key.'::getInstance');
						$version = 3;
						if (!isset($class['original'])) {
							$interfaces = class_implements($instance);
							if (!in_array('\\KocujSitemapPlugin\\Interfaces\\Language', $interfaces)) {
								if (in_array('\\KocujSitemapPlugin\\Interfaces\\MultipleLanguages', $interfaces)) { // for compatibility with 2.0.0-2.2.4
									$version = 2; // for compatibility with 2.0.0-2.2.4
								} else { // for compatibility with 2.0.0-2.2.4
									$version = 1; // for compatibility with 1.x.x
									$methodsV1 = array( // for compatibility with 1.x.x
										'getInstance', // for compatibility with 1.x.x
										'getName', // for compatibility with 1.x.x
										'getLanguages', // for compatibility with 1.x.x
										'checkPluginAdmin', // for compatibility with 1.x.x
										'checkPlugin', // for compatibility with 1.x.x
										'beforeGetBlogName', // for compatibility with 1.x.x
										'afterGetBlogName', // for compatibility with 1.x.x
										'getTranslatedBlogName', // for compatibility with 1.x.x
										'beforeGetHomeURL', // for compatibility with 1.x.x
										'afterGetHomeURL', // for compatibility with 1.x.x
										'getTranslatedHomeURL', // for compatibility with 1.x.x
										'beforeGetPages', // for compatibility with 1.x.x
										'afterGetPages', // for compatibility with 1.x.x
										'beforeGetPageItem', // for compatibility with 1.x.x
										'afterGetPageItem', // for compatibility with 1.x.x
										'getTranslatedPageURL', // for compatibility with 1.x.x
										'getTranslatedPageTitle', // for compatibility with 1.x.x
										'beforeGetPosts', // for compatibility with 1.x.x
										'afterGetPosts', // for compatibility with 1.x.x
										'beforeGetPostItem', // for compatibility with 1.x.x
										'afterGetPostItem', // for compatibility with 1.x.x
										'getTranslatedPostURL', // for compatibility with 1.x.x
										'getTranslatedPostTitle', // for compatibility with 1.x.x
										'beforeGetCategories', // for compatibility with 1.x.x
										'afterGetCategories', // for compatibility with 1.x.x
										'beforeGetCategoryItem', // for compatibility with 1.x.x
										'afterGetCategoryItem', // for compatibility with 1.x.x
										'getTranslatedCategoryURL', // for compatibility with 1.x.x
										'getTranslatedCategoryTitle', // for compatibility with 1.x.x
										'beforeGetMenu', // for compatibility with 1.x.x
										'afterGetMenu', // for compatibility with 1.x.x
										'beforeGetMenuItem', // for compatibility with 1.x.x
										'afterGetMenuItem', // for compatibility with 1.x.x
										'getTranslatedMenuURL', // for compatibility with 1.x.x
										'getTranslatedMenuTitle', // for compatibility with 1.x.x
									); // for compatibility with 1.x.x
									foreach ($methodsV1 as $method) { // for compatibility with 1.x.x
										if (!method_exists($instance, $method)) { // for compatibility with 1.x.x
											$ok = false; // for compatibility with 1.x.x
											break; // for compatibility with 1.x.x
										} // for compatibility with 1.x.x
									} // for compatibility with 1.x.x
								}
							}
						}
						if ($ok) {
							if (($version === 2) || ($version === 3)) {
								$this->pluginsFiles[] = $instance->getPluginFile();
							}
							$active = $instance->checkPlugin();
							if (!$active) {
								$ok = false;
							} else {
								$this->data[$key] = array(
									'instance' => $instance,
									'version'  => $version,
									'prior'    => (($version === 2) || ($version === 3)) ?
										$instance->getPriority() :
										9999, // for compatibility with 1.x.x
								);
								if ((is_admin()) || (is_network_admin())) {
									$activeAdmin = true;
									if ($version === 1) { // for compatibility with 1.x.x
										$activeAdmin = $instance->checkPluginAdmin(); // for compatibility with 1.x.x
									} // for compatibility with 1.x.x
									if ($activeAdmin) {
										$this->data[$key]['admin_id'] = $key;
										$this->data[$key]['admin_name'] = $instance->getName();
									}
								}
							}
						}
					}
				}
				if (!$ok) {
					unset($classes[$key]);
				} else {
					unset($classes[$key]['original']);
				}
			}
		}
	}

	/**
	 * Disable cloning of object
	 *
	 * @access private
	 * @return void
	 */
	private function __clone() {
	}

	/**
	 * Get singleton instance
	 *
	 * @access public
	 * @return object Singleton instance
	 */
	public static function getInstance() {
		// optionally create new instance
		if (!self::$instance) {
			self::$instance = new self();
		}
		// exit
		return self::$instance;
	}

	/**
	 * Get multi-language plugins data
	 *
	 * @access public
	 * @return array Get multi-language plugins data
	 */
	public function getData() {
		// get multi-language plugins data
		return $this->data;
	}

	/**
	 * Get multi-language plugins filename
	 *
	 * @access public
	 * @return array Get multi-language plugins filenames
	 */
	public function getPluginsFiles() {
		// exit
		return $this->pluginsFiles;
	}
}
