<?php

/**
 * component.class.php
 *
 * @author Dominik Kocuj <dominik@kocuj.pl>
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU General Public License v2 or later
 * @copyright Copyright (c) 2016 Dominik Kocuj
 * @package kocuj_internal_lib\kocuj_pl_lib
 */

// set namespace
namespace KocujPlLib\V5a\Classes\Project\Components\Backend\ReviewMessageAddThanks;

// security
if ((!defined('ABSPATH')) || ((isset($_SERVER['SCRIPT_FILENAME'])) && (basename($_SERVER['SCRIPT_FILENAME']) === basename(__FILE__)))) {
	header('HTTP/1.1 404 Not Found');
	die();
}

/**
 * Adding thanks from review message class
 *
 * @access public
 */
class Component extends \KocujInternalLib\V5a\Classes\ComponentObject {
	/**
	 * Review message with adding thanks is set to be displayed (true) or review message with adding thanks will not be displayed (false)
	 *
	 * @access private
	 * @var bool
	 */
	private $reviewMessageAddThanksDisplay = false;

	/**
	 * Action for displaying CSS stylesheet
	 *
	 * @access public
	 * @return void
	 */
	public function adminHead() {
		?>
			<style type="text/css" media="all">
			<!--
				#<?php echo $this->getProjectObj()->getComponent('core', 'project-helper')->getPrefix(); ?>__add_thanks_review_message_more_info_link_div {
					font-size: 12px;
				}

				.<?php echo $this->getProjectObj()->getComponent('core', 'project-helper')->getPrefix(); ?>__add_thanks_review_message_element_div {
					height: 50px;
				}

				@media screen and (max-width: 782px) {
					#<?php echo $this->getProjectObj()->getComponent('core', 'project-helper')->getPrefix(); ?>__add_thanks_review_message_more_info_link_div {
						font-size: 13px;
					}

					.<?php echo $this->getProjectObj()->getComponent('core', 'project-helper')->getPrefix(); ?>__add_thanks_review_message_element_div {
						height: 75px;
					}
				}
			-->
			</style>
		<?php
	}

	/**
	 * Filter for element class in review message
	 *
	 * @access public
	 * @param string $class Class
	 * @return string Class
	 */
	public function filterReviewMessageElementClass($class) {
		// exit
		return $class.((isset($class[0]) /* strlen($class) > 0 */ ) ?
				' ' :
				''
			).$this->getProjectObj()->getComponent('core', 'project-helper')->getPrefix().'__add_thanks_review_message_element_div';
	}

	/**
	 * Filter for elements before other elements in review message
	 *
	 * @access public
	 * @param array $elements Elements
	 * @return array Elements
	 */
	public function filterReviewMessageElementsBefore(array $elements) {
		// check if thanks has not been added already
		if ($this->getProjectObj()->getComponent('backend', 'add-thanks')->getThanksAddedOptionValue()) {
			return $elements;
		}
		// add element
		$elements[] = '<input type="button" class="button button-small" id="'.esc_attr($this->getProjectObj()->getComponent('core', 'project-helper')->getPrefix().'__add_thanks_review_message_send').'" value="'.esc_attr($this->getProjectObj()->getStringsObj('backend', 'review-message-add-thanks')->getString('FILTER_REVIEW_MESSAGE_ELEMENTS_BEFORE_ADD_THANKS')).'" />'.
			'<br />'.
			'<div id="'.esc_attr($this->getProjectObj()->getComponent('core', 'project-helper')->getPrefix().'__add_thanks_review_message_more_info_link_div').'">&nbsp;</div>';
		// add scripts
		$this->getProjectObj()->getComponent('backend', 'add-thanks')->setAddThanksDisplay(true);
		// set review message with adding thanks to be displayed
		$this->reviewMessageAddThanksDisplay = true;
		// exit
		return $elements;
	}

	/**
	 * Action for scripts
	 *
	 * @access public
	 * @return void
	 */
	public function actionPrintFooterScripts() {
		// initialize review message script
		if ($this->reviewMessageAddThanksDisplay) {
			?>
				<script type="text/javascript">
				/* <![CDATA[ */
					(function($) {
						$(document).ready(function() {
							kocujPLV5aBackendAddThanks.addProjectIfNotExists('<?php echo esc_js($this->getProjectObj()->getProjectKocujInternalLibObj()->getMainSettingInternalName()); ?>', '<?php echo esc_js($this->getProjectObj()->getSettingArray('api', 'url')); ?>', '<?php echo esc_js($this->getProjectObj()->getSettingArray('api', 'login')); ?>', '<?php echo esc_js($this->getProjectObj()->getSettingArray('api', 'password')); ?>');
							kocujPLV5aBackendAddThanks.setReviewMessageAddThanks('<?php echo esc_js($this->getProjectObj()->getProjectKocujInternalLibObj()->getMainSettingInternalName()); ?>');
						});
					}(jQuery));
				/* ]]> */
				</script>
			<?php
		}
	}
}
