<?php

/**
 * init.class.php
 *
 * @author Dominik Kocuj <dominik@kocuj.pl>
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU General Public License v2 or later
 * @copyright Copyright (c) 2016 Dominik Kocuj
 * @package kocuj_internal_lib
 */

// set namespace
namespace KocujPlLib\V5a\Classes\Project\Components\Backend\ReviewMessageAddThanks;

// security
if ((!defined('ABSPATH')) || ((isset($_SERVER['SCRIPT_FILENAME'])) && (basename($_SERVER['SCRIPT_FILENAME']) === basename(__FILE__)))) {
	header('HTTP/1.1 404 Not Found');
	die();
}

/**
 * Adding thanks from review message (component initialization) class
 *
 * @access public
 */
class Init extends \KocujInternalLib\V5a\Classes\ComponentInitObject {
	/**
	 * Required components
	 *
	 * @access protected
	 * @var array
	 */
	protected $requiredComponents = array(
		'' => array(
			'backend' => array(
				'add-thanks',
			),
		),
	);

	/**
	 * Constructor
	 *
	 * @access public
	 * @param object $projectObj \KocujInternalLib\V5a\Classes\Project object for current project
	 * @return void
	 */
	public function __construct($projectObj) {
		// execute parent
		parent::__construct($projectObj);
		// add filters and actions
		if ((!\KocujInternalLib\V5a\Classes\Helper::getInstance()->checkUserIPLocal()) && ((current_user_can('manage_network_plugins')) || (current_user_can('activate_plugins')) || (!current_user_can('install_plugins')))) {
			// add filters
			$this->getProjectObj()->getComponent('core', 'actions-filters-helper')->addFilterWhenNeeded('admin_head', 'backend', 'review-message-add-thanks', '', 'adminHead', \KocujInternalLib\V5a\Classes\Helper::getInstance()->calculateMaxPriority('admin_head'));
			$this->getProjectObj()->getComponent('core', 'actions-filters-helper')->addFilterWhenNeeded($this->getProjectObj()->getProjectKocujInternalLibObj()->getComponent('core', 'project-helper')->getPrefix().'__review_message_element_class', 'backend', 'review-message-add-thanks', '', 'filterReviewMessageElementClass');
			$this->getProjectObj()->getComponent('core', 'actions-filters-helper')->addFilterWhenNeeded($this->getProjectObj()->getProjectKocujInternalLibObj()->getComponent('core', 'project-helper')->getPrefix().'__review_message_elements_before', 'backend', 'review-message-add-thanks', '', 'filterReviewMessageElementsBefore');
			// add actions
			$this->getProjectObj()->getComponent('core', 'actions-filters-helper')->addActionWhenNeeded('admin_print_footer_scripts', 'backend', 'review-message-add-thanks', '', 'actionPrintFooterScripts', \KocujInternalLib\V5a\Classes\Helper::getInstance()->calculateMaxPriority('admin_print_footer_scripts'));
		}
	}
}
