<?php

/**
 * menu-type.class.php
 *
 * @author Dominik Kocuj <dominik@kocuj.pl>
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU General Public License v2 or later
 * @copyright Copyright (c) 2016 Dominik Kocuj
 * @package kocuj_internal_lib
 */

// set namespace
namespace KocujIL\V6a\Enums\Project\Components\Backend\SettingsMenu;

// security
if ((!defined('ABSPATH')) || ((isset($_SERVER['SCRIPT_FILENAME'])) && (basename($_SERVER['SCRIPT_FILENAME']) === basename(__FILE__)))) {
	header('HTTP/1.1 404 Not Found');
	die();
}

/**
 * Enumeration of settings menu parent type
 *
 * @access public
 */
class MenuType {
	/**
	 * Empty constructor for blocking of creating an instance of this class
	 *
	 * @access private
	 * @var void
	 */
	private function __construct() {}

	/**
	 * Site menu
	 *
	 */
	const SITE = 0;

	/**
	 * Network menu
	 *
	 */
	const NETWORK = 1;
}
