<?php

/**
 * ajax.class.php
 *
 * @author Dominik Kocuj <dominik@kocuj.pl>
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU General Public License v2 or later
 * @copyright Copyright (c) 2016 Dominik Kocuj
 * @package kocuj_internal_lib
 */

// set namespace
namespace KocujIL\V6a\Classes\Project\Components\Backend\VersionCheck;

// security
if ((!defined('ABSPATH')) || ((isset($_SERVER['SCRIPT_FILENAME'])) && (basename($_SERVER['SCRIPT_FILENAME']) === basename(__FILE__)))) {
	header('HTTP/1.1 404 Not Found');
	die();
}

/**
 * Version check AJAX class
 *
 * @access public
 */
class Ajax extends \KocujIL\V6a\Classes\ComponentObject {
	/**
	 * Action for displaying update information
	 *
	 * @access public
	 * @return void
	 */
	public function actionAjaxDisplay() {
		// check AJAX nonce
		check_ajax_referer(\KocujIL\V6a\Classes\Helper::getInstance()->getPrefix().'__version_info', 'security');
		// check versions of project
		if ((!isset($_POST['projectVersionFrom'])) || (!isset($_POST['projectVersionTo']))) {
			wp_die();
		}
		// get information
		$information = $this->getComponent('backend', 'version-check')->getInformation($_POST['projectVersionFrom']);
		// show information
		if ($information !== false) {
			echo str_replace('%2$s', $_POST['projectVersionTo'], str_replace('%1$s', $_POST['projectVersionFrom'], $information));
		}
		// remove request for information about update
		$this->getComponent('core', 'meta')->delete($this->getComponent('backend', 'version-check')->OPTION_NAME_REQ_UPDATE_INFO);
		// close connection
		wp_die();
	}
}
