<?php

/**
 * component-object.class.php
 *
 * @author Dominik Kocuj <dominik@kocuj.pl>
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU General Public License v2 or later
 * @copyright Copyright (c) 2016 Dominik Kocuj
 * @package kocuj_internal_lib
 */

// set namespace
namespace KocujIL\V6a\Classes;

// security
if ((!defined('ABSPATH')) || ((isset($_SERVER['SCRIPT_FILENAME'])) && (basename($_SERVER['SCRIPT_FILENAME']) === basename(__FILE__)))) {
	header('HTTP/1.1 404 Not Found');
	die();
}

/**
 * Component object class
 *
 * @access public
 */
class ComponentObject {
	/**
	 * \KocujIL\V6a\Classes\Project object for current project
	 *
	 * @access private
	 * @var object
	 */
	private $projectObj = NULL;

	/**
	 * Constructor
	 *
	 * @access public
	 * @param object $projectObj \KocujIL\V6a\Classes\Project object for current project
	 * @return void
	 */
	public function __construct($projectObj) {
		// remember project object
		$this->projectObj = $projectObj;
	}

	/**
	 * Get object of type \KocujIL\V6a\Classes\Project
	 *
	 * @access public
	 * @return object Object of type \KocujIL\V6a\Classes\Project
	 */
	public function getProjectObj() {
		// get object of type \KocujIL\V6a\Classes\Project
		return $this->projectObj;
	}

	/**
	 * Get object of class type from component
	 *
	 * @access public
	 * @param string $category Component category
	 * @param string $type Component type
	 * @param string $fragment Component fragment - default: empty
	 * @return object Object of class type from component
	 */
	public function getComponent($category, $type, $fragment = '') {
		// exit
		return $this->projectObj->get($category, $type, $fragment);
	}

	/**
	 * Get object of class type for strings from component
	 *
	 * @access public
	 * @param string $category Component category
	 * @param string $type Component type
	 * @return object Object of class type for strings from component
	 */
	public function getStrings($category, $type) {
		// exit
		return $this->projectObj->getStringsObj($category, $type);
	}

	/**
	 * Get value for class property or constant
	 *
	 * @access public
	 * @param string $key Class property or constant name
	 * @return array|bool|float|int|string Value for class property or constant
	 */
	public function __get($key) {
		// optionally get constant
		$reflection = new \ReflectionObject($this);
		if ($reflection->hasConstant($key)) {
			return $reflection->getConstant($key);
		}
		// exit
		return $this->$key;
	}
}
