/**
 * @file Exceptions handler errors codes
 *
 * @author Dominik Kocuj <dominik@kocuj.pl>
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU General Public License v2 or later
 * @copyright Copyright (c) 2016 Dominik Kocuj <dominik@kocuj.pl>
 */

(function() {})(); // empty function for correct minify with comments
//'use strict'; // for jshint uncomment this and comment line above

/* jshint strict: true */
/* jshint -W034 */

/**
 * Exception handler errors codes
 *
 * @namespace kocujILV6aExceptionCode
 * @public
 */
var kocujILV6aExceptionCode = {
	/**
	 * Error: OK
	 *
	 * @public
	 * @const {number}
	 */
	OK : 0,

	/**
	 * Error: Empty project identifier
	 *
	 * @public
	 * @const {number}
	 */
	EMPTY_PROJECT_ID : 1,

	/**
	 * Error: Project does not exist
	 *
	 * @public
	 * @const {number}
	 */
	PROJECT_DOES_NOT_EXIST : 2,

	/**
	 * Error: Project already exists
	 *
	 * @public
	 * @const {number}
	 */
	PROJECT_ALREADY_EXISTS : 3,

	/**
	 * Error: Empty element path
	 *
	 * @public
	 * @const {number}
	 */
	EMPTY_ELEMENT_PATH : 4,

	/**
	 * Error: Element does not exist
	 *
	 * @public
	 * @const {number}
	 */
	ELEMENT_DOES_NOT_EXIST : 5,

	/**
	 * Error: Empty URL for AJAX script
	 *
	 * @public
	 * @const {number}
	 */
	JS_AJAX_EMPTY_URL : 6,

	/**
	 * Error: Empty method for AJAX script
	 *
	 * @public
	 * @const {number}
	 */
	JS_AJAX_EMPTY_METHOD : 7,

	/**
	 * Error: Empty data type for AJAX script
	 *
	 * @public
	 * @const {number}
	 */
	JS_AJAX_EMPTY_DATA_TYPE : 8,

	/**
	 * Error: Modal window has been prepared already
	 *
	 * @public
	 * @const {number}
	 */
	MODAL_WINDOW_HAS_BEEN_PREPARED_ALREADY : 9,

	/**
	 * Error: Modal window has not been prepared
	 *
	 * @public
	 * @const {number}
	 */
	MODAL_WINDOW_HAS_NOT_BEEN_PREPARED : 10,

	/**
	 * Error: Wrong type of modal window
	 *
	 * @public
	 * @const {number}
	 */
	MODAL_WINDOW_WRONG_TYPE : 11,

	/**
	 * Error: Wrong width of modal window
	 *
	 * @public
	 * @const {number}
	 */
	MODAL_WINDOW_WRONG_WIDTH : 12,

	/**
	 * Error: Wrong height of modal window
	 *
	 * @public
	 * @const {number}
	 */
	MODAL_WINDOW_WRONG_HEIGHT : 13,

	/**
	 * Error: Wrong opacity of modal window
	 *
	 * @public
	 * @const {number}
	 */
	MODAL_WINDOW_WRONG_OPACITY : 14,

	/**
	 * Error: Modal window is visible
	 *
	 * @public
	 * @const {number}
	 */
	MODAL_WINDOW_VISIBLE : 15,

	/**
	 * Error: Close event for modal window exists already
	 *
	 * @public
	 * @const {number}
	 */
	MODAL_WINDOW_CLOSE_EVENT_EXISTS_ALREADY : 16,

	/**
	 * Error: Close event for modal window does not exist
	 *
	 * @public
	 * @const {number}
	 */
	MODAL_WINDOW_CLOSE_EVENT_DOES_NOT_EXIST : 17,

	/**
	 * Error: Wrong project type for version check script
	 *
	 * @public
	 * @const {number}
	 */
	VERSION_CHECK_WRONG_PROJECT_TYPE : 18,

	/**
	 * Error: Empty project name for version check script
	 *
	 * @public
	 * @const {number}
	 */
	VERSION_CHECK_EMPTY_PROJECT_NAME : 19,

	/**
	 * Error: Empty version from for version check script
	 *
	 * @public
	 * @const {number}
	 */
	VERSION_CHECK_EMPTY_VERSION_FROM : 20,

	/**
	 * Error: Empty version to for version check script
	 *
	 * @public
	 * @const {number}
	 */
	VERSION_CHECK_EMPTY_VERSION_TO : 21
};
