<?php

/**
 * helper.class.php
 *
 * @author Dominik Kocuj <dominik@kocuj.pl>
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU General Public License v2 or later
 * @copyright Copyright (c) 2016 Dominik Kocuj
 * @package kocuj_internal_lib\kocuj_pl_lib
 */

// set namespace
namespace KocujPlLib\V6a\Classes;

// security
if ((!defined('ABSPATH')) || ((isset($_SERVER['SCRIPT_FILENAME'])) && (basename($_SERVER['SCRIPT_FILENAME']) === basename(__FILE__)))) {
	header('HTTP/1.1 404 Not Found');
	die();
}

/**
 * Helper class
 *
 * @access public
 */
final class Helper {
	/**
	 * Singleton instance
	 *
	 * @access private
	 * @var object
	 */
	private static $instance = NULL;

	/**
	 * Constructor
	 *
	 * @access private
	 * @return void
	 */
	private function __construct() {
	}

	/**
	 * Disable cloning of object
	 *
	 * @access private
	 * @return void
	 */
	private function __clone() {
	}

	/**
	 * Get singleton instance
	 *
	 * @access public
	 * @return object Singleton instance
	 */
	public static function getInstance() {
		// optionally create new instance
		if (!self::$instance) {
			self::$instance = new self();
		}
		// exit
		return self::$instance;
	}

	/**
	 * Get prefix for some names in library
	 *
	 * @access public
	 * @return string Prefix
	 */
	public function getPrefix() {
		// exit
		return \KocujIL\V6a\Classes\Helper::getInstance()->getPrefix().'_kocujpllib'.Version::getInstance()->getVersionInternal();
	}

	/**
	 * Get URL to "kocuj.pl"
	 *
	 * @access public
	 * @param bool $withProtocol Get URL with protocol and ending slash (true) or only URL name (false)
	 * @return string URL to "kocuj.pl"
	 */
	public function getKocujPlUrl($withProtocol) {
		// exit
		return (($withProtocol) ?
				'http://' :
				''
			).'kocuj.pl'.(($withProtocol) ?
				'/' :
				''
			);
	}
}
